/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.user.Userdef;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model3.Audit;
import model3.SBdb;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsLink;

public class InterpHdr
extends Observable
implements Comparable,
SbugsLink {
    public static final String defaultText = "Default Version";
    private final SBdb sbdb;
    private final int interpID;
    private String description;
    private Audit audit = new Audit();
    private InterpHdr link = null;
    private static final String DEFAULT_SUFFIX_STRING = " (Default)";
    private static boolean DEFAULT_SUFFIX = false;

    private InterpHdr(SBdb db, int interpID, String description, Audit audit) {
        this.sbdb = db;
        this.interpID = interpID;
        this.description = description;
        this.audit = audit;
    }

    static InterpHdr copyToWorkspace(SBdb ws, InterpHdr hdr) {
        InterpHdr wsHdr = new InterpHdr(ws, hdr.interpID, hdr.description, new Audit(hdr.audit));
        wsHdr.link = hdr;
        return wsHdr;
    }

    public InterpHdr getLink() {
        return this.link;
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public void setLink(InterpHdr hdr) {
        this.link = hdr;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    InterpHdr(SBdb sbdb, int ID) throws SQLException {
        this.sbdb = sbdb;
        if (sbdb.isConnected()) {
            String sql = "SELECT descrip," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("INTERP") + " WHERE interp_id=" + ID;
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    this.interpID = ID;
                    this.description = rs.getString("descrip");
                    if (this.description == null || this.description.length() == 0) {
                        this.description = defaultText;
                    }
                    this.audit = new Audit(rs);
                } else {
                    this.description = defaultText;
                    this.interpID = 0;
                }
                stmt.close();
            }
        } else {
            this.description = defaultText;
            this.interpID = 0;
        }
    }

    public static void setDisplayDefault(boolean displayDefault) {
        DEFAULT_SUFFIX = displayDefault;
    }

    public String toString() {
        if (this.interpID == 0 && DEFAULT_SUFFIX && !this.description.equalsIgnoreCase(defaultText)) {
            return this.description + "  (Default)";
        }
        return this.description;
    }

    public int hashCode() {
        return this.interpID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof InterpHdr)) {
            return false;
        }
        InterpHdr rhs = (InterpHdr)o;
        return this.interpID == rhs.interpID && this.description.equals(rhs.description);
    }

    InterpHdr(SBdb sbdb, String description, Integer interpID) throws InvalidFieldException, SQLException {
        this.description = description;
        this.sbdb = sbdb;
        if (sbdb.isConnected()) {
            String sql = "SELECT interp_id FROM " + sbdb.DBTableName("INTERP") + " WHERE ucase(descrip)=" + SB.DBString((String)description.toUpperCase());
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    int tempInterpID = rs.getInt("interp_id");
                    throw new InvalidFieldException("A version of the name '" + description + "' already exists: ID number " + tempInterpID);
                }
                this.interpID = sbdb.nextControl("INTERP", "INTERP_ID");
                sql = "INSERT INTO " + sbdb.DBTableName("INTERP") + " (interp_id,descrip," + Audit.sqlFieldString() + ") VALUES (" + this.interpID + "," + SB.DBString((String)description) + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        } else {
            this.interpID = interpID;
        }
    }

    public boolean setDescription(String description) throws SBException, SQLException {
        if (description.equals(this.description)) {
            return false;
        }
        List<InterpHdr> c = this.sbdb.getInterps();
        for (Object e : c) {
            InterpHdr h = (InterpHdr)e;
            if (!h.description.equals(description)) continue;
            throw new SBException("Version already exists (ID=" + h.interpID);
        }
        if (this.sbdb != null && this.sbdb.isConnected()) {
            this.update(description);
        } else {
            this.description = description;
        }
        this.setChanged();
        return true;
    }

    public List findWells() throws SQLException {
        LinkedList wellList = new LinkedList();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            this.queryInterpTable(stmt, wellList, "IGD", "Zones");
            this.queryInterpTable(stmt, wellList, "IGD_ENV", "Palaeonvironments");
            this.queryInterpTable(stmt, wellList, "IGD_LSTRAT", "Lithostratigraphy");
            this.queryInterpTable(stmt, wellList, "BCMMNTS", "Comments");
            this.queryInterpTable(stmt, wellList, "SQPICK", "Picks");
            this.queryInterpTable(stmt, wellList, "INTCMMNTS", "Interval Comments");
            this.queryInterpTable(stmt, wellList, "EVENTS", "Events");
            this.queryInterpTable(stmt, wellList, "FAULTS", "Disconformities");
            this.queryInterpTable(stmt, wellList, "LOC", "Depth/Age curves");
        }
        return wellList;
    }

    private void queryInterpTable(Statement stmt, List wellList, String table, String tag) throws SQLException {
        String sql = "SELECT DISTINCT w.well_name,w.well_code FROM " + this.sbdb.DBTableName(table) + " i," + this.sbdb.DBTableName("WELLS") + " w WHERE i.well_id=w.well_id AND i.interp_id=" + this.interpID + " ORDER BY well_name";
        try (ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));){
            while (rs.next()) {
                String item = rs.getString("well_name") + " (" + rs.getString("well_code") + ") - " + tag;
                wellList.add(item);
            }
        }
    }

    public List findChartComponents() throws SQLException {
        LinkedList charts = new LinkedList();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            this.queryBlockTemplate(stmt, charts, "CHTBLOCKMBR", "Block member");
            this.queryCorrTemplate(stmt, charts, "CHTCORROCC", "Custom correlation scheme");
            this.queryCorrTemplate(stmt, charts, "CHTCORROCC_STD", "Standard event correlation");
            this.queryCorrTemplate(stmt, charts, "CHTCORROCC_STD_UNIT", "Standard unit correlation");
        }
        return charts;
    }

    private void queryBlockTemplate(Statement stmt, List wellList, String table, String tag) throws SQLException {
        String sql = "SELECT DISTINCT b.descr as block, p.descr as panel FROM " + this.sbdb.DBTableName(table) + " t," + this.sbdb.DBTableName("chtblock") + " b," + this.sbdb.DBTableName("chtpanl") + " p  WHERE t.block_id=b.block_id AND t.interp_id=" + this.interpID + " AND p.panel_id=t.panel_id";
        try (ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));){
            while (rs.next()) {
                String item = "Well block: " + rs.getString("block") + ", Panel: " + rs.getString("panel") + " - " + tag;
                wellList.add(item);
            }
        }
    }

    private void queryCorrTemplate(Statement stmt, List wellList, String table, String tag) throws SQLException {
        String sql = "SELECT DISTINCT c.descr as chart FROM " + this.sbdb.DBTableName(table) + " t," + this.sbdb.DBTableName("chart") + " c WHERE t.chart_id=c.chart_id AND t.interp_id=" + this.interpID;
        try (ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));){
            while (rs.next()) {
                String item = "Chart: " + rs.getString("chart") + " - " + tag;
                wellList.add(item);
            }
        }
    }

    void delete() throws SQLException, SBException {
        if (this.interpID == 0) {
            throw new SBException("You cannot delete the default version");
        }
        String[] tables = new String[]{"IGD", "IGD_LSTRAT", "SQPICK", "SBSSR", "IGD_ENV", "IGD_COLMAP", "INTCMMNTS", "BCMMNTS", "IGD_HDR", "FAULTS", "SBCHCLIN", "EVENTS", "LOCNODE", "LOC", "INTERP"};
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (String table : tables) {
                String sql = "DELETE FROM " + this.sbdb.DBTableName(table) + " WHERE interp_id=" + this.interpID;
                int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
                System.out.println("Deleted from " + table + ": " + nRows + " rows");
            }
        }
        this.sbdb.removeInterp(this);
    }

    void update(String description) throws SBException, SQLException {
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("INTERP") + " SET descrip='" + description + "'," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE interp_id=" + this.interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.description = description;
        this.audit = temp;
        this.sbdb.commit();
    }

    public int compareTo(Object rhs) {
        return this.description.compareToIgnoreCase(((InterpHdr)rhs).description);
    }

    static void loadAll(SBdb sbdb, HashMap<Integer, InterpHdr> interps) throws SQLException {
        interps.put(0, new InterpHdr(sbdb, 0));
        if (sbdb != null && sbdb.isConnected()) {
            String sql = "SELECT interp_id,descrip," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("INTERP");
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int interpID = rs.getInt("interp_id");
                    String description = rs.getString("descrip");
                    InterpHdr interp = new InterpHdr(sbdb, interpID, description, new Audit(rs));
                    interps.put(interp.getInterpID(), interp);
                }
            }
        }
    }

    static InterpHdr refresh(Connection conn, SBdb SB2, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException {
        Object sql = "SELECT interp_id,updated ";
        sql = (String)sql + " FROM " + SB2.DBTableName("INTERP");
        sql = SB2.modQuery((String)sql);
        InterpHdr notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery((String)sql);
            while (rs.next()) {
                int key = rs.getInt("interp_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (InterpHdr o : interpHdrs.values()) {
                    if (o.getInterpID() != key) continue;
                    found = true;
                    if (time == null || !time.after(o.getUpdated())) break;
                    InterpHdr hdr = new InterpHdr(SB2, key);
                    o.description = hdr.description;
                    o.audit = hdr.audit;
                    notifier = o;
                    break;
                }
                if (found) continue;
                notifier = new InterpHdr(SB2, key);
                interpHdrs.put(key, notifier);
            }
        }
        if (keys.size() < interpHdrs.size()) {
            Iterator<InterpHdr> it = interpHdrs.values().iterator();
            while (it.hasNext()) {
                InterpHdr o = it.next();
                if (keys.contains(o.getInterpID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    public String getCreatorString() throws SQLException, SBException {
        Userdef user = this.sbdb.getUser(this.getCreator());
        if (user == null) {
            return "";
        }
        return user.getAbr();
    }

    public String getCreatedString() {
        if (this.getCreated() != null) {
            return SB.df.format(this.getCreated());
        }
        return "";
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected interpHdr: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }
}

