/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.depth.DepthUnits;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import model3.Biocom;
import model3.IGDAge;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.LithInterval;
import model3.Lithology;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class ODMReader {
    Connection connection;
    public List<ODMMetadataEntry> metadata;

    public ODMReader(String driverString) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        System.out.println("Connecting to IC with: " + driverString);
        this.connection = DriverManager.getConnection(driverString);
        this.initMetadata();
    }

    private void initMetadata() throws SQLException {
        this.metadata = new LinkedList<ODMMetadataEntry>();
        Statement stmt = this.connection.createStatement();
        Statement stmt2 = this.connection.createStatement();
        Object sql = "SELECT  TableName, TableDescription, f_tableid FROM tablenames WHERE TableType='I'";
        ResultSet rs = stmt.executeQuery((String)sql);
        while (rs.next()) {
            String tableName = rs.getString("TableName");
            String tableDescription = rs.getString("TableDescription");
            int f_tableid = rs.getInt("f_tableid");
            sql = "SELECT data_type, description, title FROM intervalcolumns WHERE dest_table=" + f_tableid;
            ResultSet rs2 = stmt2.executeQuery((String)sql);
            while (rs2.next()) {
                ODMMetadataEntry entry = new ODMMetadataEntry();
                entry.ODMDataType = rs2.getInt("data_type");
                entry.ODMColumnDescrip = rs2.getString("description");
                entry.ODMColumnTitle = rs2.getString("title");
                entry.setODMTableName(tableName);
                entry.ODMTableDescrip = tableDescription;
                entry.ODMTableID = f_tableid;
                this.metadata.add(entry);
            }
        }
        stmt.close();
        stmt2.close();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public List<ODMWell> selectWell(String pattern) throws SQLException {
        LinkedList<ODMWell> results = new LinkedList<ODMWell>();
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT well_id, code, name, units FROM wells WHERE name like '" + pattern + "'";
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            ODMWell well = new ODMWell();
            well.wellID = rs.getInt("well_id");
            well.code = rs.getString("code");
            well.name = rs.getString("name");
            well.units = SB.getDBChar((ResultSet)rs, (String)"units");
            results.add(well);
        }
        stmt.close();
        return results;
    }

    public List<WellHeader> selectWells(String wellName, String wellCode, String country, String field, String location) throws SQLException, SBException {
        boolean clauseAdded = false;
        Object sql = "SELECT well_id, name, code,country, field, location, units FROM wells WHERE ";
        if (wellName.compareTo("%") > 0) {
            clauseAdded = true;
            sql = (String)sql + " upper(name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = (String)sql + " AND ";
            }
            clauseAdded = true;
            sql = (String)sql + " upper(code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = (String)sql + " AND ";
            }
            clauseAdded = true;
            sql = (String)sql + " upper(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (field.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = (String)sql + " AND ";
            }
            clauseAdded = true;
            sql = (String)sql + " upper(field) like '" + field.trim().toUpperCase() + "'";
        }
        if (location.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = (String)sql + " AND ";
            }
            clauseAdded = true;
            sql = (String)sql + " upper(location) like '" + location.trim().toUpperCase() + "'";
        }
        if (!clauseAdded) {
            throw new SBException("No search terms specified.");
        }
        sql = (String)sql + " ORDER BY upper(name),upper(code),upper(country)";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery((String)sql);
        ArrayList<WellHeader> results = new ArrayList<WellHeader>();
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            WellHeader result = new WellHeader(wellID);
            result.setWellName(rs.getString("name"));
            result.setWellCode(rs.getString("code"));
            result.setCountry(rs.getString("country"));
            result.setField(rs.getString("field"));
            result.setLocState(rs.getString("location"));
            result.setUnits(DepthUnits.getUnits((char)SB.getDBChar((ResultSet)rs, (String)"units")));
            results.add(result);
        }
        stmt.close();
        return results;
    }

    public void loadBiocom(SBdb ws, List<ODMWell> wells, String tableName, int dataType, Discipline discID) throws SBException, SQLException, FileNotFoundException, IOException, InvalidFieldException {
        Statement stmt = this.connection.createStatement();
        Statement dStmt = this.connection.createStatement();
        for (ODMWell well : wells) {
            String sql = "SELECT top_depth, legend FROM " + tableName + " WHERE well_id=" + well.wellID + " AND data_type=" + dataType;
            ResultSet rs = stmt.executeQuery(sql);
            WsWell wsWell = null;
            while (rs.next()) {
                if (wsWell == null) {
                    wsWell = this.getWsWell(ws, well);
                }
                double depth = rs.getDouble("top_depth");
                Object comment = rs.getString("legend");
                Sample sample = wsWell.getSample(depth, this.getSampleType(dStmt, well.wellID, depth), true);
                if (sample == null) {
                    sample = ws.useSampleTops() ? wsWell.addSample((Double)depth, null, "LOG", null) : wsWell.addSample(null, (Double)depth, "LOG", null);
                }
                WellInterp wellInterp = wsWell.getAddInterp(ws.getInterp(0));
                boolean combined = false;
                for (Biocom biocom : wellInterp.getComments()) {
                    if (biocom.getDiscID() != discID.getChar() || biocom.getTopSample() != sample) continue;
                    System.out.print("Combining comment: " + biocom.getText());
                    comment = biocom.getText() + "\n" + (String)comment;
                    if (((String)comment).length() > 256) {
                        comment = ((String)comment).substring(0, 255);
                    }
                    biocom.setText((String)comment);
                    System.out.println(" into " + biocom.getText());
                    combined = true;
                    break;
                }
                if (combined) continue;
                if (((String)comment).length() > 256) {
                    comment = ((String)comment).substring(0, 255);
                }
                Biocom biocom = new Biocom.Builder(ws, discID, ws.getAddUserID("ANON"), sample, (String)comment).build();
                try {
                    wellInterp.insertBiocom(biocom);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert biocom: " + String.valueOf(biocom) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
                }
            }
        }
        stmt.close();
        dStmt.close();
    }

    public void loadIntervals(SBdb ws, List<ODMWell> wells, String tableDescrip, String tableName, int dataType, int igdType, int hier) throws SBException, SQLException, FileNotFoundException, IOException, InvalidFieldException {
        Statement stmt = this.connection.createStatement();
        Statement dStmt = this.connection.createStatement();
        for (ODMWell well : wells) {
            String sql = "SELECT b.symbol_id, b.top_depth, b.top_boundary, b.base_depth, b.base_boundary, b.legend FROM " + tableName + " b WHERE well_id=" + well.wellID + " and data_type=" + dataType;
            ResultSet rs = stmt.executeQuery(sql);
            WsWell wsWell = null;
            while (rs.next()) {
                Sample baseSample;
                if (wsWell == null) {
                    wsWell = this.getWsWell(ws, well);
                }
                int unitID = rs.getInt("symbol_id");
                double topDepth = rs.getDouble("top_depth");
                int topBnd = rs.getInt("top_boundary");
                double baseDepth = rs.getDouble("base_depth");
                int baseBnd = rs.getInt("base_boundary");
                String name = rs.getString("legend");
                Sample topSample = wsWell.getSample(topDepth, this.getSampleType(dStmt, well.wellID, topDepth), true);
                if (topSample == null) {
                    topSample = ws.useSampleTops() ? wsWell.addSample((Double)topDepth, null, "LOG", null) : wsWell.addSample(null, (Double)topDepth, "LOG", null);
                }
                if ((baseSample = wsWell.getSample(baseDepth, this.getSampleType(dStmt, well.wellID, baseDepth), true)) == null) {
                    baseSample = ws.useSampleTops() ? wsWell.addSample((Double)baseDepth, null, "LOG", null) : wsWell.addSample(null, (Double)baseDepth, "LOG", null);
                }
                topBnd = this.getBnd(topBnd);
                baseBnd = this.getBnd(baseBnd);
                IGDScheme scheme = this.getIGDSch(ws, unitID, tableDescrip, igdType);
                IGDUnit unit = scheme.findUnit(name);
                int uppZone = 0;
                if (unit != null) {
                    uppZone = unit.getUnitID();
                }
                int nzTD = (int)Math.round(100.0 * topSample.getDepth('M'));
                int nzBD = (int)Math.round(100.0 * baseSample.getDepth('M'));
                WellInterp wellInterp = wsWell.getAddInterp(ws.getInterp(0));
                List<IGDIntervalZone> list = wellInterp.getIGDList(igdType);
                for (IGDIntervalZone z : list) {
                    if (z.getHier() != hier || scheme.getSchID() != z.getSchID()) continue;
                    int cTD = (int)Math.round(100.0 * z.topSample.getDepth('M'));
                    int cBD = (int)Math.round(100.0 * z.baseSample.getDepth('M'));
                    if (cTD == nzBD && z.getTopBndInt() != baseBnd) {
                        System.out.println("Boundary for zone: " + name + " reset from " + baseBnd + " to " + z.getTopBndInt() + "(" + z.getTopBnd() + ")");
                        baseBnd = z.getTopBndInt();
                    }
                    if (cBD != nzTD || z.getBaseBndInt() == topBnd) continue;
                    System.out.println("Boundary for zone: " + name + " reset from " + topBnd + " to " + z.getBaseBndInt() + "(" + z.getBaseBnd() + ")");
                    topBnd = z.getBaseBndInt();
                }
                IGDIntervalZone zone = null;
                try {
                    zone = new IGDIntervalZone.Builder(ws, igdType, topSample, baseSample, hier, scheme.getID()).topBnd(topBnd).baseBnd(baseBnd).uppInf(name).uppZone(uppZone).build();
                    wellInterp.insertZone(zone);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert interval: " + String.valueOf(zone) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
                }
            }
        }
        stmt.close();
        dStmt.close();
    }

    public void loadEvents(SBdb ws, List<ODMWell> wells, String tableName, int dataType) throws SBException, SQLException, FileNotFoundException, IOException, InvalidFieldException {
        Statement stmt = this.connection.createStatement();
        Statement dStmt = this.connection.createStatement();
        for (ODMWell well : wells) {
            String sql = "SELECT b.symbol_id, b.top_depth, b.legend FROM " + tableName + " b WHERE well_id=" + well.wellID + " AND data_type=" + dataType;
            ResultSet rs = stmt.executeQuery(sql);
            WsWell wsWell = null;
            while (rs.next()) {
                if (wsWell == null) {
                    wsWell = this.getWsWell(ws, well);
                }
                int symbolID = rs.getInt("symbol_id");
                double topDepth = rs.getDouble("top_depth");
                String name = rs.getString("legend");
                Sample topSample = wsWell.getSample(topDepth, this.getSampleType(dStmt, well.wellID, topDepth), true);
                if (topSample == null) {
                    topSample = ws.useSampleTops() ? wsWell.addSample((Double)topDepth, null, "LOG", null) : wsWell.addSample(null, (Double)topDepth, "LOG", null);
                }
                EventType evType = symbolID < 100 ? EventType.TOP : EventType.BASE;
                SBEvent event = null;
                try {
                    event = ws.getSBEvent(name);
                }
                catch (Exception ex) {
                    System.out.println("Error getting event: " + ex.getMessage());
                    continue;
                }
                if (event == null) {
                    try {
                        event = ws.addSBEvent(new SBEvent.Builder().name(name).isGenerate(true));
                    }
                    catch (SBPermissionException pe) {
                        throw new SBException(pe.getMessage());
                    }
                }
                WellEvent wellEvent = new WellEvent.Builder().sample(topSample).type(evType).event(event).build(ws);
                try {
                    wsWell.getAddInterp(ws.getInterp(0)).insertEvent(wellEvent);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert event: " + String.valueOf(wellEvent) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
                }
            }
        }
        stmt.close();
        dStmt.close();
    }

    public void loadLithology(SBdb ws, List<ODMWell> wells, String tableName) throws SBException, SQLException, FileNotFoundException, IOException, InvalidFieldException {
        Statement stmt = this.connection.createStatement();
        for (ODMWell well : wells) {
            String sql = "SELECT b.symbol_id, b.top_depth, b.base_depth, b.legend FROM " + tableName + " b WHERE well_id=" + well.wellID;
            ResultSet rs = stmt.executeQuery(sql);
            WsWell wsWell = null;
            while (rs.next()) {
                if (wsWell == null) {
                    wsWell = this.getWsWell(ws, well);
                }
                int unitID = rs.getInt("symbol_id");
                double topDepth = rs.getDouble("top_depth");
                double baseDepth = rs.getDouble("base_depth");
                String name = rs.getString("legend");
                Lithology lith = ws.getLithdesc().getLithologyFromDescription(name);
                if (lith != null) {
                    LithInterval lithInt = new LithInterval(ws, topDepth, baseDepth, lith);
                    try {
                        wsWell.insertLithInterval(lithInt);
                    }
                    catch (Exception ex) {
                        System.out.println("Cannot insert interval: " + String.valueOf(lithInt) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
                    }
                    continue;
                }
                System.out.println("Can't decode lithology name: " + name);
            }
        }
        stmt.close();
    }

    private WsWell getWsWell(SBdb ws, ODMWell well) throws SQLException, SBException {
        Well wsWell;
        Iterator<Well> it = ws.getWellIterator();
        while (it.hasNext()) {
            wsWell = it.next();
            if (!wsWell.getWellName().equals(well.name) || !wsWell.getWellCode().equals(Well.makeCode(well.code))) continue;
            WsWell w = (WsWell)wsWell;
            HashSet<Integer> dTypes = new HashSet<Integer>();
            dTypes.add(1);
            w.fillData(dTypes, 0);
            return w;
        }
        wsWell = ws.addWellToWorkspace(0, null);
        wsWell.getSamples();
        wsWell.loadInterps();
        well.fillHeader(this.connection);
        WellHeader h = new WellHeader();
        h.setWellName(well.name);
        h.setWellCode(Well.makeCode(well.code));
        h.setUnits(DepthUnits.getUnits((char)well.units));
        h.setCountry(well.country);
        h.setField(well.field);
        h.setTerminalDepth(well.td);
        h.setRotaryTableElevation(Double.valueOf(well.rte));
        h.setSeaBed(Double.valueOf(well.sb));
        h.setOperator(well.client);
        h.setGeoDatum(well.geodatum);
        h.setLat_dec(Double.valueOf(well.latitude));
        h.setLong_dec(Double.valueOf(well.longitude));
        try {
            wsWell.update(h);
        }
        catch (InvalidFieldException | SBPermissionException e) {
            throw new SBException("Error updating well header", e);
        }
        return wsWell;
    }

    public List getProjects() throws SQLException {
        LinkedList<Project> projects = new LinkedList<Project>();
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT project_id, title FROM projects ORDER BY title";
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            projects.add(new Project(this, rs.getInt("project_id"), rs.getString("title")));
        }
        stmt.close();
        return projects;
    }

    private int getBnd(int bnd) {
        switch (bnd) {
            default: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: 
        }
        return 6;
    }

    private IGDScheme getIGDSch(SBdb ws, int unitID, String tableDescrip, int igdType) throws SQLException, SBException {
        IGDScheme scheme;
        String sql;
        if (unitID == 0) {
            String name = tableDescrip;
            IGDScheme scheme2 = ws.getIGDScheme(name, igdType);
            if (scheme2 == null) {
                scheme2 = ws.addIGDScheme(igdType, name, "");
            }
            return scheme2;
        }
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql = "SELECT d.dic_id,d.dictionary_name FROM symboldictionary d, symbols s WHERE s.symbol_id=" + unitID + " AND s.dic_id=d.dic_id");
        if (rs.next()) {
            int dicID = rs.getInt("dic_id");
            String name = rs.getString("dictionary_name");
            scheme = ws.getIGDScheme(name, igdType);
            if (scheme == null) {
                scheme = this.loadScheme(ws, dicID, igdType, name);
            }
        } else {
            stmt.close();
            return this.getIGDSch(ws, 0, tableDescrip, igdType);
        }
        stmt.close();
        return scheme;
    }

    private IGDScheme loadScheme(SBdb ws, int dicID, int igdType, String schemeName) throws SQLException, SBException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT symbol_id,description,youngest,oldest FROM symbols WHERE dic_id=" + dicID;
        IGDScheme scheme = ws.addIGDScheme(igdType, schemeName, "");
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int unitID = rs.getInt("symbol_id");
            String name = rs.getString("description");
            double u_age = rs.getDouble("youngest");
            double l_age = rs.getDouble("oldest");
            int hier = this.getHierFromName(schemeName, 1);
            hier = this.getHierFromName(name, hier);
            try {
                scheme.addUnit(new IGDUnit.Builder(ws).age(true, new IGDAge(u_age)).age(false, new IGDAge(l_age)).hier(hier).name(name));
            }
            catch (InvalidFieldException ex) {
                System.out.println("Can't build IGDUnit: " + unitID + ", name=" + name + " Exception: " + ex.toString());
                ex.printStackTrace();
            }
        }
        stmt.close();
        return scheme;
    }

    private int getHierFromName(String name, int hier) {
        if (name.toLowerCase().contains(" fm")) {
            hier = 2;
        } else if (name.toLowerCase().contains(" formation")) {
            hier = 2;
        } else if (name.toLowerCase().contains(" gp")) {
            hier = 1;
        } else if (name.toLowerCase().contains(" group")) {
            hier = 1;
        } else if (name.toLowerCase().contains(" member")) {
            hier = 3;
        } else if (name.toLowerCase().contains(" mb")) {
            hier = 3;
        } else if (name.toLowerCase().contains(" bed")) {
            hier = 4;
        } else if (name.toLowerCase().contains(" bd")) {
            hier = 4;
        } else if (name.toLowerCase().contains(" zone")) {
            hier = 2;
        } else if (name.toLowerCase().contains(" sub-zone")) {
            hier = 3;
        } else if (name.toLowerCase().contains(" subzone")) {
            hier = 3;
        } else if (name.toLowerCase().contains(" sub zone")) {
            hier = 3;
        }
        return hier;
    }

    private String getSampleType(Statement stmt, int wellID, double depth) throws SQLException {
        String sql = "SELECT abr FROM samples WHERE well_id=" + wellID + " AND data_type=2020 AND top_depth>=" + (depth - 0.001) + " AND top_depth<=" + (depth + 0.001);
        ResultSet rs = stmt.executeQuery(sql);
        String type = null;
        if (rs.next()) {
            type = rs.getString("abr");
        }
        rs.close();
        if (type == null) {
            return null;
        }
        if (type.equalsIgnoreCase("CUT")) {
            type = "CU";
        } else if (type.equalsIgnoreCase("SWC")) {
            type = "SWC";
        } else if (type.equalsIgnoreCase("CORE")) {
            type = "CO";
        }
        return type;
    }

    public static class ODMMetadataEntry {
        private String ODMTableName;
        private String ODMTableDescrip;
        private String ODMColumnDescrip;
        private String ODMColumnTitle;
        private int ODMDataType;
        private int ODMTableID;
        private String sbugsName = "";
        private String sbugsColumn = "";
        private int igdType;
        private int hier;
        private int dtype;

        public String getODMTableName() {
            return this.ODMTableName;
        }

        public void setODMTableName(String ODMTableName) {
            this.ODMTableName = ODMTableName;
        }

        public String getODMTableDescrip() {
            return this.ODMTableDescrip;
        }

        public String getODMColumnDescrip() {
            return this.ODMColumnDescrip;
        }

        public String getODMColumnTitle() {
            return this.ODMColumnTitle;
        }

        public int getODMDataType() {
            return this.ODMDataType;
        }

        public int getODMTableID() {
            return this.ODMTableID;
        }

        public String getSbugsName() {
            return this.sbugsName;
        }

        public void setSbugsName(String sbugsName) {
            this.sbugsName = sbugsName;
        }

        public String getSbugsColumn() {
            return this.sbugsColumn;
        }

        public void setSbugsColumn(String sbugsColumn) {
            this.sbugsColumn = sbugsColumn;
        }

        public int getIgdType() {
            return this.igdType;
        }

        public void setIgdType(int igdType) {
            this.igdType = igdType;
        }

        public int getHier() {
            return this.hier;
        }

        public void setHier(int hier) {
            this.hier = hier;
        }

        public int getDtype() {
            return this.dtype;
        }

        public void setDtype(int dtype) {
            this.dtype = dtype;
        }

        public void clearSBugs() {
            this.sbugsColumn = "";
            this.sbugsName = "";
            this.dtype = 0;
            this.hier = 0;
            this.igdType = 0;
        }
    }

    public static class ODMWell {
        int wellID;
        String name;
        String code;
        char units = (char)77;
        String country;
        String field;
        double td;
        double rte;
        double sb;
        String client;
        String geodatum;
        double latitude;
        double longitude;

        public ODMWell() {
        }

        public ODMWell(int wellID, String wellName, String wellCode, String units) {
            this.wellID = wellID;
            this.name = wellName;
            this.code = wellCode;
            if (units != null && units.length() > 0) {
                this.units = units.charAt(0);
            }
        }

        public String toString() {
            return this.name;
        }

        void fillHeader(Connection connection) throws SQLException {
            String sql = "SELECT country, field, location, units, terminal_depth, rig_elevation, sea_bed, client, geodatum, latitude, longtitude FROM wells WHERE well_id=" + this.wellID;
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.country = rs.getString("country");
                if (this.country != null) {
                    this.country = this.country.toUpperCase();
                }
                this.field = rs.getString("field");
                this.units = SB.getDBChar((ResultSet)rs, (String)"units");
                this.td = rs.getDouble("terminal_depth");
                this.rte = rs.getDouble("rig_elevation");
                this.sb = rs.getDouble("sea_bed");
                this.client = rs.getString("client");
                this.geodatum = rs.getString("geodatum");
                this.latitude = rs.getDouble("latitude");
                this.longitude = rs.getDouble("longtitude");
            }
            stmt.close();
        }
    }

    public class Project {
        int ID;
        String name;
        final /* synthetic */ ODMReader this$0;

        public Project(ODMReader this$0, int ID, String name) {
            ODMReader oDMReader = this$0;
            Objects.requireNonNull(oDMReader);
            this.this$0 = oDMReader;
            this.ID = ID;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public List<ODMWell> getWells() throws SQLException {
            LinkedList<ODMWell> wells = new LinkedList<ODMWell>();
            Statement stmt = this.this$0.connection.createStatement();
            String sql = "SELECT p.well_id,w.name,w.code,w.units FROM projectwells p, wells w WHERE w.well_id=p.well_id AND p.project_id=" + this.ID + " ORDER BY name";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                wells.add(new ODMWell(rs.getInt("well_id"), rs.getString("name"), rs.getString("code"), rs.getString("units")));
            }
            stmt.close();
            return wells;
        }
    }
}

