/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import model3.Audit;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.InterpHdr;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Surface;
import model3.Well;
import model3.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class OWXLSReader {
    SBdb ws;
    char units;
    IGDScheme scheme;
    int igdType;
    List<String> nonInserts = new LinkedList<String>();
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Workbook wb;

    public List getNonInserts() {
        return this.nonInserts;
    }

    public OWXLSReader(SBdb ws, File file) throws IOException, InvalidFormatException {
        this.ws = ws;
        this.wb = WorkbookFactory.create((File)file);
    }

    public final String[] getSheets() {
        String[] sheets = new String[this.wb.getNumberOfSheets()];
        for (int j = 0; j < this.wb.getNumberOfSheets(); ++j) {
            sheets[j] = this.wb.getSheetName(j);
        }
        return sheets;
    }

    public final void parse(int sheetIndex, int format, char units, IGDScheme scheme, int igdType) throws SBException, IOException, FileNotFoundException, SQLException, InvalidFieldException {
        this.units = units;
        this.scheme = scheme;
        this.igdType = igdType;
        Sheet sheet = this.wb.getSheetAt(sheetIndex);
        switch (format) {
            case 1: {
                this.parseSheet1(sheet);
                break;
            }
            case 2: {
                this.parseSheet2(sheet);
                break;
            }
            default: {
                throw new SBException("Unknown format tag: " + format);
            }
        }
    }

    final void parseSheet2(Sheet sheet) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFieldException {
        String[] usedColumns = new String[]{"unique_wellbore_identifier", "wellbore_name", "pick_name", "pick_interpreter", "pick_obs_no", "pick_depth", "depth_unit", "pick_date", "pick_kind", "description"};
        int[] cellIndex = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        boolean WELL_UWI = false;
        boolean WELL_NAME = true;
        int SURFACE_NAME = 2;
        int INTERP = 3;
        int OBS = 4;
        int DEPTH = 5;
        int DEPTH_UNITS = 6;
        int PICK_DATE = 7;
        int FEATURE = 8;
        int REMARK = 9;
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + sheet.getSheetName());
            return;
        }
        for (int cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); ++cellNum) {
            Cell cell = titleRow.getCell(cellNum);
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            System.out.println("Cell " + cellNum + " content: " + cell.toString());
            System.out.println("Cell value: " + cell.getStringCellValue());
            for (int i = 0; i < usedColumns.length; ++i) {
                String columnTitle = cell.getStringCellValue().trim();
                if (!columnTitle.equalsIgnoreCase(usedColumns[i])) continue;
                cellIndex[i] = cellNum;
            }
        }
        for (int i = 0; i < cellIndex.length; ++i) {
            if (cellIndex[i] >= 0) continue;
            throw new SBException("Can't find a column in spreadsheet with title: " + usedColumns[i]);
        }
        String lastWellName = null;
        IGDScheme wsScheme = null;
        wsScheme = this.ws.getIGDScheme(this.scheme.getName(), this.igdType);
        if (wsScheme == null) {
            wsScheme = IGDScheme.copyToWorkspace(this.ws, this.scheme);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd");
        WsWell well = null;
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            double d;
            String wellName;
            Row row = sheet.getRow(nRow);
            if (row == null || row.getCell(cellIndex[1]) == null || row.getCell(cellIndex[1]).getCellType() != CellType.STRING || (wellName = row.getCell(cellIndex[1]).getStringCellValue()) == null) continue;
            String surfaceName = row.getCell(cellIndex[2]).getStringCellValue().trim();
            boolean isTop = false;
            if (surfaceName.toUpperCase().contains("TOP")) {
                isTop = true;
                surfaceName = surfaceName.replaceAll(" top", "");
                surfaceName = surfaceName.replaceAll(" Top", "");
                surfaceName = surfaceName.replaceAll(" TOP", "");
            }
            if (row.getCell(cellIndex[5]) == null) continue;
            if (row.getCell(cellIndex[5]).getCellType() != CellType.NUMERIC) {
                if (row.getCell(cellIndex[5]).toString().isEmpty()) continue;
                d = Double.parseDouble(row.getCell(cellIndex[5]).toString());
            } else {
                d = row.getCell(cellIndex[5]).getNumericCellValue();
            }
            int unitsToUse = this.units;
            if (row.getCell(cellIndex[6]) != null) {
                String s = row.getCell(cellIndex[6]).getStringCellValue();
                if (s.toUpperCase().startsWith("M")) {
                    unitsToUse = 77;
                } else if (s.toUpperCase().startsWith("F")) {
                    unitsToUse = 70;
                }
            }
            double depth = DepthUtils.convToM((double)d, (char)unitsToUse);
            System.out.println("Well, surface name & depth: " + wellName + " " + surfaceName + " " + depth);
            if (row.getCell(cellIndex[4]) != null) {
                String obs = row.getCell(cellIndex[4]).toString();
                System.out.println("Obs: " + obs);
            }
            String owinterp = row.getCell(cellIndex[3]).getStringCellValue();
            String feature = row.getCell(cellIndex[8]).getStringCellValue();
            String remark = null;
            if (row.getCell(cellIndex[9]) != null) {
                remark = row.getCell(cellIndex[9]).getStringCellValue();
            }
            Date date = null;
            if (row.getCell(cellIndex[7]) != null && !row.getCell(cellIndex[7]).getStringCellValue().isEmpty()) {
                try {
                    date = df.parse(row.getCell(cellIndex[7]).getStringCellValue());
                }
                catch (ParseException p) {
                    System.out.println("Error parsing date: " + row.getCell(cellIndex[7]).getStringCellValue());
                }
            }
            if (!owinterp.equalsIgnoreCase("EAMC") || !isTop || !feature.toUpperCase().contains("SEQUENCE")) continue;
            InterpHdr interp = this.ws.getInterp("Default Version");
            if (interp == null) {
                interp = this.ws.addInterp("Default Version", 0);
            }
            if (lastWellName == null || !wellName.equalsIgnoreCase(lastWellName)) {
                well = this.ws.addWellToWorkspace(0, null);
                well.getHeader().setWellName(wellName);
                if (row.getCell(cellIndex[0]) != null && row.getCell(cellIndex[0]).getCellType() == CellType.STRING) {
                    well.getHeader().setWellCode(row.getCell(cellIndex[0]).getStringCellValue());
                }
                well.loadInterps();
            }
            if (well == null) {
                throw new SBException("Well is null when building pick");
            }
            Sample sample = this.parseSample(well, depth, "LOG", true);
            Surface surface = wsScheme.getSurface(surfaceName, null);
            try {
                if (surface == null) {
                    surface = wsScheme.addSurface(new Surface.Builder(this.ws).name(surfaceName).type(Surface.SurfaceType.parseType(surfaceName, Surface.SurfaceType.SB)));
                }
                SQPick.Builder builder = new SQPick.Builder(this.ws, surface, sample, 3);
                if (date != null) {
                    builder.audit(new Audit(0, date, 0, date));
                }
                if (well.getAddInterp(interp).getSQPick(sample) != null) {
                    builder.observed(false);
                }
                well.getAddInterp(interp).addSQPick(well, builder);
                lastWellName = wellName;
                continue;
            }
            catch (InvalidFieldException | SBPermissionException e) {
                e.printStackTrace();
            }
        }
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            well = (WsWell)it.next();
            well.updateStatus();
        }
    }

    final void parseSheet1(Sheet sheet) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFieldException {
        String[] usedColumns = new String[]{"Well name", "Surface name", "Obs", "Depth", "Create date", "Update date"};
        int[] cellIndex = new int[]{0, 0, 0, 0, 0, 0};
        boolean WELL_NAME = false;
        boolean SURFACE_NAME = true;
        int OBS = 2;
        int DEPTH = 3;
        int CREATED = 4;
        int UPDATED = 5;
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + sheet.getSheetName());
            return;
        }
        for (int cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); ++cellNum) {
            Cell cell = titleRow.getCell(cellNum);
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            System.out.println("Cell " + cellNum + " content: " + cell.toString());
            System.out.println("Cell value: " + cell.getStringCellValue());
            for (int i = 0; i < usedColumns.length; ++i) {
                String columnTitle = cell.getStringCellValue().trim();
                if (!columnTitle.equalsIgnoreCase(usedColumns[i])) continue;
                cellIndex[i] = cellNum;
            }
        }
        for (int i = 0; i < cellIndex.length; ++i) {
            if (cellIndex[i] != 0) continue;
            throw new SBException("Can't find a column in spreadsheet with title: " + usedColumns[i]);
        }
        String lastWellName = null;
        LinkedList<OWPick> wellData = new LinkedList<OWPick>();
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String dateString;
            String wellName;
            Row row = sheet.getRow(nRow);
            if (row == null || (wellName = row.getCell(cellIndex[0]).getStringCellValue()) == null) continue;
            if (lastWellName != null && !wellName.equalsIgnoreCase(lastWellName)) {
                this.processWell(wellData, lastWellName);
                wellData.clear();
            }
            OWPick rowData = new OWPick(this);
            rowData.surfaceName = row.getCell(cellIndex[1]).getStringCellValue().trim();
            rowData.depth = DepthUtils.convToM((double)row.getCell(cellIndex[3]).getNumericCellValue(), (char)this.units);
            System.out.println("Surface name & depth: " + rowData.surfaceName + " " + rowData.depth);
            rowData.obs = (int)row.getCell(cellIndex[2]).getNumericCellValue();
            Cell cell = row.getCell(cellIndex[4]);
            if (cell != null) {
                try {
                    dateString = row.getCell(cellIndex[4]).getStringCellValue();
                    try {
                        if (dateString != null && dateString.length() > 0) {
                            rowData.created = this.df.parse(dateString);
                        }
                    }
                    catch (ParseException pe) {
                        System.out.println("Can't parse date: " + dateString);
                    }
                }
                catch (IllegalStateException ise) {
                    try {
                        rowData.created = row.getCell(cellIndex[4]).getDateCellValue();
                    }
                    catch (Exception ex) {
                        System.out.println("Can't parse date, exception: " + ex.toString());
                    }
                }
            }
            if ((cell = row.getCell(cellIndex[5])) != null) {
                try {
                    dateString = row.getCell(cellIndex[5]).getStringCellValue();
                    try {
                        if (dateString != null && dateString.length() > 0) {
                            rowData.modified = this.df.parse(dateString);
                        }
                    }
                    catch (ParseException pe) {
                        System.out.println("Can't parse date: " + dateString);
                    }
                }
                catch (IllegalStateException ise) {
                    try {
                        rowData.modified = row.getCell(cellIndex[5]).getDateCellValue();
                    }
                    catch (Exception ex) {
                        System.out.println("Can't parse date, exception: " + ex.toString());
                    }
                }
            }
            wellData.add(rowData);
            lastWellName = wellName;
        }
        if (lastWellName != null) {
            this.processWell(wellData, lastWellName);
        }
    }

    private void processWell(List<OWPick> wellData, String wellName) throws SQLException, SBException, FileNotFoundException, IOException, InvalidFieldException {
        WsWell well = this.ws.addWellToWorkspace(0, null);
        well.getHeader().setWellName(wellName);
        for (int row = 0; row < wellData.size(); ++row) {
            String uppInf;
            OWPick rowData = wellData.get(row);
            if (rowData.paired || !(uppInf = rowData.surfaceName.trim()).endsWith("Top")) continue;
            uppInf = uppInf.substring(0, uppInf.length() - "Top".length()).trim();
            Sample topSample = this.parseSample(well, rowData.depth, "LOG", true);
            Sample baseSample = null;
            boolean paired = false;
            for (int compare = 0; compare < wellData.size(); ++compare) {
                String baseRoot;
                OWPick compareData = wellData.get(compare);
                if (rowData.obs != compareData.obs || compareData.paired || rowData == compareData || !rowData.surfaceName.endsWith("Top") || !compareData.surfaceName.endsWith("Base") || !uppInf.equals(baseRoot = compareData.surfaceName.substring(0, compareData.surfaceName.length() - "Base".length()).trim())) continue;
                baseSample = this.parseSample(well, compareData.depth, "LOG", true);
                paired = true;
                compareData.paired = true;
                break;
            }
            if (!paired) {
                baseSample = topSample;
            }
            int topBnd = 3;
            int baseBnd = 3;
            int hier = IGDIntervalZone.getDefaultHier(this.igdType);
            IGDUnit unit = this.scheme.findUnit(uppInf);
            if (unit != null) {
                hier = unit.getHier();
            }
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, this.igdType, topSample, baseSample, hier, this.scheme.getSchID()).topBnd(topBnd).baseBnd(baseBnd);
            builder.uppInf(uppInf).qUzone(false).qLzone(false).audit(new Audit(0, rowData.created, 0, rowData.modified));
            if (unit != null) {
                builder.uppZone(unit.getUnitID());
            }
            InterpHdr interp = this.ws.getInterp(0);
            if (rowData.obs > 1 && (interp = this.ws.getInterp("Version " + rowData.obs)) == null) {
                interp = this.ws.addInterp("Version " + rowData.obs, rowData.obs - 1);
            }
            try {
                well.getAddInterp(interp).addZone(builder, well);
                continue;
            }
            catch (SBException ex) {
                this.nonInserts.add("Well: " + well.toString() + " Interval: " + uppInf + " Depth: " + rowData.depth + " Reason: " + ex.getMessage());
                System.out.println(ex.toString());
                continue;
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (InvalidFieldException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Adding well: " + String.valueOf(well));
        well.updateStatus();
    }

    Sample parseSample(Well well, double depth, String type, boolean useAnyType) throws SBException, SQLException, FileNotFoundException, IOException {
        well.getSamples();
        Sample sample = well.getSample(depth, type, useAnyType);
        if (sample == null) {
            try {
                sample = well.addSample(this.ws.useSampleTops() ? Double.valueOf(depth) : null, this.ws.useSampleTops() ? null : Double.valueOf(depth), type, null);
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace");
            }
        }
        return sample;
    }

    class OWPick {
        String surfaceName;
        double depth;
        int obs;
        boolean paired;
        Date created;
        Date modified;

        OWPick(OWXLSReader this$0) {
            Objects.requireNonNull(this$0);
            this.paired = false;
        }
    }
}

