/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.depth.DepthUnits;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;
import model3.Biocom;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.WellEvent;
import model3.WsWell;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;

public class PDIReader {
    Connection connection;
    SBdb ws;
    Set dataTypes;

    public PDIReader(SBdb ws, Set dataTypes, String path) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, SBException {
        String driverString = "jdbc:ucanaccess://" + path;
        System.out.println("Connecting to PDI with: " + driverString);
        this.connection = DriverManager.getConnection(driverString);
        this.ws = ws;
        this.dataTypes = dataTypes;
        this.parseDB();
    }

    private void parseDB() throws SQLException, SBException {
        WsWell wsWell;
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT [RECORD #], API, WELL_LETTER, WELL_NUMBER, SIDETRACK, BYPASS, OPERATOR, LEASE, AREA, BLOCK_LETTER, BLOCK_NUMBER, SURFLAT, SURFLONG, RPTYPE, REPORT_DATE, REVISION_DATE, RELEASED, RELEASE_DATE FROM tblCLIENT_WELL";
        ResultSet rs = stmt.executeQuery(sql);
        HashMap<Integer, String> PDIWells = new HashMap<Integer, String>();
        HashMap<Integer, Character> PDIWellDisc = new HashMap<Integer, Character>();
        block26: while (rs.next()) {
            int PDIwellID = rs.getInt("RECORD #");
            String wellCode = rs.getString("API");
            if (this.ws.getWell(wellCode) == null) {
                int bypass;
                WellHeader h = new WellHeader();
                Object wellName = rs.getString("AREA");
                wellName = (String)wellName + " " + rs.getString("BLOCK_NUMBER");
                String operator = rs.getString("OPERATOR");
                wellName = (String)wellName + " " + this.codeOperator(operator);
                wellName = (String)wellName + " #" + rs.getString("WELL_NUMBER");
                int sideTrack = rs.getInt("SIDETRACK");
                if (sideTrack > 0) {
                    wellName = (String)wellName + "ST" + sideTrack;
                }
                if ((bypass = rs.getInt("BYPASS")) > 0) {
                    wellName = (String)wellName + "BP" + bypass;
                }
                h.setWellName((String)wellName);
                h.setWellCode(wellCode);
                h.setUnits(DepthUnits.F);
                h.setCountry("USA");
                h.setDatum(WellDatum.ROTARY_TABLE);
                h.setOperator(operator);
                String latString = rs.getString("SURFLAT");
                try {
                    h.setLat_dec(Double.valueOf(Double.parseDouble(latString)));
                }
                catch (NumberFormatException ne) {
                    System.out.println("Can't parse lat: " + latString);
                }
                String longString = rs.getString("SURFLONG");
                try {
                    h.setLong_dec(Double.valueOf(Double.parseDouble(longString)));
                }
                catch (NumberFormatException ne) {
                    System.out.println("Can't parse long: " + longString);
                }
                wsWell = this.ws.addWellToWorkspace(0, null, h);
                wsWell.getSamples();
                wsWell.loadInterps();
            }
            PDIWells.put(PDIwellID, wellCode);
            String discipline = rs.getString("RPTYPE");
            switch (discipline) {
                default: {
                    PDIWellDisc.put(PDIwellID, Character.valueOf('M'));
                    continue block26;
                }
                case "NANNO": {
                    PDIWellDisc.put(PDIwellID, Character.valueOf('N'));
                    continue block26;
                }
                case "PALY": 
            }
            PDIWellDisc.put(PDIwellID, Character.valueOf('P'));
        }
        sql = "SELECT record, mdepth, fauna, age, eco, comments, source FROM tblCLIENT_PALEO ORDER BY record, mdepth";
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int wellID = rs.getInt("record");
            double depth = rs.getDouble("mdepth");
            String fauna = rs.getString("fauna");
            Double age = rs.getDouble("age");
            Float eco = Float.valueOf(rs.getFloat("eco"));
            String comments = rs.getString("comments");
            String source = rs.getString("source");
            Discipline discipline = Discipline.getDisc((char)((Character)PDIWellDisc.get(wellID)).charValue());
            wsWell = (WsWell)this.ws.getWell((String)PDIWells.get(wellID));
            if (wsWell == null) {
                System.out.println("Can't find well for ID: " + wellID);
                continue;
            }
            Sample sample = wsWell.getSample(depth = DepthUtils.convToM((double)depth, (char)'F'), "CU", true);
            if (sample == null) {
                sample = this.ws.useSampleTops() ? wsWell.addSample((Double)depth, null, "CU", null) : wsWell.addSample(null, (Double)depth, "CU", null);
            }
            this.dataTypes.add(1);
            if (fauna != null && !fauna.isEmpty()) {
                SBEvent event = null;
                try {
                    event = this.ws.getSBEvent(fauna);
                }
                catch (Exception ex) {
                    System.out.println("Error getting event: " + ex.getMessage());
                    continue;
                }
                if (event == null) {
                    try {
                        event = this.ws.addSBEvent(new SBEvent.Builder().name(fauna).isGenerate(true));
                        this.dataTypes.add(16);
                    }
                    catch (SBPermissionException pe) {
                        throw new SBException(pe.getMessage());
                    }
                }
                WellEvent wellEvent = new WellEvent.Builder().sample(sample).type(EventType.TOP).event(event).discID(discipline).build(this.ws);
                try {
                    wsWell.getAddInterp(this.ws.getInterp(0)).insertEvent(wellEvent);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert event: " + String.valueOf(wellEvent) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
                }
            }
            if (comments == null || comments.isEmpty()) continue;
            if (comments.length() > 256) {
                comments = comments.substring(0, 255);
            }
            Biocom biocom = new Biocom.Builder(this.ws, discipline, this.ws.getAddUserID("PDI"), sample, comments).build();
            try {
                wsWell.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
                switch (discipline) {
                    case MICRO: {
                        this.dataTypes.add(3);
                        break;
                    }
                    case NANNO: {
                        this.dataTypes.add(5);
                        break;
                    }
                    case PALY: {
                        this.dataTypes.add(7);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Cannot insert biocom: " + String.valueOf(biocom) + " into well: " + String.valueOf(wsWell) + ". Reason: " + ex.toString());
            }
        }
        stmt.close();
    }

    private String codeOperator(String o) {
        switch (o) {
            case "MURPHY": {
                return "MUR";
            }
            case "DEVON": {
                return "DEV";
            }
            case "WALTER OIL & GAS": {
                return "WAL";
            }
            case "HESS CORPORATION": {
                return "HES";
            }
            case "MCMORAN OIL & GAS": {
                return "FCX";
            }
        }
        return o;
    }
}

