/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.well.DegreesMinutesSecondsCoordinate;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JOptionPane;
import model3.AnalystHeader;
import model3.Audit;
import model3.Genus;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.WsWell;
import util.SBException;

public class SbugsReader {
    Set dataTypes;
    String dataSource;
    static final int WELL = 1;
    static final int FSSABND = 2;
    SBdb ws;
    WsWell well;
    int abnSchID = 1;
    private final HashMap<Discipline, Integer> abnSchemes = new HashMap();

    public SbugsReader(String fileName, SBdb ws, Set dataTypes, String analyst) throws SBException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 2).equals("**")) {
                    throw new SBException("Not a StrataBugs format file");
                }
                this.dataSource = buff.substring(25).trim();
                buff = in.readLine();
                if (!buff.substring(0, 1).equals("*")) {
                    throw new SBException("Error reading line :" + buff);
                }
                this.well = ws.addWellToWorkspace(0, fileName);
                this.well.loadInterps();
                boolean hasWellDetails = false;
                while (buff != null) {
                    switch (this.decodeRecordType(buff.substring(1))) {
                        case 1: {
                            buff = this.parseWell(in.readLine(), in);
                            hasWellDetails = true;
                            break;
                        }
                        case 2: {
                            buff = this.parseFssabnd(buff, analyst, in);
                        }
                    }
                }
                if (!hasWellDetails) {
                    WellHeader wellHeaderCopy = this.well.getHeader().getWellHeaderCopy();
                    String wellName = fileName.substring(0, fileName.lastIndexOf("."));
                    if (wellName.length() > 25) {
                        wellName = wellName.substring(wellName.length() - 25);
                    }
                    wellHeaderCopy.setWellName(wellName);
                    wellHeaderCopy.setWellCode(wellName.toUpperCase());
                    this.well.update(wellHeaderCopy);
                }
                this.well.updateStatus(dataTypes);
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    String parseWell(String buff, BufferedReader in) throws IOException, SBException {
        WellHeader h = new WellHeader();
        h.setWellName(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        h.setWellCode(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        h.setOperator(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        h.setCountry(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        h.setField(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        buff = buff.substring(buff.indexOf(9) + 1);
        String strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        long gridX = 0L;
        long gridY = 0L;
        if (strg.length() > 0) {
            gridX = Long.parseLong(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            gridY = Long.parseLong(strg);
        }
        if (gridX != 0L && gridY != 0L) {
            h.setGridX((double)gridX);
            h.setGridY((double)gridY);
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd-MMM-yy");
        String spudString = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        String compString = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        try {
            h.setSpudDate(LocalDate.parse(spudString, df));
            h.setCompletionDate(LocalDate.parse(compString, df));
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setLat_dec(Double.valueOf(strg));
        }
        char lat_ind = buff.substring(0, buff.indexOf(9)).trim().charAt(0);
        buff = buff.substring(buff.indexOf(9) + 1);
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        short lat_deg = -1;
        if (strg.length() > 0) {
            lat_deg = Short.parseShort(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        short lat_min = -1;
        if (strg.length() > 0) {
            lat_min = Short.parseShort(strg);
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        float lat_sec = -1.0f;
        if (strg.length() > 0) {
            lat_sec = Float.parseFloat(strg);
        }
        if (lat_deg > 0 && lat_min > 0 && lat_sec > 0.0f) {
            h.setLat_dec(Double.valueOf(new DegreesMinutesSecondsCoordinate(lat_deg, lat_min, lat_sec, lat_ind).getDecimalDegrees()));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setLong_dec(Double.valueOf(strg));
        }
        char long_ind = buff.substring(0, buff.indexOf(9)).trim().charAt(0);
        buff = buff.substring(buff.indexOf(9) + 1);
        short long_deg = -1;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_deg = Short.parseShort(strg);
        }
        short long_min = -1;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_min = Short.parseShort(strg);
        }
        float long_sec = -1.0f;
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            long_sec = Float.parseFloat(strg);
        }
        if (long_deg > 0 && long_min > 0 && long_sec > 0.0f) {
            h.setLong_dec(Double.valueOf(new DegreesMinutesSecondsCoordinate(long_deg, long_min, long_sec, long_ind).getDecimalDegrees()));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setTerminalDepth(Double.parseDouble(strg));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setSeaLevel(Double.valueOf(Double.parseDouble(strg)));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setSeaBed(Double.valueOf(Double.parseDouble(strg)));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setRotaryTableElevation(Double.valueOf(Double.parseDouble(strg)));
        }
        strg = buff.substring(0, buff.indexOf(9)).trim();
        buff = buff.substring(buff.indexOf(9) + 1);
        if (strg.length() > 0) {
            h.setDatum(WellDatum.parse((int)Integer.parseInt(strg)));
        }
        h.setSectionType(SectionType.getSectionType((char)buff.substring(0, buff.indexOf(9)).trim().charAt(0)));
        buff = buff.substring(buff.indexOf(9) + 1);
        h.setUnits(DepthUnits.getUnits((char)buff.substring(0).trim().charAt(0)));
        try {
            this.well.update(h);
        }
        catch (Exception e) {
            throw new SBException("Error updating well header", (Throwable)e);
        }
        buff = in.readLine();
        return buff;
    }

    String parseFssabnd(String buff, String analyst, BufferedReader in) throws IOException, SBException, Exception {
        char discID = buff.charAt(9);
        Discipline disc = Discipline.getDisc((char)discID);
        if (disc == null) {
            throw new SBException("Not a valid discipline in line: " + buff);
        }
        buff = in.readLine();
        if (buff.trim().equals("ABNSCHME")) {
            buff = this.parseAbnscheme(disc, in);
        }
        if (buff.trim().startsWith("TAXA")) {
            buff = this.parseTaxa(discID, buff, in);
        }
        if (buff.trim().equals("SAMPLES")) {
            buff = this.parseSamples(discID, analyst, in);
        }
        return buff;
    }

    String parseAbnscheme(Discipline discID, BufferedReader in) throws Exception {
        String buff = in.readLine();
        AbundanceSchemeImpl abnScheme = new AbundanceSchemeImpl(this.abnSchID);
        while (!buff.startsWith("TAXA")) {
            String abr = buff.substring(0, 4).trim();
            if (!abr.equals("+")) {
                abnScheme.addEntry(new AbundanceScheme.AbundanceSchemeEntry(buff.substring(4, 29).trim(), abr, Integer.parseInt(buff.substring(29).trim()), 0));
            }
            buff = in.readLine();
        }
        abnScheme.setName("SbugsReader " + discID.getNoun() + " Scheme");
        this.abnSchemes.put(discID, this.abnSchID);
        ++this.abnSchID;
        this.ws.getAbundanceSchemeService().addAbundanceScheme((AbundanceScheme)abnScheme);
        return buff;
    }

    String parseTaxa(char discID, String buff, BufferedReader in) throws IOException, SBException, SQLException {
        int nTaxa = Integer.parseInt(buff.substring(5).trim());
        for (int i = 0; i < nTaxa; ++i) {
            Genus.Builder genBuilder = new Genus.Builder();
            Taxon.Builder txBuilder = new Taxon.Builder();
            String cat_mnem = "";
            buff = in.readLine();
            int donorID = Integer.parseInt(buff.substring(0, buff.indexOf(9)));
            String donorString = buff = in.readLine();
            cat_mnem = this.buffField(buff);
            if ((buff = this.nextField(buff)) != null) {
                genBuilder.qual(0, this.buffField(buff));
                buff = this.nextField(buff);
                if (buff != null) {
                    genBuilder.genusName(this.buffField(buff));
                    buff = this.nextField(buff);
                    if (buff != null) {
                        genBuilder.qual(1, this.buffField(buff));
                        buff = this.nextField(buff);
                        if (buff != null) {
                            genBuilder.qual(2, this.buffField(buff));
                            buff = this.nextField(buff);
                            if (buff != null) {
                                genBuilder.subGenus(this.buffField(buff));
                                buff = this.nextField(buff);
                                if (buff != null) {
                                    genBuilder.qual(3, this.buffField(buff));
                                    buff = this.nextField(buff);
                                    if (buff != null) {
                                        txBuilder.qual(4, this.buffField(buff));
                                        buff = this.nextField(buff);
                                        if (buff != null) {
                                            txBuilder.species(this.buffField(buff));
                                            buff = this.nextField(buff);
                                            if (buff != null) {
                                                txBuilder.qual(5, this.buffField(buff));
                                                buff = this.nextField(buff);
                                                if (buff != null) {
                                                    txBuilder.qual(6, this.buffField(buff));
                                                    buff = this.nextField(buff);
                                                    if (buff != null) {
                                                        txBuilder.subSpecies(this.buffField(buff));
                                                        buff = this.nextField(buff);
                                                        if (buff != null) {
                                                            txBuilder.qual(7, this.buffField(buff));
                                                            buff = this.nextField(buff);
                                                            if (buff != null) {
                                                                txBuilder.author(this.buffField(buff));
                                                                buff = this.nextField(buff);
                                                                if (buff != null && buff.length() > 0) {
                                                                    if (buff.endsWith(".00")) {
                                                                        txBuilder.author(txBuilder.getAuthor() + " " + (int)Float.parseFloat(buff));
                                                                    } else {
                                                                        txBuilder.author(txBuilder.getAuthor() + " " + Integer.parseInt(buff));
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.ws.addTaxon(txBuilder, genBuilder, cat_mnem, donorID, donorString);
        }
        buff = in.readLine();
        return buff;
    }

    String nextField(String buff) {
        if (buff == null) {
            return buff;
        }
        int ind = buff.indexOf(9);
        if (ind >= 0) {
            return buff.substring(buff.indexOf(9) + 1);
        }
        return null;
    }

    String buffField(String buff) {
        if (buff == null) {
            return buff;
        }
        int ind = buff.indexOf(9);
        if (ind >= 0) {
            return buff.substring(0, buff.indexOf(9)).trim();
        }
        return buff;
    }

    String parseSamples(char discID, String analyst, BufferedReader in) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        int gridX = 0;
        int gridY = 0;
        Sample sample = null;
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yy");
        TaxonOcc fss = null;
        this.well.getSamples();
        while (buff != null && buff.length() > 0) {
            if (buff.charAt(0) == 'S') {
                double baseDepth;
                double topDepth = Double.parseDouble(buff.substring(1, buff.indexOf(9)));
                buff = buff.substring(buff.indexOf(9) + 1);
                SampleType sampleType = SampleType.parseType((String)buff.substring(0, buff.indexOf(9)).trim());
                String strg = (buff = buff.substring(buff.indexOf(9) + 1)).substring(0, buff.indexOf(9)).trim();
                if (strg.length() > 0) {
                    gridX = Integer.parseInt(strg);
                }
                if ((buff = buff.substring(buff.indexOf(9) + 1)).indexOf(9) >= 0) {
                    strg = buff.substring(0, buff.indexOf(9)).trim();
                    if (strg.length() > 0) {
                        gridY = Integer.parseInt(strg);
                    }
                    if (buff.indexOf(9) >= 0) {
                        buff = buff.substring(buff.indexOf(9) + 1);
                        if ((buff = buff.trim()).length() > 0) {
                            baseDepth = Double.parseDouble(buff);
                            if (Math.abs(baseDepth) < (double)0.0029f) {
                                baseDepth = topDepth;
                            }
                        } else {
                            baseDepth = topDepth;
                        }
                    } else {
                        baseDepth = topDepth;
                    }
                } else {
                    baseDepth = topDepth;
                }
                if ((sample = this.well.getSample(topDepth, baseDepth, sampleType, false)) == null) {
                    sample = this.well.addSample((Double)topDepth, (Double)baseDepth, sampleType.getAbr(), "");
                    this.addDataType(1);
                }
            } else if (buff.charAt(0) == 'D') {
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                if (sample.getSmpdtl(discID, analyst, 1) != null) {
                    throw new SBException("Duplicate sample info for discipline: " + discID + " for sample: " + sample.toString());
                }
                AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                if (this.ws.getAbundanceSchemeService().getAbundanceSchemeCount() > 0) {
                    analyHdr.setAbnScheme(this.abnSchemes.get(Discipline.getDisc((char)discID)));
                }
                Smpdtl smpdtl = new Smpdtl(this.ws, sample, analyHdr, null, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), buff.charAt(2) == 'Y' ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.ANALYSED);
                if (buff.indexOf(9) >= 0) {
                    buff = buff.substring(buff.indexOf(9) + 1);
                    smpdtl.setPicker(buff.substring(0, buff.indexOf(9)).trim());
                    if (buff.indexOf(9) >= 0) {
                        buff = buff.substring(buff.indexOf(9) + 1);
                        smpdtl.setSource(buff.substring(0, buff.indexOf(9)).trim());
                        if (buff.indexOf(9) >= 0 && (buff = buff.substring(buff.indexOf(9) + 1)).indexOf(9) >= 0) {
                            smpdtl.appendNote(buff.substring(0, buff.indexOf(9)).trim());
                            if (buff.indexOf(9) >= 0) {
                                buff = buff.substring(buff.indexOf(9) + 1);
                            }
                        }
                    }
                }
                sample.insert(smpdtl);
                this.addDataType(SBdb.did2dtype(discID));
            } else if (buff.charAt(0) == 'T') {
                Smpdtl smpdtl;
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                Taxon t = this.ws.getTaxon(Integer.parseInt(buff.substring(1, buff.indexOf(9)).trim()));
                if (t == null) {
                    throw new SBException("Cannot find taxon record for line: " + buff);
                }
                boolean reworked = false;
                boolean questionable = false;
                if ((buff = buff.substring(buff.indexOf(9) + 1)).charAt(0) == 'R') {
                    reworked = true;
                }
                if (buff.charAt(1) == '?') {
                    questionable = true;
                }
                buff = this.nextField(buff);
                String subjAbund = null;
                if (buff != null) {
                    subjAbund = this.buffField(buff);
                }
                buff = this.nextField(buff);
                int count = 0;
                if (buff != null) {
                    try {
                        count = Integer.parseInt(this.buffField(buff));
                    }
                    catch (NumberFormatException ne) {
                        subjAbund = this.buffField(buff);
                    }
                }
                buff = this.nextField(buff);
                boolean caved = false;
                if (buff != null && buff.length() > 0 && buff.charAt(0) == 'C') {
                    caved = true;
                }
                Situation situation = reworked ? Situation.RW : (caved ? Situation.CV : Situation.INSITU);
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, t, situation, questionable, 0);
                if (subjAbund != null) {
                    builder.subjAbund(subjAbund);
                }
                if (count > 0) {
                    builder.count(count);
                }
                if ((smpdtl = sample.getSmpdtl(discID, analyst, 1)) == null) {
                    AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                    if (this.ws.getAbundanceSchemeService().getAbundanceSchemeCount() > 0) {
                        analyHdr.setAbnScheme(this.abnSchemes.get(Discipline.getDisc((char)discID)));
                    }
                    smpdtl = new Smpdtl(this.ws, sample, analyHdr, null, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtl);
                }
                fss = smpdtl.insertOccurrence(builder, this.well.getWellID(), false);
            } else {
                if (buff.charAt(0) != 'A') break;
                if (fss == null) {
                    throw new SBException("Taxon record null for occurrence detail record: " + buff);
                }
                fss.setPreservation(buff.substring(1, buff.indexOf(9)));
                buff = buff.substring(buff.indexOf(9) + 1);
                fss.setColour(buff.substring(1, buff.indexOf(9)));
                fss.setComment(buff.substring(buff.indexOf(9) + 1));
            }
            buff = in.readLine();
        }
        return buff;
    }

    int decodeRecordType(String buff) {
        if (buff.equals("WELL")) {
            return 1;
        }
        if (buff.startsWith("FSSABND")) {
            return 2;
        }
        return 0;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

