/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.SectionType;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import model3.Audit;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.SBdb;
import model3.Sample;
import model3.SurfaceBase;
import model3.WellOccQueryResult;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SbugsLink;
import util.SortEntry;
import util.status.SbugsStatus;

public class Surface
implements SortEntry,
SbugsStatus,
Comparable,
SurfaceBase,
SbugsLink {
    private final SBdb db;
    private final int schID;
    private final int surfaceID;
    private String name;
    private double age;
    private Confidence confidence;
    private double interpAge;
    private SurfaceType type;
    private int magnitude;
    private Audit audit;
    private Color status;
    private int nOccs;
    private int nCorrOccs;
    private Surface link;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface(SBdb sbdb, int surfaceID) throws SQLException, SBException {
        block4: {
            this.name = "";
            this.confidence = Confidence.CONFIDENT;
            this.type = SurfaceType.getDefault();
            this.magnitude = 100;
            this.audit = new Audit();
            this.status = UNKNOWN;
            this.nOccs = -1;
            this.nCorrOccs = -1;
            this.link = null;
            this.db = sbdb;
            String sql = "SELECT sch_id,age,name,type,magnitude,confidence," + Audit.sqlFieldString() + " FROM " + this.db.DBTableName("surface") + " WHERE surface_id=" + surfaceID;
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                if (rs.next()) {
                    this.schID = rs.getInt("sch_id");
                    this.surfaceID = surfaceID;
                    this.age = rs.getDouble("age");
                    this.name = rs.getString("name");
                    this.type = SurfaceType.values()[rs.getInt("type")];
                    this.magnitude = rs.getInt("magnitude");
                    this.confidence = Confidence.getConfidence((int)rs.getInt("confidence"));
                    this.audit = new Audit(rs);
                    this.status = STORED;
                    this.setInterpAge(stmt);
                    break block4;
                }
                throw new SBException("No surface found with ID: " + surfaceID);
            }
        }
    }

    Surface(SBdb ws, int schID, Element xml) throws ParseException, SQLException, SBException {
        Element el;
        this.name = "";
        this.confidence = Confidence.CONFIDENT;
        this.type = SurfaceType.getDefault();
        this.magnitude = 100;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.nCorrOccs = -1;
        this.link = null;
        this.schID = schID;
        this.db = ws;
        String strg = xml.getChildTextNormalize("SurfaceID");
        if (strg == null) {
            throw new IllegalStateException("Cannot parse Surface with no surface ID");
        }
        this.surfaceID = Integer.parseInt(strg);
        strg = xml.getChildTextNormalize("Name");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.type = SurfaceType.parseType(strg, SurfaceType.getDefault());
        }
        if ((strg = xml.getChildTextNormalize("Age")) != null) {
            this.age = Double.parseDouble(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + String.valueOf(this));
        }
        el = xml.getChild("Magnitude");
        if (el != null) {
            this.magnitude = Integer.parseInt(el.getTextNormalize());
        }
        if ((el = xml.getChild("Uncertainty")) != null) {
            this.confidence = Confidence.getConfidence((int)Integer.parseInt(el.getTextNormalize()));
        }
        this.status = NOTSTORED;
    }

    public void copyLink() throws SQLException {
        if (this.db.isConnected()) {
            throw new IllegalStateException("Attempt to copy link in database surface");
        }
        if (this.link == null || this.status != CONFLICT) {
            return;
        }
        this.name = this.link.getName();
        this.type = this.link.type;
        this.age = this.link.getAge();
        this.status = STORED;
    }

    public Surface getLink() {
        return this.link;
    }

    public void setLink(Surface link) {
        this.link = link;
        if (link != null) {
            this.status = STORED;
            if (!this.name.equalsIgnoreCase(link.getName()) || this.type != link.type || Math.abs(this.age - link.getAge()) > 0.001) {
                this.status = CONFLICT;
            }
        } else {
            this.status = NOTSTORED;
        }
    }

    public int getBndDefault() {
        switch (this.type.ordinal()) {
            default: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 2: 
        }
        return 2;
    }

    private void setInterpAge(Statement stmt) throws SQLException {
        this.interpAge = this.age;
        if (this.interpAge < (double)1.0E-7f) {
            String sql = "SELECT sqtype FROM " + this.db.DBTableName("igd_sch") + " WHERE sch_id=" + this.schID;
            ResultSet rs2 = stmt.executeQuery(this.db.modQuery(sql));
            int sqtype = 68;
            if (rs2.next()) {
                sqtype = SB.getDBChar((ResultSet)rs2, (String)"sqtype");
            }
            rs2.close();
            sql = "SELECT u_age,l_age FROM " + this.db.DBTableName("igd_dict") + " WHERE sch_id=" + this.schID + " AND name=" + SB.DBString((String)this.getName());
            rs2 = stmt.executeQuery(this.db.modQuery(sql));
            if (rs2.next()) {
                double uAge = rs2.getDouble("u_age");
                double lAge = rs2.getDouble("l_age");
                this.interpAge = sqtype == 68 ? (this.type == SurfaceType.SB ? lAge : (this.type == SurfaceType.MFS ? uAge + (lAge - uAge) / 3.0 : uAge + (lAge - uAge) * 2.0 / 3.0)) : (this.type == SurfaceType.MFS ? uAge : uAge + (lAge - uAge) / 2.0);
            }
        }
    }

    final void storeDB() throws SQLException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.db.DBTableName("surface") + " (surface_id,sch_id,age,name,type,magnitude,confidence," + Audit.sqlFieldString() + ") VALUES (" + this.surfaceID + "," + this.schID + "," + this.age + "," + SB.DBString((String)this.name) + "," + this.type.ordinal() + "," + String.valueOf(this.type == SurfaceType.MFS ? Integer.valueOf(this.magnitude) : "NULL") + "," + this.confidence.getDBint() + "," + this.audit.sqlInsert(this.db, stmt) + ")";
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        stmt.close();
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder rhs) throws SQLException, SBException {
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "UPDATE " + this.db.DBTableName("surface") + " SET age=" + rhs.age + ",name=" + SB.DBString((String)rhs.name) + ",type=" + rhs.type.ordinal() + ",magnitude=" + rhs.magnitude + ",confidence=" + rhs.confidence.getDBint() + "," + this.audit.sqlUpdate(this.db, stmt, false) + " WHERE surface_id=" + this.surfaceID;
        try {
            int nUpdated = stmt.executeUpdate(this.db.modQuery(sql));
            if (nUpdated != 1) {
                throw new SBException("Could not update surface: " + rhs.name);
            }
        }
        finally {
            stmt.close();
        }
        this.name = rhs.getName();
        this.type = rhs.type;
        this.age = rhs.age;
        this.magnitude = rhs.magnitude;
        this.confidence = rhs.confidence;
        this.status = STORED;
    }

    private static Surface load(SBdb sbdb, int surfaceID, Surface surface) throws SQLException, SBException {
        if (surface != null && surface.getSurfaceID() != surfaceID) {
            throw new IllegalArgumentException("Attempt to refresh surface with incorrect ID");
        }
        Surface temp = new Surface(sbdb, surfaceID);
        if (surface != null) {
            surface.age = temp.age;
            surface.name = temp.name;
            surface.type = temp.type;
            surface.magnitude = temp.magnitude;
            surface.confidence = temp.confidence;
            surface.audit = new Audit(temp.audit);
        } else {
            surface = temp;
        }
        return surface;
    }

    static Surface refresh(Statement stmt, SBdb SB2, int schID, List<Surface> surfaces) throws SQLException, SBException {
        Object sql = "SELECT surface_id,updated FROM " + SB2.DBTableName("surface") + " WHERE sch_id=" + schID;
        sql = SB2.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        Surface notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("surface_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Surface o : surfaces) {
                if (o.getSurfaceID() != key) continue;
                found = true;
                if (time == null || !time.after(o.audit.updated)) break;
                notifier = Surface.load(SB2, key, o);
                break;
            }
            if (found) continue;
            notifier = Surface.load(SB2, key, null);
            notifier.status = STORED;
            Surface.insert(surfaces, notifier);
        }
        if (keys.size() < surfaces.size()) {
            Iterator<Surface> it = surfaces.iterator();
            while (it.hasNext()) {
                Surface o = it.next();
                if (keys.contains(o.getSurfaceID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(SBdb db, int schID, List<Surface> surfaces, IGDScheme scheme) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT age,name,type,magnitude,confidence," + Audit.sqlFieldString() + ",surface_id FROM " + db.DBTableName("surface") + " WHERE sch_id=" + schID + " ORDER BY surface_id";
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                Builder builder = new Builder(db);
                builder.age(rs.getDouble("age"));
                builder.name(rs.getString("name"));
                builder.type(SurfaceType.values()[rs.getInt("type")]);
                builder.magnitude(rs.getInt("magnitude"));
                builder.confidence(Confidence.getConfidence((int)rs.getInt("confidence")));
                builder.audit(new Audit(rs)).status(STORED);
                Surface surface = builder.build(rs.getInt("surface_id"), schID);
                surface.interpAge = surface.age;
                IGDUnit unit = scheme.findUnit(surface.getName());
                if (surface.interpAge < (double)1.0E-7f && unit != null) {
                    double uAge = Optional.ofNullable(unit.getUage()).orElse(0.0);
                    double lAge = Optional.ofNullable(unit.getLage()).orElse(0.0);
                    surface.interpAge = scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? (surface.type == SurfaceType.SB ? lAge : (surface.type == SurfaceType.MFS ? uAge + (lAge - uAge) / 3.0 : uAge + (lAge - uAge) * 2.0 / 3.0)) : (surface.type == SurfaceType.MFS ? uAge : uAge + (lAge - uAge) / 2.0);
                }
                surface.status = STORED;
                Surface.insert(surfaces, surface);
            }
        }
        finally {
            stmt.close();
        }
    }

    static void insert(List<Surface> surfaces, Surface surface) {
        boolean inserted = false;
        int i = 0;
        for (Surface s : surfaces) {
            if (s.getSortEntry().compareTo(surface.getSortEntry()) > 0) {
                surfaces.add(i, surface);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            surfaces.add(surface);
        }
    }

    public int getSchID() {
        return this.schID;
    }

    public IGDScheme getScheme() throws SQLException {
        return this.db.getIGDScheme(this.schID);
    }

    public int getSurfaceID() {
        return this.surfaceID;
    }

    @Override
    public double getAge() {
        if (this.age < (double)1.0E-6f) {
            return this.interpAge;
        }
        return this.age;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String toString(boolean includeType) {
        if (includeType && !this.name.toUpperCase().contains(this.type.toString())) {
            return this.name + " " + String.valueOf((Object)this.type);
        }
        return this.name;
    }

    public String getTypeString() {
        return this.type.name();
    }

    public SurfaceType getType() {
        return this.type;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write((String)ind + "<SurfaceID>" + this.surfaceID + "</SurfaceID>\n");
        out.write((String)ind + "<Name>" + SB.getXMLstring((String)this.name) + "</Name>\n");
        out.write((String)ind + "<Type>" + this.getTypeString() + "</Type>\n");
        out.write((String)ind + "<Age>" + this.age + "</Age>\n");
        if (this.type == SurfaceType.MFS) {
            out.write((String)ind + "<Magnitude>" + this.magnitude + "</Magnitude>\n");
        }
        if (this.confidence.getDBint() > 0) {
            out.write((String)ind + "<Uncertainty>" + this.confidence.getDBint() + "</Uncertainty>\n");
        }
        this.audit.writeXML(out, indent);
    }

    public void setAge(double age) throws SBException, SQLException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set surface age");
        }
        this.age = age;
    }

    public void setName(String string) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set surface age");
        }
        this.name = string;
    }

    public void setType(SurfaceType type) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set surface type");
        }
        this.type = type;
    }

    public int getNoccs(boolean refresh) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            if (this.db != null && this.db.isConnected()) {
                String sql;
                Statement stmt = this.db.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql = "SELECT count(samp_id) AS nOccs FROM " + this.db.DBTableName("SQPICK") + " WHERE surface_id=" + this.surfaceID));
                if (rs.next()) {
                    this.nOccs = rs.getInt("nOccs");
                }
                stmt.close();
            }
        }
        return this.nOccs;
    }

    public int getNCorrLines(boolean refresh) throws SQLException {
        if (this.nCorrOccs < 0 || refresh) {
            this.nCorrOccs = 0;
            if (this.db != null && this.db.isConnected()) {
                String sql;
                Statement stmt = this.db.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql = "SELECT count(CORRSCH_ID) AS nOccs FROM " + this.db.DBTableName("CHTLN_SURFACE") + " WHERE surface_id=" + this.surfaceID));
                if (rs.next()) {
                    this.nCorrOccs = rs.getInt("nOccs");
                }
                stmt.close();
            }
        }
        return this.nCorrOccs;
    }

    public String getSortEntry() {
        int ageInt = (int)Math.round(this.age * 1000000.0);
        String sage = "" + ageInt;
        while (sage.length() < 10) {
            sage = "0" + sage;
        }
        return sage + "-" + this.name.toUpperCase();
    }

    public Color getStatus() {
        return this.status;
    }

    void setStatus(Color status) {
        if (status != null) {
            this.status = status;
        }
    }

    public String statusString() {
        return this.name;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Surface)) {
            return 0;
        }
        return this.compareTo((Surface)o);
    }

    public int compareTo(Surface rhs) {
        if (this.getAge() < rhs.getAge()) {
            return -1;
        }
        if (this.getAge() > rhs.getAge()) {
            return 1;
        }
        int comp = this.name.compareTo(rhs.name);
        if (comp == 0) {
            return rhs.type.ordinal() - this.type.ordinal();
        }
        return comp;
    }

    public List<String> getOccs(SBdb SB2) throws SQLException, SBException {
        if (this.surfaceID == 0) {
            return null;
        }
        if (SB2 == null || !SB2.isConnected()) {
            throw new SBException("Attempt to get occurrences when connection is: " + String.valueOf(SB2));
        }
        String sql = "SELECT DISTINCT w.well_id,w.well_name,w.well_code FROM " + SB2.DBTableName("SQPICK") + " i," + SB2.DBTableName("WELLS") + " w WHERE i.surface_id=" + this.surfaceID + " AND i.well_id=w.well_id ORDER BY well_name";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            occs.add(rs.getString("well_name") + "(" + rs.getString("well_code") + ")");
        }
        stmt.close();
        return occs;
    }

    public void setNoccs(int i) {
        this.nOccs = i;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        if (e instanceof Surface) {
            Surface surface = (Surface)e;
            if (this.name.toUpperCase().equals(surface.getName().toUpperCase()) && (this.type == surface.type || SurfaceType.isSBorCC(this.type) && SurfaceType.isSBorCC(surface.type))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Statement stmt) throws SQLException {
        Statement statement = stmt == null ? this.db.getDatabase().createStatement() : stmt;
        String sql = "DELETE FROM " + this.db.DBTableName("SURFACE") + " WHERE surface_id=" + this.surfaceID;
        try {
            statement.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.status = NOTSTORED;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for surface: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public List<WellOccQueryResult> getWellOccs() throws SQLException, SBException {
        return this.getWellOccs(-1, -1);
    }

    public List<WellOccQueryResult> getWellOccs(int filterInterpID, int wellListID) throws SQLException, SBException {
        LinkedList<WellOccQueryResult> results = new LinkedList<WellOccQueryResult>();
        Object sql = "SELECT p.well_id,p.interp_id,i.descrip,p.samp_id,w.well_name,w.units,w.type FROM ";
        sql = (String)sql + this.db.DBTableName("SQPICK") + " p," + this.db.DBTableName("INTERP") + " i," + this.db.DBTableName("WELLS") + " w ";
        if (wellListID > 0) {
            sql = (String)sql + "," + this.db.DBTableName("WELLIST_MBR") + " wl";
        }
        sql = (String)sql + " WHERE p.surface_id=" + this.getSurfaceID() + " AND p.interp_id=i.interp_id AND p.well_id=w.well_id ";
        if (filterInterpID >= 0) {
            sql = (String)sql + " AND i.interp_id=" + filterInterpID;
        }
        if (wellListID > 0) {
            sql = (String)sql + " AND w.well_id=wl.well_id AND wl.id=" + wellListID;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery((String)sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int interpID = rs.getInt("interp_id");
                String interpName = rs.getString("descrip");
                int sampID = rs.getInt("samp_id");
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                char sectionType = SB.getDBChar((ResultSet)rs, (String)"type");
                Sample sample = Sample.load(this.db, wellID, sampID, SectionType.getSectionType((char)sectionType), null);
                sample.displayUnits = units;
                WellOccQueryResult result = new WellOccQueryResult(wellID, interpID, 'S', wellName, interpName, sample);
                results.add(result);
            }
        }
        return results;
    }

    private Surface(Builder builder, int surfaceID, int schID) {
        this.name = "";
        this.confidence = Confidence.CONFIDENT;
        this.type = SurfaceType.getDefault();
        this.magnitude = 100;
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.nOccs = -1;
        this.nCorrOccs = -1;
        this.link = null;
        this.db = builder.sbdb;
        this.surfaceID = surfaceID;
        this.name = builder.name;
        this.age = builder.age;
        this.type = builder.type;
        this.schID = schID;
        this.magnitude = builder.magnitude;
        this.confidence = builder.confidence;
        this.status = builder.status;
        this.audit = builder.audit;
    }

    public static enum SurfaceType {
        CC(""),
        MFS("TST"),
        TS("LST"),
        SB("HST");

        final String tractName;

        private SurfaceType(String tractName) {
            this.tractName = tractName;
        }

        public static boolean isSBorCC(SurfaceType t) {
            return t == SB || t == CC;
        }

        public static boolean isEquivalent(SurfaceType t1, SurfaceType t2) {
            if (t1.equals((Object)t2)) {
                return true;
            }
            return SurfaceType.isSBorCC(t1) && SurfaceType.isSBorCC(t2);
        }

        static SurfaceType getDefault() {
            return SB;
        }

        public static SurfaceType parseType(String name, SurfaceType defaultType) {
            SurfaceType type = defaultType;
            for (SurfaceType t : SurfaceType.values()) {
                if (!name.toUpperCase().contains(t.name()) && (t == CC || !name.toUpperCase().contains(t.tractName))) continue;
                return t;
            }
            return type;
        }
    }

    public static class Builder
    implements SurfaceBase {
        private final SBdb sbdb;
        private String name = "";
        private double age;
        private SurfaceType type = SurfaceType.SB;
        private int magnitude = 100;
        private Confidence confidence = Confidence.CONFIDENT;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;
        private int nOccs;
        private Surface original;

        public Builder(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Illegal argument to Surface.Builder: sbdb must not be null");
            }
            this.sbdb = sbdb;
        }

        public Builder name(String name) {
            this.name = name != null ? name : "";
            return this;
        }

        public Builder age(double age) {
            if (age >= 0.0) {
                this.age = age;
            }
            return this;
        }

        public Builder type(SurfaceType type) {
            this.type = type;
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        public Builder magnitude(int mag) {
            this.magnitude = mag;
            return this;
        }

        public Builder confidence(Confidence confidence) {
            if (confidence != null) {
                this.confidence = confidence;
            }
            return this;
        }

        private void validateFields() {
            if (this.name.isEmpty()) {
                throw new IllegalStateException("Attempt to build Surface with empty name");
            }
            if (this.type == SurfaceType.MFS) {
                if (this.magnitude < 1) {
                    this.magnitude = 100;
                } else if (this.magnitude > 100) {
                    assert (false);
                    this.magnitude = 100;
                }
            } else {
                this.magnitude = 0;
            }
        }

        Surface build(int ID, int schID) {
            if (ID <= 0) {
                throw new IllegalArgumentException("Cannot build Surface with ID " + ID);
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                System.out.println("WARNING: building surface with unknown status...");
            }
            this.validateFields();
            return new Surface(this, ID, schID);
        }

        Surface store(int schID) throws SQLException, SBException {
            Surface surface;
            if (this.original != null) {
                this.validateFields();
                if (!this.name.equals(this.original.name) || Math.abs(this.age - this.original.age) > 0.001 || this.type != this.original.type || this.confidence != this.original.confidence || this.type == SurfaceType.MFS && this.magnitude != this.original.magnitude) {
                    this.original.update(this);
                }
                surface = this.original;
            } else {
                if (!this.sbdb.isConnected()) {
                    throw new IllegalStateException("Attempt to store Surface in workspace");
                }
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("SURFACE", "SURFACE_ID");
                surface = this.build(ID, schID);
                surface.storeDB();
            }
            return surface;
        }

        public static Builder copyOf(SBdb sbdb, Surface s) throws SQLException, SBException {
            Builder builder = new Builder(sbdb);
            builder.name(s.name).age(s.age).type(s.getType()).magnitude(s.magnitude).confidence(s.confidence);
            builder.status = SbugsStatus.NOTSTORED;
            if (sbdb == s.db) {
                builder.original = s;
                builder.audit(new Audit(s.audit));
            } else if (!s.db.isConnected() && builder.sbdb.isConnected()) {
                builder.audit(new Audit(builder.sbdb, s.db, s.audit));
            }
            return builder;
        }

        public int getOriginalID() {
            if (this.original != null) {
                return this.original.getSurfaceID();
            }
            return 0;
        }

        public void setNOccs(int nOccs) {
            this.nOccs = nOccs;
        }

        @Override
        public double getAge() {
            return this.age;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getNOccs() {
            return this.nOccs;
        }

        public String getTypeString() {
            return this.type.name();
        }

        public SurfaceType getType() {
            return this.type;
        }

        SBdb getModel() {
            return this.sbdb;
        }

        Audit getAudit() {
            return this.audit;
        }

        public int getMagnitude() {
            return this.magnitude;
        }

        public Confidence getConfidence() {
            return this.confidence;
        }
    }

    public static enum Magnitude {
        MAJOR("Major", 100),
        MEDIUM("Medium", 66),
        MINOR("Minor", 33);

        private final String name;
        private final int value;

        private Magnitude(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static Magnitude getMagnitude(int mag) {
            if (mag <= 33) {
                return MINOR;
            }
            if (mag <= 66) {
                return MEDIUM;
            }
            if (mag <= 100) {
                return MAJOR;
            }
            throw new IllegalArgumentException("Illegal surface magnitude: " + mag);
        }
    }
}

