/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model3.SBRestrictable;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class SynonymScheme
extends com.stratadata.model3.taxon.SynonymScheme {
    private final SBdb sbdb;
    public static final String DEFAULT_TEXT = "Default scheme";
    private HashMap<Integer, Integer> synonymy = null;

    SynonymScheme(SBdb sbdb, String name) throws SQLException, SBPermissionException {
        super(sbdb.nextControl("SYNSCH", "SCH_ID"), name);
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        this.sbdb = sbdb;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("synsch") + " (sch_id,name) VALUES (" + this.getSchID() + "," + SB.DBString((String)name) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    SynonymScheme(SBdb SB2, int ID, String name) {
        super(ID, name);
        this.sbdb = SB2;
    }

    void load() throws SQLException {
        if (this.synonymy == null) {
            this.synonymy = new HashMap();
        } else {
            this.synonymy.clear();
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT spec_id,pref FROM " + this.sbdb.DBTableName("SYNONYMY") + " WHERE sch_id=" + this.getSchID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int specID = rs.getInt("spec_id");
                    int prefID = rs.getInt("pref");
                    this.synonymy.put(specID, prefID);
                }
            }
        }
    }

    void addSyn(int specID, int prefID) {
        if (this.synonymy == null) {
            this.synonymy = new HashMap();
        }
        if (this.synonymy.get(specID) != null) {
            if (this.synonymy.get(specID) == prefID) {
                return;
            }
            throw new IllegalArgumentException("Attempt to add preferred term for specID: " + specID + " which already has preferred term: " + prefID);
        }
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "INSERT INTO " + this.sbdb.DBTableName("synonymy") + " (spec_id,pref,sch_id) VALUES (" + specID + "," + prefID + "," + this.getSchID() + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.sbdb.commit();
            }
            catch (SQLException ex) {
                throw SuppressedSQLException.withRollback("Error adding synonym", ex, this.sbdb);
            }
        }
        this.synonymy.put(specID, prefID);
    }

    SynonymScheme copyToWorkspace(SBdb ws, boolean removeNonWorkspaceTaxa) throws SQLException {
        SynonymScheme wsSch = new SynonymScheme(ws, this.getSchID(), this.getName());
        wsSch.synonymy = new HashMap();
        wsSch.synonymy.putAll(this.synonymy);
        if (removeNonWorkspaceTaxa) {
            Iterator<Map.Entry<Integer, Integer>> it = wsSch.synonymy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Integer> entry = it.next();
                if (ws.getTaxon(entry.getKey()) != null && ws.getTaxon(entry.getValue()) != null) continue;
                it.remove();
            }
        }
        return wsSch;
    }

    public int getPref(int specID) throws SQLException {
        Integer pref;
        if (this.synonymy == null) {
            this.load();
        }
        if ((pref = this.synonymy.get(specID)) != null) {
            return pref;
        }
        return 0;
    }

    List<Integer> getSyn(int prefID) throws SQLException {
        if (this.synonymy == null) {
            this.load();
        }
        LinkedList<Integer> syn = new LinkedList<Integer>();
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            if (entry.getValue() != prefID) continue;
            syn.add(entry.getKey());
        }
        return syn;
    }

    void remove(int specID) throws SQLException, SBPermissionException {
        if (this.synonymy == null) {
            this.load();
        }
        this.delete(specID);
        this.deleteSyn(specID);
    }

    void removeRefs(int specID) {
        if (this.synonymy != null) {
            this.synonymy.remove(specID);
            this.removeSyn(specID);
        }
    }

    void delete(int specID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        if (this.synonymy.get(specID) != null) {
            String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE spec_id=" + specID + " AND sch_id=" + this.getSchID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.synonymy.remove(specID);
        }
    }

    void deleteSyn(int specID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE pref=" + specID + " AND sch_id=" + this.getSchID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.removeSyn(specID);
    }

    private void removeSyn(int specID) {
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        Iterator<Map.Entry<Integer, Integer>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            if (entry.getValue() != specID) continue;
            it.remove();
        }
    }

    void updateSyn(int prefID, List<Integer> juniorSynonyms) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        if (this.synonymy == null) {
            this.load();
        }
        if (juniorSynonyms.contains(prefID)) {
            throw new IllegalStateException("Can't be a junior synonym of itself");
        }
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            for (Integer juniorID : juniorSynonyms) {
                if (entry.getValue().intValue() != juniorID.intValue()) continue;
                throw new SBException("Taxon: " + juniorID + " is already a preferred term");
            }
        }
        this.deleteSyn(prefID);
        if (!juniorSynonyms.isEmpty()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                for (Integer juniorID : juniorSynonyms) {
                    String deleteSQL = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE spec_id=" + juniorID + " AND sch_id=" + this.getSchID();
                    stmt.executeUpdate(deleteSQL);
                    String insertSQL = "INSERT INTO " + this.sbdb.DBTableName("synonymy") + " (spec_id,pref,sch_id) VALUES (" + juniorID + "," + prefID + "," + this.getSchID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(insertSQL));
                }
            }
        }
        for (Integer n : juniorSynonyms) {
            this.synonymy.put(n, prefID);
        }
    }

    public boolean hasSynonyms() {
        return this.synonymy != null && !this.synonymy.isEmpty();
    }

    public HashMap<Integer, Integer> getSynonyms() throws SQLException {
        if (this.synonymy == null) {
            this.load();
        }
        return new HashMap<Integer, Integer>(this.synonymy);
    }

    public int getNTerms() throws SQLException, SBException {
        int nTerms = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT count(spec_id) as nterms FROM " + this.sbdb.DBTableName("SYNONYMY") + " WHERE sch_id=" + this.getSchID();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nTerms = rs.getInt("nterms");
            }
            if (this.synonymy == null) {
                this.load();
            }
            if (nTerms != this.synonymy.size()) {
                throw new SBException("Number of terms from scheme: " + this.getSchID() + " does not match synonyms loaded: " + nTerms + " vs. " + this.synonymy.size());
            }
        }
        return nTerms;
    }

    void delete() throws SQLException, SBPermissionException {
        if (this.getSchID() == 1) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE sch_id=" + this.getSchID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("synsch") + " WHERE sch_id=" + this.getSchID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public void updateName(String name) throws SQLException, SBException, InvalidFieldException, SBPermissionException {
        if (name.equals(this.getName())) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT sch_id FROM " + this.sbdb.DBTableName("synsch") + " WHERE ucase(name)='" + name.toUpperCase() + "'";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                throw new InvalidFieldException("Scheme already exists");
            }
            sql = "UPDATE " + this.sbdb.DBTableName("synsch") + " SET name=" + SB.DBString((String)name) + " WHERE sch_id=" + this.getSchID();
            if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                throw new SBException("Cannot update synonym scheme name");
            }
            this.setName(name);
        }
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException, SQLException, SBException {
        assert (!this.sbdb.isConnected());
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        String ind2 = (String)ind + (String)ind + (String)ind;
        ind = (String)ind + (String)ind;
        out.write((String)ind + "<SchemeID>" + this.getSchID() + "</SchemeID>\n");
        out.write((String)ind + "<SchemeName>" + SB.getXMLstring((String)this.getName()) + "</SchemeName>\n");
        for (Map.Entry<Integer, Integer> entry : this.synonymy.entrySet()) {
            out.write((String)ind + "<Entry Species=\"" + SB.getXMLstring((String)this.sbdb.getTaxon(entry.getKey()).toString(false)) + "\">\n");
            out.write(ind2 + "<SpeciesID>" + String.valueOf(entry.getKey()) + "</SpeciesID>\n");
            out.write(ind2 + "<Pref>" + SB.getXMLstring((String)this.sbdb.getTaxon(entry.getValue()).toString(false)) + "</Pref>\n");
            out.write(ind2 + "<PrefID>" + String.valueOf(entry.getValue()) + "</PrefID>\n");
            out.write((String)ind + "</Entry>\n");
        }
    }

    static HashMap<Integer, SynonymScheme> getSchemes(SBdb sbdb) throws SQLException {
        HashMap<Integer, SynonymScheme> schemes = new HashMap<Integer, SynonymScheme>();
        schemes.put(1, new SynonymScheme(sbdb, 1, DEFAULT_TEXT));
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "SELECT sch_id,name FROM " + sbdb.DBTableName("SYNSCH");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("sch_id");
                String name = rs.getString("name");
                if (schemes.get(ID) == null) {
                    schemes.put(ID, new SynonymScheme(sbdb, ID, name));
                    continue;
                }
                if (ID == 1) continue;
                System.out.println("Duplicate Synonym Scheme: " + ID + "," + name);
            }
        }
        return schemes;
    }
}

