/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.GenusServiceListener;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.TaxonServiceListener;
import com.stratadata.model3.taxon.process.TaxonAdd;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.util.process.AbstractMultiStageProcess;
import com.stratadata.util.process.ProgressMonitor;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import model3.Audit;
import model3.Category;
import model3.Genus;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import model3.exception.SuppressedSQLException;
import model3.taxa.TaxonListener;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.listener.WeakListenerList;

public class TaxaMap
implements CategoryService,
GenusService,
TaxonService,
TaxonListener {
    private final SBdb sbdb;
    private final ConcurrentHashMap<Integer, Taxon> taxa = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Genus> genera = new ConcurrentHashMap();
    private final Map<Integer, Set<Taxon>> taxaByGenus = new ConcurrentHashMap<Integer, Set<Taxon>>();
    private ConcurrentHashMap<String, Category> categories;
    private final WeakListenerList<GenusServiceListener> genusServiceListeners = new WeakListenerList();
    private final WeakListenerList<TaxonServiceListener> taxonServiceListeners = new WeakListenerList();

    TaxaMap(SBdb sbdb) {
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to construct TaxaMap with no model");
        }
        this.sbdb = sbdb;
    }

    List<Taxon> getTaxa() {
        return new LinkedList<Taxon>(this.taxa.values());
    }

    public List<com.stratadata.model3.taxon.Taxon> getAllTaxa() {
        return this.taxa.values().stream().map(Taxon::getTaxonCopy).toList();
    }

    public boolean hasTaxon(Taxon taxon) {
        return this.taxa.containsValue(taxon);
    }

    Taxon getTaxon(int specID) throws SQLException {
        return this.getTaxon(specID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Taxon getTaxon(int specID, PreparedStatement speciesFillStatement) throws SQLException {
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null && this.sbdb.isConnected()) {
            boolean createdStatement = false;
            try {
                Taxon.Builder tBuilder;
                int genID;
                if (speciesFillStatement == null) {
                    speciesFillStatement = Taxon.getFillSpeciesStatement(this.sbdb);
                    createdStatement = true;
                }
                if ((genID = Taxon.fillSpecies(specID, speciesFillStatement, tBuilder = new Taxon.Builder())) == 0) {
                    Taxon taxon2 = null;
                    return taxon2;
                }
                tBuilder.genus(this.getGenus(genID).getGenusCopy());
                taxon = tBuilder.build(specID, this.sbdb);
                taxon = this.putSpecies(specID, taxon);
            }
            finally {
                if (createdStatement) {
                    speciesFillStatement.close();
                }
            }
        }
        return taxon;
    }

    public Optional<com.stratadata.model3.taxon.Taxon> findTaxon(int specID) {
        try {
            Taxon taxon = this.getTaxon(specID);
            return Optional.ofNullable(taxon != null ? taxon.getTaxonCopy() : null);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
    }

    Taxon getTaxon(Taxon.Builder builder) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get Taxon by builder");
        }
        int maxSpecID = 1;
        for (Taxon taxon : this.taxa.values()) {
            if (taxon.equalsBuilder(builder)) {
                return taxon;
            }
            if (taxon.getSpecID() < maxSpecID) continue;
            maxSpecID = taxon.getSpecID() + 1;
        }
        Taxon newTaxon = builder.build(maxSpecID, this.sbdb);
        newTaxon = this.putSpecies(maxSpecID, newTaxon);
        return newTaxon;
    }

    Taxon getTaxonFromName(String taxonName) throws SQLException {
        com.stratadata.model3.taxon.Taxon parsed = TaxonFactory.parse((String)taxonName);
        if (parsed == null) {
            return null;
        }
        parsed.getGenus().setCategory(null);
        List<com.stratadata.model3.taxon.Taxon> matches = this.findMatchingTaxa(parsed, null, SearchMode.LOOKUP);
        if (!matches.isEmpty()) {
            return this.taxa.get(matches.get(0).getSpecID());
        }
        this.loadCategories();
        List<com.stratadata.model3.taxon.Genus> matchingGenera = this.findMatchingGenera(parsed.getGenus(), SearchMode.LOOKUP);
        if (matchingGenera.size() == 1) {
            parsed.setGenus(matchingGenera.get(0));
            return this.getTaxon(this.addTaxon(parsed).getSpecID());
        }
        return null;
    }

    Genus getGenus(int genID) throws SQLException {
        return this.getGenus(genID, null);
    }

    Genus getGenus(int genID, Statement stmt) throws SQLException {
        Genus genus = this.genera.get(genID);
        if (genus == null && this.sbdb.isConnected() && (genus = Genus.load(this.sbdb, genID, stmt, null)) != null) {
            genus = this.putGenus(genID, genus);
        }
        return genus;
    }

    public Optional<com.stratadata.model3.taxon.Genus> findGenus(int genID) {
        try {
            Genus modelGen = this.getGenus(genID);
            return Optional.ofNullable(modelGen != null ? modelGen.getGenusCopy() : null);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
    }

    private Genus putGenus(int genID, Genus genus) {
        if (genus == null) {
            throw new IllegalArgumentException("Attempt to put null genus for ID: " + genID);
        }
        Genus existing = this.genera.putIfAbsent(genID, genus);
        if (existing != null && existing != genus) {
            if (existing.compareTo(genus) != 0) {
                throw new IllegalArgumentException("Attempt to replace genus with ID=" + genID + " in workspace: " + String.valueOf(existing) + " with: " + String.valueOf(genus));
            }
            return existing;
        }
        return genus;
    }

    private Taxon putSpecies(int specID, Taxon species) {
        if (species == null) {
            throw new IllegalArgumentException("Attempt to put null genus for ID: " + specID);
        }
        Taxon existing = this.taxa.putIfAbsent(specID, species);
        if (existing != null && existing != species) {
            if (existing.compareTo(species) > 0) {
                throw new IllegalArgumentException("Attempt to replace taxon with ID=" + specID + " in workspace: " + String.valueOf(existing) + " with: " + String.valueOf(species));
            }
            return existing;
        }
        species.registerListener(this);
        if (this.taxaByGenus.get(species.getGenID()) != null) {
            this.taxaByGenus.get(species.getGenID()).add(species);
        }
        return species;
    }

    void excludeTaxa(List<Taxon> toExclude) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to remove species from connected database");
        }
        for (Taxon t : toExclude) {
            this.taxa.remove(t.getSpecID());
        }
    }

    void loadTaxa(int wellID) throws SQLException {
        this.loadCategories();
        String sql = "SELECT " + TaxaMap.getColumnString(Genus.getSelectColumns(), "g") + "," + TaxaMap.getColumnString(Taxon.getSelectColumns(), "s");
        sql = sql + " FROM " + this.sbdb.DBTableName("species") + " s,";
        sql = sql + this.sbdb.DBTableName("genus") + " g, ";
        sql = sql + this.sbdb.DBTableName("taxonocc") + " t ";
        sql = sql + "WHERE g.gen_id=s.gen_id AND s.spec_id=t.spec_id AND t.well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.setFetchSize(500);
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                try {
                    int genID = rs.getInt("g_gen_id");
                    Genus genus = this.genera.get(genID);
                    if (genus == null) {
                        Genus.Builder genBuilder = Genus.getBuilderFromResultSet(rs, genID, this);
                        genus = genBuilder.build(genID, this);
                        genus = this.putGenus(genID, genus);
                    }
                    com.stratadata.model3.taxon.Genus dGen = genus.getGenusCopy();
                    int specID = rs.getInt("s_spec_id");
                    Taxon taxon = this.taxa.get(specID);
                    if (taxon != null) continue;
                    Taxon.Builder builder = Taxon.getBuilderFromResultSet(rs, specID);
                    builder.genus(dGen);
                    this.putSpecies(specID, builder.build(specID, this.sbdb));
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"Failed to load species: ", (Throwable)re);
                }
            }
        }
    }

    public com.stratadata.model3.taxon.Taxon addTaxon(com.stratadata.model3.taxon.Taxon taxon) throws SuppressedSQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store Taxon in unconnected database");
        }
        Taxon.Builder builder = new Taxon.Builder(taxon);
        try {
            Taxon t = builder.store(this.sbdb);
            t = this.putSpecies(t.getSpecID(), t);
            this.sbdb.commit();
            return t.getTaxonCopy();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withRollback("Error storing Taxon", sql, this.sbdb);
        }
        catch (SBPermissionException pe) {
            throw new RuntimeException(pe);
        }
    }

    Taxon addTaxon(Taxon.Builder txBuilder, Genus.Builder genBuilder, String cat_mnem, int specID, Integer genID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add Taxon to connected workspace");
        }
        if (specID <= 0) {
            throw new IllegalArgumentException("Attempt to add taxon to workspace with ID: " + specID);
        }
        com.stratadata.model3.taxon.Genus genus = this.addGenus(genBuilder, cat_mnem, genID).getGenusCopy();
        txBuilder.genus(genus);
        Taxon taxon = txBuilder.build(specID, this.sbdb);
        taxon = this.putSpecies(specID, taxon);
        return taxon;
    }

    private Genus addGenus(Genus.Builder genBuilder, String cat_mnem, Integer genID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add Taxon to connected workspace");
        }
        com.stratadata.model3.taxon.Category cat = null;
        try {
            Category model3Cat;
            if (cat_mnem == null) {
                cat_mnem = "";
            }
            cat = (model3Cat = this.getCategory(cat_mnem)) == null ? (cat_mnem.isEmpty() ? this.getNullDomainCategory() : this.addStoredCategory(cat_mnem, Discipline.MICRO, cat_mnem, Color.blue).getCategoryCopy()) : model3Cat.getCategoryCopy();
            genBuilder.genus.setCategory(cat);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Genus genus = this.findGenus(genBuilder);
        if (genus == null) {
            int id = genID != null && genID > 0 && this.genera.get(genID) == null ? genID.intValue() : this.nextGenID();
            genus = genBuilder.build(id, this);
            genus = this.putGenus(genus.getGenID(), genus);
        }
        return genus;
    }

    Taxon copyToWorkspace(Taxon dbTaxon, SBdb db) throws SQLException, SBException {
        if (this.sbdb.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Taxon to connected workspace");
        }
        Taxon taxon = this.taxa.get(dbTaxon.getSpecID());
        if (taxon == null) {
            Genus genus = this.genera.get(dbTaxon.getGenus().getGenID());
            if (genus == null) {
                Category dbCat = db.getCategory(dbTaxon.getGenus().getCategoryMnemonic());
                Category wsCat = this.getCategory(dbCat.getMnem());
                if (wsCat == null) {
                    wsCat = this.addStoredCategory(dbCat.getMnem(), dbCat.getDisc(), dbCat.getName(), dbCat.getColour());
                }
                Genus.Builder wsGenBuilder = Genus.Builder.copyOf(dbTaxon.getGenus());
                Audit.fillWorkspace(dbTaxon.getGenus().getAudit(), db, this.sbdb);
                genus = wsGenBuilder.build(dbTaxon.getGenus().getGenID(), this);
                genus = this.putGenus(genus.getGenID(), genus);
            }
            Taxon.Builder builder = Taxon.Builder.copyOf(dbTaxon);
            builder.genus(genus.getGenusCopy());
            builder.reference(null).notes(null).url(null);
            Audit.fillWorkspace(dbTaxon.getAudit(), db, this.sbdb);
            taxon = builder.build(dbTaxon.getSpecID(), this.sbdb);
            taxon.setLink(dbTaxon);
            taxon = this.putSpecies(taxon.getSpecID(), taxon);
        }
        return taxon;
    }

    Genus copyToWorkspace(Genus dbGenus, SBdb db) throws SQLException, SBException {
        if (this.sbdb.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Genus to connected workspace");
        }
        Genus genus = this.genera.get(dbGenus.getGenID());
        if (genus == null) {
            this.fillCategory(dbGenus.getCategory(), db);
            Genus.Builder wsGenBuilder = Genus.Builder.copyOf(dbGenus);
            Audit.fillWorkspace(dbGenus.getAudit(), db, this.sbdb);
            genus = wsGenBuilder.build(dbGenus.getGenID(), this);
            genus = this.putGenus(genus.getGenID(), genus);
        }
        return genus;
    }

    Category fillCategory(com.stratadata.model3.taxon.Category dbCat, SBdb db) throws SQLException {
        if (this.sbdb.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Genus to connected workspace");
        }
        Category wsCat = this.getCategory(dbCat.getMnemonic());
        if (wsCat == null) {
            wsCat = this.addStoredCategory(dbCat.getMnemonic(), dbCat.getDiscipline(), dbCat.getName(), dbCat.getColour());
        }
        return wsCat;
    }

    AbstractMultiStageProcess.ProcessResult copyToDataBase(com.stratadata.model3.taxon.Taxon domainWsTaxon, SBdb ws, com.stratadata.model3.taxon.Category category) {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy Taxon to unconnected database");
        }
        if (this.categories.get(category.getMnemonic()) == null) {
            throw new IllegalArgumentException("Could not copy taxon because category '" + String.valueOf(category) + "' was not recognised.");
        }
        com.stratadata.model3.taxon.Taxon taxonToAdd = new com.stratadata.model3.taxon.Taxon(0, Audit.createDbAuditImpl(this.sbdb, ws, domainWsTaxon.getAudit()));
        com.stratadata.model3.taxon.Taxon.copyFields((com.stratadata.model3.taxon.Taxon)taxonToAdd, (com.stratadata.model3.taxon.Taxon)domainWsTaxon, (boolean)false);
        com.stratadata.model3.taxon.Genus domainWsGenus = domainWsTaxon.getGenus();
        com.stratadata.model3.taxon.Genus genusToAdd = new com.stratadata.model3.taxon.Genus(0, Audit.createDbAuditImpl(this.sbdb, ws, domainWsGenus.getAudit()));
        com.stratadata.model3.taxon.Genus.copyFields((com.stratadata.model3.taxon.Genus)genusToAdd, (com.stratadata.model3.taxon.Genus)domainWsGenus, (boolean)false);
        genusToAdd.setCategory(category);
        taxonToAdd.setGenus(genusToAdd);
        TaxonAdd process = TaxonAdd.attemptAddWithoutConfirmations((TaxonService)this, (GenusService)this, (com.stratadata.model3.taxon.Taxon)taxonToAdd);
        if (process.succeeded()) {
            com.stratadata.model3.taxon.Genus existingMatchingGenus = process.getExistingMatchingGenus();
            if (existingMatchingGenus != null) {
                Genus modelGenus = this.genera.get(existingMatchingGenus.getGenID());
                modelGenus.setNotifySpeciesAdded(process.getSpecID());
                modelGenus.notifyListeners();
            }
            Taxon dbModelTaxon = this.taxa.get(process.getSpecID());
            try {
                ws.getTaxon(domainWsTaxon.getSpecID()).setLink(dbModelTaxon);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return process.getResult();
    }

    Genus copyToDataBase(Genus wsGenus, SBdb ws) throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy Taxon to unconnected database");
        }
        if (wsGenus.getCategory() == null || this.categories.get(wsGenus.getCategoryMnemonic()) == null) {
            throw new IllegalArgumentException("Could not copy taxon because category '" + String.valueOf(wsGenus.getCategory()) + "' was not recognised.");
        }
        Genus.Builder dbGenBuilder = Genus.Builder.copyOf(wsGenus);
        Genus dbGenus = this.findGenus(dbGenBuilder);
        if (dbGenus == null) {
            dbGenus = dbGenBuilder.store(this.sbdb);
            dbGenus = this.putGenus(dbGenus.getGenID(), dbGenus);
        }
        wsGenus.setLink(dbGenus);
        return dbGenus;
    }

    void copyLink(int specID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy taxon in connected workspace");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            throw new IllegalStateException("Attempt to copy link on non-existent taxon");
        }
        if (taxon.getLink() == null) {
            throw new IllegalArgumentException("Attempt to copy link on unlinked taxon: " + String.valueOf(taxon) + " ID=" + taxon.getSpecID());
        }
        Genus linkGen = taxon.getLink().getGenus();
        try {
            Category cat = this.getCategory(linkGen.getCategoryMnemonic());
            if (cat == null) {
                cat = this.addStoredCategory(linkGen.getCategory().getMnemonic(), linkGen.getCategory().getDiscipline(), linkGen.getCategory().getName(), linkGen.getCategory().getColour());
            }
            Taxon.Builder copyTx = Taxon.Builder.copyOf(taxon.getLink());
            Genus.Builder copyGen = Genus.Builder.copyOf(linkGen);
            if (!taxon.getGenus().equalsBuilder(copyGen, false)) {
                Genus newGen = this.findGenus(copyGen);
                if (newGen == null) {
                    newGen = copyGen.build(this.nextGenID(), this);
                    newGen = this.putGenus(newGen.getGenID(), newGen);
                }
                copyTx.genus(newGen.getGenusCopy());
            } else {
                copyTx.genus(taxon.getGenus().getGenusCopy());
            }
            taxon.update(this.sbdb, copyTx);
        }
        catch (SBPermissionException pe) {
            throw new IllegalStateException("Unexpected permission exception in workspace", pe);
        }
        catch (SQLException sql) {
            System.out.println("WARNING error copying fields to workspace taxon: " + String.valueOf(taxon));
            sql.printStackTrace();
        }
    }

    void loadAll() throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to load taxa from unconnected database");
        }
        this.loadCategories();
        HashMap<Integer, Genus> tempMap = new HashMap<Integer, Genus>();
        Genus.loadAll(this.sbdb, tempMap);
        for (Genus genus : tempMap.values()) {
            this.genera.putIfAbsent(genus.getGenID(), genus);
        }
        HashMap<Integer, Taxon> tempSpecMap = new HashMap<Integer, Taxon>();
        Taxon.loadAll(this.sbdb, tempSpecMap, this.genera);
        for (Taxon taxon : tempSpecMap.values()) {
            this.taxa.put(taxon.getSpecID(), taxon);
        }
    }

    int getSize() {
        return this.taxa.size();
    }

    Taxon getTaxon(String donorString, int specID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Looking for donor strings in database");
        }
        for (Taxon taxon : this.taxa.values()) {
            if (taxon.donorString == null || !taxon.donorString.equals(donorString)) continue;
            if (taxon.getSpecID() != specID) {
                this.taxa.put(specID, taxon);
            }
            return taxon;
        }
        return null;
    }

    Set<Taxon> getTaxa(int genID) throws SQLException {
        if (this.taxaByGenus.get(genID) == null) {
            HashSet<Taxon> tSet = new HashSet<Taxon>();
            if (this.sbdb.isConnected()) {
                String sql = "SELECT spec_id FROM " + this.sbdb.DBTableName("species") + " WHERE gen_id=" + genID;
                try (Statement stmt = this.sbdb.getDatabase().createStatement();
                     PreparedStatement pStmt = Taxon.getFillSpeciesStatement(this.sbdb);){
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    while (rs.next()) {
                        tSet.add(this.getTaxon(rs.getInt("spec_id"), pStmt));
                    }
                }
            }
            this.taxaByGenus.put(genID, tSet);
        }
        return new HashSet<Taxon>((Collection)this.taxaByGenus.get(genID));
    }

    public int getTaxonCountForGenus(int genID) {
        int n;
        block10: {
            if (this.taxaByGenus.get(genID) != null) {
                return this.taxaByGenus.get(genID).size();
            }
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                String sql = "SELECT count(spec_id) AS nspecies FROM " + this.sbdb.DBTableName("species") + " WHERE gen_id=" + genID;
                int nSpecies = 0;
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    nSpecies = rs.getInt("nspecies");
                }
                n = nSpecies;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback(e);
                }
            }
            stmt.close();
        }
        return n;
    }

    public com.stratadata.model3.taxon.Genus addGenus(com.stratadata.model3.taxon.Genus genus) throws SuppressedSQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store Genus in unconnected database");
        }
        Genus.Builder builder = new Genus.Builder(genus);
        try {
            Genus modelGen = builder.store(this.sbdb);
            modelGen = this.putGenus(modelGen.getGenID(), modelGen);
            this.sbdb.commit();
            return modelGen.getGenusCopy();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withRollback("Error storing Genus", sql, this.sbdb);
        }
    }

    public List<com.stratadata.model3.taxon.Genus> findMatchingGenera(com.stratadata.model3.taxon.Genus g, SearchMode searchMode) {
        LinkedList<com.stratadata.model3.taxon.Genus> linkedList;
        block11: {
            String sql = "SELECT " + TaxaMap.getColumnString(Genus.getSelectColumns(), "g") + " FROM " + this.sbdb.DBTableName("GENUS") + " g WHERE ";
            List<String> conditions = Genus.getSearchQueryConditions(g, searchMode);
            if (conditions.isEmpty()) {
                return Collections.emptyList();
            }
            sql = sql + StringUtils.join(conditions, (String)" AND ");
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                LinkedList<com.stratadata.model3.taxon.Genus> results = new LinkedList<com.stratadata.model3.taxon.Genus>();
                while (rs.next()) {
                    int genID = rs.getInt("g_gen_id");
                    if (this.genera.get(genID) == null) {
                        Genus.Builder genBuilder = Genus.getBuilderFromResultSet(rs, genID, this);
                        this.genera.put(genID, genBuilder.build(genID, this));
                    }
                    results.add(this.genera.get(genID).getGenusCopy());
                }
                Collections.sort(results);
                linkedList = results;
                if (stmt == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback(e);
                }
            }
            stmt.close();
        }
        return linkedList;
    }

    static String getColumnString(String[] columnNames, String alias) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            List<String> transformedColumns = Arrays.stream(columnNames).map(col -> alias + "." + col + " as " + alias + "_" + col).toList();
            return StringUtils.join(transformedColumns, (String)",");
        }
        return StringUtils.join(Arrays.asList(columnNames), (String)",");
    }

    public List<com.stratadata.model3.taxon.Taxon> findMatchingTaxa(com.stratadata.model3.taxon.Taxon t, Discipline discipline, SearchMode searchMode) throws SuppressedSQLException {
        LinkedList<com.stratadata.model3.taxon.Taxon> linkedList;
        block15: {
            try {
                this.loadCategories();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
            if (t.getGenus().getCategory() != null) {
                discipline = null;
            }
            String sql = "SELECT " + TaxaMap.getColumnString(Genus.getSelectColumns(), "g") + "," + TaxaMap.getColumnString(Taxon.getSelectColumns(), "s") + " FROM " + this.sbdb.DBTableName("GENUS") + " g, " + this.sbdb.DBTableName("SPECIES") + " s" + (String)(discipline != null ? ", " + this.sbdb.DBTableName("CATEGORY") + " c" : "") + " WHERE s.gen_id=g.gen_id" + (String)(discipline != null ? " AND g.cat_mnem=c.cat_mnem AND c.disc_id='" + discipline.getChar() + "' " : "");
            LinkedList<String> conditions = new LinkedList<String>();
            conditions.addAll(Genus.getSearchQueryConditions(t.getGenus(), searchMode));
            conditions.addAll(Taxon.getSearchQueryConditions(t, searchMode));
            if (!conditions.isEmpty()) {
                sql = sql + " AND ";
                sql = sql + StringUtils.join(conditions, (String)" AND ");
            }
            LinkedList<com.stratadata.model3.taxon.Taxon> results = new LinkedList<com.stratadata.model3.taxon.Taxon>();
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int specID = rs.getInt("s_spec_id");
                    if (this.taxa.get(specID) == null) {
                        Taxon.Builder txBuilder = Taxon.getBuilderFromResultSet(rs, specID);
                        int genID = rs.getInt("g_gen_id");
                        if (this.genera.get(genID) == null) {
                            Genus.Builder genBuilder = Genus.getBuilderFromResultSet(rs, genID, this);
                            this.genera.put(genID, genBuilder.build(genID, this));
                        }
                        txBuilder.genus(this.genera.get(genID).getGenusCopy());
                        this.taxa.put(specID, txBuilder.build(specID, this.sbdb));
                    }
                    results.add(this.taxa.get(specID).getTaxonCopy());
                }
                Collections.sort(results);
                linkedList = results;
                if (stmt == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback(e);
                }
            }
            stmt.close();
        }
        return linkedList;
    }

    public void updateGenus(int genID, com.stratadata.model3.taxon.Genus genus) {
        String origName;
        if (genus.getGenID() > 0 && genus.getGenID() != genID) {
            throw new IllegalArgumentException("Genus ID mismatch");
        }
        try {
            Genus modelGen = this.genera.get(genID);
            origName = modelGen.toString(false);
            modelGen.update(this.sbdb, genus);
            if (this.sbdb.isConnected()) {
                this.sbdb.commit();
            }
            modelGen.notifyListeners();
            com.stratadata.model3.taxon.Genus genusCopy = modelGen.getGenusCopy();
            this.genusServiceListeners.notify(l -> l.genusUpdated(genusCopy));
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error updating genus", e, this.sbdb);
        }
        if (this.taxaByGenus.get(genID) != null) {
            this.taxaByGenus.get(genID).stream().forEach(taxon -> this.taxonServiceListeners.notify(listener -> listener.taxonUpdated(taxon.getTaxonCopy())));
        } else {
            this.taxa.values().stream().filter(taxon -> taxon.getGenID() == genID).forEach(taxon -> this.taxonServiceListeners.notify(listener -> listener.taxonUpdated(taxon.getTaxonCopy())));
        }
        if (this.sbdb.isConnected()) {
            try {
                this.sbdb.updateAuditTrail("GENUS", "UPDATE " + origName + " [" + genID + "] to " + genus.toString(false));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error updating audit trail", e, this.sbdb);
            }
        }
    }

    public void updateTaxon(int specID, com.stratadata.model3.taxon.Taxon updated) {
        Taxon taxon = this.taxa.get(specID);
        Genus originalModelGenus = this.genera.get(taxon.getGenID());
        String origName = taxon.toString();
        SbugsValidator validator = SbugsValidator.validate((Object)updated, (SbugsValidator.ValidationStrategy)SbugsValidator.ValidationStrategy.IGNORE_ID);
        if (!validator.isValid()) {
            throw new IllegalArgumentException("Cannot update with invalid taxon:\n" + StringUtils.join((Iterable)validator.getMessages(), (String)"\n"));
        }
        if (updated.getGenus().getGenID() != originalModelGenus.getGenID() && this.genera.get(updated.getGenus().getGenID()) == null) {
            throw new IllegalArgumentException("Updated genus is not known to model");
        }
        try {
            taxon.update(this.sbdb, updated);
            this.sbdb.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error updating taxon", e, this.sbdb);
        }
        if (originalModelGenus != taxon.getGenus()) {
            if (this.taxaByGenus.get(originalModelGenus.getGenID()) != null) {
                this.taxaByGenus.get(originalModelGenus.getGenID()).remove(taxon);
            }
            originalModelGenus.setNotifySpeciesRemoved(specID);
            try {
                this.checkDeleteGenus(originalModelGenus.getGenID());
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error deleting unused genus", e, this.sbdb);
            }
            originalModelGenus.notifyListeners();
            if (this.taxaByGenus.get(taxon.getGenus().getGenID()) != null) {
                this.taxaByGenus.get(taxon.getGenus().getGenID()).add(taxon);
            }
            taxon.getGenus().setNotifySpeciesAdded(specID);
            taxon.getGenus().notifyListeners();
        }
        taxon.notifyListeners();
        com.stratadata.model3.taxon.Taxon taxonCopy = taxon.getTaxonCopy();
        this.taxonServiceListeners.notify(l -> l.taxonUpdated(taxonCopy));
        if (!origName.equals(taxon.toString())) {
            try {
                this.sbdb.updateAuditTrail("TAXON", "UPDATE " + origName + " [" + specID + "] to " + String.valueOf(taxon));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error updating audit trail", e, this.sbdb);
            }
        }
    }

    void updateSpecies(int specID, Taxon.Builder builder) throws SQLException, SBPermissionException {
        Taxon taxon = this.taxa.get(specID);
        Genus origGenus = taxon.getGenus();
        String origName = String.valueOf(taxon);
        taxon.update(this.sbdb, builder);
        if (origGenus != taxon.getGenus()) {
            if (this.taxaByGenus.get(origGenus.getGenID()) != null) {
                this.taxaByGenus.get(origGenus.getGenID()).remove(taxon);
            }
            origGenus.setNotifySpeciesRemoved(specID);
            this.checkDeleteGenus(origGenus.getGenID());
            origGenus.notifyListeners();
            if (this.taxaByGenus.get(taxon.getGenus().getGenID()) != null) {
                this.taxaByGenus.get(taxon.getGenus().getGenID()).add(taxon);
            }
            taxon.getGenus().setNotifySpeciesAdded(specID);
            taxon.getGenus().notifyListeners();
        }
        taxon.notifyListeners();
        com.stratadata.model3.taxon.Taxon taxonCopy = taxon.getTaxonCopy();
        this.taxonServiceListeners.notify(l -> l.taxonUpdated(taxonCopy));
        if (!origName.equals(taxon.toString())) {
            this.sbdb.updateAuditTrail("TAXON", "UPDATE " + origName + " [" + specID + "] to " + String.valueOf(taxon));
        }
    }

    private void loadCategories() throws SQLException {
        this.loadCategories(false);
    }

    private void loadCategories(boolean force) throws SQLException {
        if (this.categories == null || force) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                HashMap<String, Category> categoriesTemp = new HashMap<String, Category>();
                String sql = "SELECT disc_id, cat_mnem, cat_name, colour FROM " + this.sbdb.DBTableName("category") + " ORDER BY cat_mnem";
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    while (rs.next()) {
                        Discipline discID = Discipline.getDisc((char)SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                        String mnem = rs.getString("cat_mnem");
                        String name = rs.getString("cat_name");
                        if (!name.isEmpty() && !StringUtils.isMixedCase((CharSequence)name)) {
                            name = StringUtils.capitalize((String)name.toLowerCase().trim());
                        }
                        Color colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                        Category cat = new Category(discID, mnem, name, colour);
                        categoriesTemp.put(cat.getMnem(), cat);
                    }
                }
                if (this.categories == null) {
                    this.categories = new ConcurrentHashMap();
                } else {
                    this.categories.clear();
                }
                this.categories.putAll(categoriesTemp);
            } else if (this.categories == null) {
                this.categories = new ConcurrentHashMap();
            }
        }
    }

    CategoryService getCategoryService() {
        try {
            this.loadCategories();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        return this;
    }

    public List<com.stratadata.model3.taxon.Category> getCategoryList() {
        return this.categories.values().stream().sorted().map(Category::getCategoryCopy).toList();
    }

    public com.stratadata.model3.taxon.Category addCategory(com.stratadata.model3.taxon.Category cat) {
        try {
            this.loadCategories();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        if (this.findCategory(cat.getMnemonic()).isPresent()) {
            throw new IllegalArgumentException("Category already exists (" + cat.getMnemonic() + ")");
        }
        if (this.sbdb != null && this.sbdb.isConnected()) {
            String sql = "INSERT INTO " + this.sbdb.DBTableName("category") + " (disc_id, cat_mnem, cat_name, colour) VALUES (" + SB.DBChar((char)Discipline.getChar((Discipline)cat.getDiscipline())) + "," + SB.DBString((String)cat.getMnemonic()) + "," + SB.DBString((String)cat.getName()) + "," + ColourUtils.DBColourString((Color)cat.getColour(), (boolean)false, (boolean)true) + ")";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error storing new category", e, this.sbdb);
            }
        }
        Category category = new Category(cat);
        this.categories.put(cat.getMnemonic(), category);
        return category.getCategoryCopy();
    }

    Category addStoredCategory(String mnem, Discipline discID, String name, Color colour) throws SQLException {
        this.addCategory(mnem, discID, name, colour);
        return this.categories.get(mnem);
    }

    public Optional<com.stratadata.model3.taxon.Category> findCategory(String mnemonic) {
        Category cat = this.categories.get(mnemonic);
        if (cat != null) {
            return Optional.of(cat.getCategoryCopy());
        }
        return Optional.empty();
    }

    private Category getSuperCat(String mnem) throws SQLException {
        this.loadCategories();
        mnem = mnem.toUpperCase();
        Category supercat = this.categories.get(mnem);
        while (supercat == null && mnem.length() > 1) {
            supercat = this.categories.get(mnem);
            mnem = mnem.substring(0, mnem.length() - 1);
        }
        return supercat;
    }

    public Optional<com.stratadata.model3.taxon.Category> findCategoryOrSuperCategory(String mnemonic) {
        Category supercat;
        try {
            supercat = this.getSuperCat(mnemonic);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return Optional.ofNullable(supercat != null ? supercat.getCategoryCopy() : null);
    }

    Category getCategory(String mnem) throws SQLException {
        this.loadCategories();
        return this.categories.get(mnem);
    }

    public void deleteCategory(String mnemonic) {
        try {
            this.loadCategories();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        Category cat = this.categories.get(mnemonic);
        if (cat.getNGenera() > 0) {
            throw new IllegalStateException("Attempt to delete category containing genera");
        }
        try {
            cat.delete(this.sbdb);
            if (this.sbdb.isConnected()) {
                this.sbdb.updateAuditTrail("CATEGORY", "DELETE " + cat.getName() + " [" + cat.getMnem() + "]");
                this.sbdb.commit();
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting category", e, this.sbdb);
        }
        this.categories.remove(cat.getMnem());
    }

    public void updateCategory(String mnemonic, com.stratadata.model3.taxon.Category newCategory) throws SuppressedSQLException {
        try {
            this.loadCategories();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        Category category = this.categories.get(mnemonic);
        try {
            category.update(this.sbdb, newCategory.getMnemonic(), newCategory.getDiscipline(), newCategory.getName(), newCategory.getColour());
            if (this.sbdb.isConnected()) {
                this.sbdb.updateAuditTrail("CATEGORY", "UPDATE " + category.getMnem() + " [" + mnemonic + "]");
                this.sbdb.commit();
            }
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withRollback("Error updating category", sql, this.sbdb);
        }
        if (!mnemonic.equalsIgnoreCase(newCategory.getMnemonic())) {
            this.categories.remove(mnemonic);
            this.categories.put(category.getMnem(), category);
        }
        this.genera.values().stream().filter(g -> g.getCategoryMnemonic().equals(mnemonic)).forEach(genus -> genus.onCategoryDetailsUpdated(mnemonic, category.getCategoryCopy()));
    }

    public Map<String, Long> getCategoryOccurrences() {
        try {
            this.loadCategories();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        for (Category cat : this.categories.values()) {
            cat.setNGenera(0);
        }
        try {
            String sql = "SELECT cat_mnem, count(cat_mnem) AS genera FROM " + this.sbdb.DBTableName("genus") + " GROUP BY (cat_mnem) ORDER BY (cat_mnem)";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    String mnem = rs.getString("cat_mnem");
                    int genera = rs.getInt("genera");
                    Category cat = this.getCategory(mnem);
                    if (cat == null) {
                        cat = this.addStoredCategory(mnem, Discipline.PALY, "NO NAME category " + mnem, null);
                    }
                    cat.setNGenera(genera);
                }
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        this.categories.values().forEach(category -> map.put(category.getMnem(), Long.valueOf(category.getNGenera())));
        return map;
    }

    void cleanTaxon(int specID, boolean convertCase, boolean clearCat, Boolean spSpp) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to clean database taxon");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            return;
        }
        com.stratadata.model3.taxon.Category cat = clearCat ? this.getNullDomainCategory() : taxon.getGenus().getCategory();
        taxon.clean(convertCase, spSpp);
        taxon.getGenus().clean(convertCase, cat);
    }

    private Category getNullCategory() {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to find dummy category in connected workspace");
        }
        try {
            Category cat = this.getCategory("");
            if (cat == null) {
                cat = this.addStoredCategory("", Discipline.MICRO, "no_category", Color.BLACK);
            }
            return cat;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private com.stratadata.model3.taxon.Category getNullDomainCategory() {
        return this.getNullCategory().getCategoryCopy();
    }

    private Genus findGenus(Genus.Builder builder) {
        for (Genus g : this.genera.values()) {
            if (!g.equalsBuilder(builder, false)) continue;
            return g;
        }
        return null;
    }

    void checkDeleteGenus(int genID) throws SQLException {
        Genus genus = this.genera.get(genID);
        if (genus == null) {
            throw new IllegalArgumentException("Attempt to delete non-loaded genus: " + genID);
        }
        try {
            if (genus.checkDelete(this.sbdb)) {
                this.genera.remove(genID);
            }
        }
        catch (SBException sbe) {
            System.out.println("WARNING: Genus not deleted: " + genus.getGenus());
        }
    }

    public void deleteTaxa(Collection<Integer> specIDs, ProgressMonitor progressMonitor) {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new RuntimeException(new SBPermissionException("No permission to delete taxa"));
        }
        try {
            Taxon.deleteSpecies(this.sbdb, specIDs, true, progressMonitor);
            if (progressMonitor != null && progressMonitor.isInterrupted()) {
                this.sbdb.doRollback();
                return;
            }
            this.sbdb.commit();
        }
        catch (SQLException sqlEx) {
            throw SuppressedSQLException.withRollback("Error deleting taxa", sqlEx, this.sbdb);
        }
        ArrayList<CallSite> actionNamesSpecies = new ArrayList<CallSite>();
        for (int specID : specIDs) {
            Taxon removed = this.taxa.remove(specID);
            if (removed != null) {
                removed.setNotifyDeleted();
                removed.notifyListeners();
                actionNamesSpecies.add((CallSite)((Object)("DELETE " + removed.toString(true, false, true) + " [" + specID + "]")));
                if (this.taxaByGenus.get(removed.getGenID()) != null) {
                    this.taxaByGenus.get(removed.getGenID()).remove(removed);
                }
                removed.getGenus().setNotifySpeciesRemoved(specID);
                continue;
            }
            actionNamesSpecies.add((CallSite)((Object)("DELETE species  [" + specID + "]")));
        }
        this.taxonServiceListeners.stream().forEach(l -> l.taxaDeleted(specIDs));
        if (!actionNamesSpecies.isEmpty()) {
            try {
                this.sbdb.updateAuditTrail("TAXON", actionNamesSpecies.toArray(new String[actionNamesSpecies.size()]));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error updating audit trail", e, this.sbdb);
            }
        }
    }

    public void deleteGenera(Collection<Integer> genIDs, ProgressMonitor progressMonitor) {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new RuntimeException(new SBPermissionException("No permission to delete genera"));
        }
        HashSet<Integer> deletedGenIDs = new HashSet<Integer>(genIDs);
        try {
            Genus.deleteGenera(this.sbdb, deletedGenIDs, progressMonitor);
            if (progressMonitor != null && progressMonitor.isInterrupted()) {
                this.sbdb.doRollback();
                return;
            }
            this.sbdb.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting genera", e, this.sbdb);
        }
        ArrayList<CallSite> actionNamesGenus = new ArrayList<CallSite>();
        for (Integer genID : deletedGenIDs) {
            Genus removed = this.genera.remove(genID);
            if (removed != null) {
                actionNamesGenus.add((CallSite)((Object)("DELETE " + removed.toString(true) + " [" + genID + "]")));
                removed.setNotifyDeleted();
                this.taxaByGenus.remove(genID);
                continue;
            }
            actionNamesGenus.add((CallSite)((Object)("DELETE genus  [" + genID + "]")));
        }
        this.genusServiceListeners.stream().forEach(l -> l.generaDeleted((Collection)deletedGenIDs));
        for (Integer genID : genIDs) {
            if (deletedGenIDs.contains(genID)) continue;
            this.genera.get(genID).notifyListeners();
        }
        if (!actionNamesGenus.isEmpty()) {
            try {
                this.sbdb.updateAuditTrail("GENUS", actionNamesGenus.toArray(new String[actionNamesGenus.size()]));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error updating audit", e, this.sbdb);
            }
        }
    }

    public Set<Integer> getUnusedGenera(Collection<Integer> genIDs) {
        HashSet<Integer> unused = new HashSet<Integer>();
        String sql = "SELECT distinct gen_id from " + this.sbdb.DBTableName("GENUS") + " where gen_id IN(SELECT distinct gen_id from " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " where gen_id=?) OR gen_ID IN(SELECT distinct gen_id FROM " + this.sbdb.DBTableName("SPECIES") + " WHERE gen_id=?)";
        try (PreparedStatement pStmt = this.sbdb.getDatabase().prepareStatement(this.sbdb.modQuery(sql));){
            for (Integer genID : genIDs) {
                pStmt.setInt(1, genID);
                pStmt.setInt(2, genID);
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) continue;
                unused.add(genID);
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return unused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTaxa(Connection conn) throws SQLException {
        Logger logger = Logger.getLogger(TaxaMap.class.getName() + " REFRESH TASK");
        logger.info("Starting genus refresh...");
        this.loadCategories(true);
        try (Statement stmt = conn.createStatement();){
            ArrayList<Integer> deletedGenera = new ArrayList<Integer>();
            try (PreparedStatement pStmtGenus = conn.prepareStatement(this.sbdb.modQuery("SELECT updated, cat_mnem FROM " + this.sbdb.DBTableName("GENUS") + " WHERE gen_id=?"));){
                Iterator<Genus> it = this.genera.values().iterator();
                while (it.hasNext()) {
                    Genus genus = it.next();
                    pStmtGenus.setInt(1, genus.getGenID());
                    ResultSet rs = pStmtGenus.executeQuery();
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp("updated");
                        String mnem = rs.getString("cat_mnem");
                        if (time != null && (genus.getAudit().getUpdated() == null || genus.getAudit().getUpdated().isBefore(((Date)time).toInstant()))) {
                            Genus.load(this.sbdb, genus.getGenID(), stmt, genus);
                            genus.notifyListeners();
                            continue;
                        }
                        Category cat = this.categories.get(mnem);
                        genus.onCategoryDetailsUpdated(mnem, cat.getCategoryCopy());
                        continue;
                    }
                    it.remove();
                    this.taxaByGenus.remove(genus.getGenID());
                    deletedGenera.add(genus.getGenID());
                }
            }
            if (!deletedGenera.isEmpty()) {
                logger.info("Notifying taxaMap observers for deleted genera...");
                this.genusServiceListeners.notify(l -> l.generaDeleted((Collection)deletedGenera));
            }
            logger.info("Starting taxa refresh...");
            PreparedStatement pStmtSpeciesUpdate = conn.prepareStatement(this.sbdb.modQuery("SELECT updated FROM " + this.sbdb.DBTableName("SPECIES") + " WHERE spec_id=?"));
            Statement pStmt = null;
            ArrayList<Integer> deletedTaxa = new ArrayList<Integer>();
            try {
                Iterator<Taxon> it = this.taxa.values().iterator();
                while (it.hasNext()) {
                    Taxon taxon = it.next();
                    pStmtSpeciesUpdate.setInt(1, taxon.getSpecID());
                    ResultSet rs = pStmtSpeciesUpdate.executeQuery();
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp("updated");
                        if (time == null || taxon.getAudit().getUpdated() != null && !taxon.getAudit().getUpdated().isBefore(((Date)time).toInstant())) continue;
                        if (pStmt == null) {
                            pStmt = Taxon.getFillSpeciesStatement(this.sbdb);
                        }
                        Taxon.Builder builder = new Taxon.Builder();
                        int genID = Taxon.fillSpecies(taxon.getSpecID(), (PreparedStatement)pStmt, builder);
                        builder.genus(this.getGenus(genID).getGenusCopy());
                        taxon.copyFields(builder);
                        logger.config("Notifiying taxon observers for changed genus...");
                        taxon.notifyListeners();
                        logger.config("Notified taxon observers for changed genus");
                        this.taxonServiceListeners.notify(l -> l.taxonUpdated(taxon.getTaxonCopy()));
                        continue;
                    }
                    it.remove();
                    deletedTaxa.add(taxon.getSpecID());
                }
            }
            finally {
                pStmtSpeciesUpdate.close();
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            if (!deletedTaxa.isEmpty()) {
                logger.info("Notifying taxaMap observers for deleted taxa...");
                this.taxonServiceListeners.notify(l -> l.taxaDeleted((Collection)deletedTaxa));
            }
            logger.info("Refreshing taxaByGenus...");
            try (PreparedStatement speciesSelectStmt = Taxon.getFillSpeciesStatement(this.sbdb);
                 PreparedStatement genusSelectStmt = conn.prepareStatement(this.sbdb.modQuery("SELECT spec_id FROM " + this.sbdb.DBTableName("species") + " WHERE gen_id=?"));){
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.genera.keySet()).iterator();
                while (iterator.hasNext()) {
                    int genID = (Integer)iterator.next();
                    if (this.taxaByGenus.get(genID) == null) continue;
                    genusSelectStmt.setInt(1, genID);
                    HashSet<Taxon> tSet = new HashSet<Taxon>();
                    ResultSet rs = genusSelectStmt.executeQuery();
                    while (rs.next()) {
                        tSet.add(this.getTaxon(rs.getInt("spec_id"), speciesSelectStmt));
                    }
                    this.taxaByGenus.put(genID, tSet);
                }
            }
        }
    }

    Taxon parse(String s, int specID, boolean notNull, com.stratadata.model3.taxon.Category category) {
        Genus genus;
        BuilderPair bp = TaxaMap.parse(s);
        if (bp == null) {
            if (notNull) {
                Object string = s;
                for (int its = 3; bp == null && its > 0; --its) {
                    string = (String)string + " unknown";
                    bp = TaxaMap.parse((String)string);
                }
                if (bp == null) {
                    throw new IllegalArgumentException("Cannot create Taxon from string: '" + s + "'");
                }
            } else {
                return null;
            }
        }
        if (this.categories == null) {
            try {
                this.loadCategories(true);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        Category cat = this.getNullCategory();
        if (category != null) {
            bp.genusBuilder.genus.setCategory(category);
        }
        if ((genus = this.findGenus(bp.genusBuilder)) == null) {
            genus = bp.genusBuilder.build(this.nextGenID(), this);
            genus = this.putGenus(genus.getGenID(), genus);
        }
        bp.taxonBuilder.genus(genus.getGenusCopy());
        Taxon taxon = bp.taxonBuilder.build(specID, this.sbdb);
        taxon.donorString = s;
        this.taxa.put(specID, taxon);
        return taxon;
    }

    void setTaxonCat(int specID, String cat_mnem) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set taxon category in connected workspace");
        }
        Taxon taxon = this.taxa.get(specID);
        if (taxon == null) {
            return;
        }
        try {
            Category cat = this.categories.get(cat_mnem);
            if (cat == null) {
                cat = this.addStoredCategory(cat_mnem, Discipline.MICRO, cat_mnem, Color.blue);
            }
            taxon.getGenus().clean(false, cat.getCategoryCopy());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int nextGenID() {
        int maxID = 1;
        for (Genus g : this.genera.values()) {
            if (g.getGenID() < maxID) continue;
            maxID = g.getGenID() + 1;
        }
        return maxID;
    }

    void merge(Taxon donor, Taxon target, int targetSpecType, int retainJuniorSynonym) throws SQLException, SBException, SBPermissionException {
        boolean genusDeleted = Taxon.merge(this.sbdb, true, donor.getSpecID(), target.getSpecID(), targetSpecType, retainJuniorSynonym);
        this.sbdb.commit();
        target.updateMergeRefs(donor);
        if (retainJuniorSynonym == 0) {
            if (this.taxa.remove(donor.getSpecID()) != null) {
                this.taxonServiceListeners.notify(l -> l.taxaDeleted(List.of(Integer.valueOf(donor.getSpecID()))));
            }
            if (genusDeleted) {
                this.genera.remove(donor.getGenID());
            }
        }
        this.sbdb.updateAuditTrail("TAXON", "MERGE " + String.valueOf(donor) + " [" + donor.getSpecID() + "] with " + String.valueOf(target) + " [" + target.getSpecID() + "]");
    }

    public static BuilderPair parse(String s) {
        String stripped;
        int i;
        String[] arr = s.split(" ");
        if (arr.length < 1) {
            return null;
        }
        Genus.Builder genBuilder = new Genus.Builder();
        Taxon.Builder txBuilder = new Taxon.Builder();
        Qualifier q1 = genBuilder.genus.getQualifier(0);
        Qualifier q2 = genBuilder.genus.getQualifier(1);
        for (i = 0; i < arr.length; ++i) {
            if (!genBuilder.getName().isEmpty()) {
                if (arr[i].startsWith("(") && i < arr.length - 1) {
                    String subGen = arr[i].replaceAll("\\(", "").replaceAll("\\)", "");
                    genBuilder.subGenus(subGen);
                    ++i;
                }
                q1 = genBuilder.genus.getQualifier(1);
                q2 = txBuilder.getQualifier(0);
                break;
            }
            stripped = TaxonQual.stripQualifiers((String)arr[i], (Qualifier)q1, (Qualifier)q2);
            if (stripped.isEmpty()) continue;
            genBuilder.genusName(stripped);
        }
        if (i == arr.length) {
            return null;
        }
        while (i < arr.length) {
            if (q1 == genBuilder.genus.getQualifier(1) && (arr[i].endsWith(TaxonQual.Q.toString()) || arr[i].startsWith(TaxonQual.Q.toString())) || arr[i].endsWith(TaxonQual.QUOTE.toString()) || arr[i].startsWith(TaxonQual.QUOTE.toString())) {
                q1 = q2;
                q2 = txBuilder.getQualifier(1);
            }
            stripped = TaxonQual.stripQualifiers((String)arr[i], (Qualifier)q1, (Qualifier)q2);
            if (q1 == genBuilder.genus.getQualifier(1) && q1.hasQuals()) {
                q1 = q2;
                q2 = txBuilder.getQualifier(1);
            }
            if (!stripped.isEmpty()) {
                if (txBuilder.getName().isEmpty() || !txBuilder.getQualifier(1).hasQuals()) {
                    txBuilder.speciesAdd(stripped);
                    q1 = txBuilder.getQualifier(1);
                    q2 = txBuilder.getQualifier(2);
                } else {
                    txBuilder.subSpecies(stripped);
                    ++i;
                    break;
                }
            }
            ++i;
        }
        if (txBuilder.getName().isEmpty()) {
            return null;
        }
        if (i < arr.length) {
            q1 = txBuilder.getQualifier(2);
            q2 = txBuilder.getQualifier(3);
            while (i < arr.length) {
                stripped = TaxonQual.stripQualifiers((String)arr[i], (Qualifier)q1, (Qualifier)q2);
                if (!stripped.isEmpty()) {
                    txBuilder.author((String)(txBuilder.getAuthor().isEmpty() ? "" : txBuilder.getAuthor() + " ") + stripped);
                }
                ++i;
            }
        }
        return new BuilderPair(txBuilder, genBuilder);
    }

    public static BuilderPair copy(Taxon taxon) {
        Genus.Builder genBuilder = Genus.Builder.copyOf(taxon.getGenus());
        Taxon.Builder txBuilder = Taxon.Builder.copyOf(taxon);
        return new BuilderPair(txBuilder, genBuilder);
    }

    Taxon parseTaxon(Element xml, ZipFile zip) throws SBException, SQLException {
        Object strgID;
        String cat_mnem = "";
        Genus.Builder genBuilder = new Genus.Builder();
        Taxon.Builder txBuilder = new Taxon.Builder();
        String strg = xml.getChildText("Category");
        if (strg != null) {
            cat_mnem = strg;
        }
        if ((strgID = xml.getChildTextNormalize("GenusID")) == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int genID = Integer.parseInt((String)strgID);
        strgID = xml.getChildTextNormalize("SpeciesID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int specID = Integer.parseInt((String)strgID);
        txBuilder.species(xml.getChildText("Species"));
        genBuilder.genusName(xml.getChildText("Genus"));
        strg = xml.getChildText("GQ1");
        if (strg != null) {
            genBuilder.qual(0, strg);
        }
        if ((strg = xml.getChildText("GQ2")) != null) {
            genBuilder.qual(1, strg);
        }
        if ((strg = xml.getChildText("GQ3")) != null) {
            genBuilder.qual(2, strg);
        }
        if ((strg = xml.getChildText("GQ4")) != null) {
            genBuilder.qual(3, strg);
        }
        if ((strg = xml.getChildText("SubGenus")) != null) {
            genBuilder.subGenus(strg);
        }
        if ((strg = xml.getChildText("SQ1")) != null) {
            txBuilder.qual(4, strg);
        }
        if ((strg = xml.getChildText("SQ2")) != null) {
            txBuilder.qual(5, strg);
        }
        if ((strg = xml.getChildText("SQ3")) != null) {
            txBuilder.qual(6, strg);
        }
        if ((strg = xml.getChildText("SQ4")) != null) {
            txBuilder.qual(7, strg);
        }
        if ((strg = xml.getChildText("SubSpecies")) != null) {
            txBuilder.subSpecies(strg);
        }
        if ((strg = xml.getChildText("Alphacode")) != null) {
            txBuilder.alphaCode(strg);
        }
        if ((strg = xml.getChildText("Author")) != null) {
            txBuilder.author(strg);
        }
        if ((strg = xml.getChildText("Notes")) != null) {
            txBuilder.notes(strg);
        }
        if ((strg = xml.getChildText("Reference")) != null) {
            txBuilder.reference(strg);
        }
        if ((strg = xml.getChildText("URL")) != null) {
            txBuilder.reference(strg);
        }
        if ((strgID = xml.getChildTextNormalize("Year")) != null) {
            if (!txBuilder.getAuthor().isEmpty()) {
                strgID = txBuilder.getAuthor() + " " + (String)strgID;
            }
            txBuilder.author((String)strgID);
        }
        Taxon taxon = this.addTaxon(txBuilder, genBuilder, cat_mnem, specID, genID);
        taxon.donorString = taxon.toString(true, false);
        taxon.noAuthorDonorString = taxon.toString(false, false);
        IteratorIterable imageSetElementIterator = xml.getDescendants((Filter)new ElementFilter("ImageSet"));
        while (imageSetElementIterator.hasNext()) {
            Element xmlImageSet = (Element)imageSetElementIterator.next();
            IteratorIterable imageIterator = xmlImageSet.getDescendants((Filter)new ElementFilter("Image"));
            ArrayList<ImageRecord> imageRecords = new ArrayList<ImageRecord>();
            while (imageIterator.hasNext()) {
                Element imageElement = (Element)imageIterator.next();
                String idString = imageElement.getChildTextNormalize("ImageID");
                if (idString == null) {
                    throw new SBException("ID null in XML - invalid");
                }
                int imageID = Integer.parseInt(idString);
                String fileName = imageElement.getChildTextNormalize("File");
                String caption = imageElement.getChildTextNormalize("Caption");
                imageRecords.add(new ImageRecord(imageID, caption, fileName));
            }
            int imageSetID = this.sbdb.getImageRecordService().storeImageSet(0, imageRecords, this.sbdb.getImageLoader());
            this.sbdb.getTaxonImageService().addTaxonImageSet(specID, new TaxonImageSet(imageSetID, specID, true));
        }
        return taxon;
    }

    Genus parseGenus(Element xml, ZipFile zip) throws SBException {
        String strgID;
        String cat_mnem = "";
        Genus.Builder genBuilder = new Genus.Builder();
        String strg = xml.getChildText("Category");
        if (strg != null) {
            cat_mnem = strg;
        }
        if ((strgID = xml.getChildTextNormalize("GenusID")) == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int genID = Integer.parseInt(strgID);
        genBuilder.genusName(xml.getChildText("Genus"));
        strg = xml.getChildText("GQ1");
        if (strg != null) {
            genBuilder.qual(0, strg);
        }
        if ((strg = xml.getChildText("GQ2")) != null) {
            genBuilder.qual(1, strg);
        }
        if ((strg = xml.getChildText("GQ3")) != null) {
            genBuilder.qual(2, strg);
        }
        if ((strg = xml.getChildText("GQ4")) != null) {
            genBuilder.qual(3, strg);
        }
        if ((strg = xml.getChildText("SubGenus")) != null) {
            genBuilder.subGenus(strg);
        }
        if (this.genera.get(genID) != null) {
            genBuilder.genus.setCategory(new com.stratadata.model3.taxon.Category(cat_mnem));
            if (!this.genera.get(genID).equalsBuilder(genBuilder, false)) {
                throw new SBException("Mismatching genera in workspace with ID " + genID);
            }
            return this.genera.get(genID);
        }
        return this.addGenus(genBuilder, cat_mnem, genID);
    }

    void matchTaxon(Taxon wsTx, boolean ignoreUnknownCategories) throws SQLException {
        if (wsTx.getLink() != null) {
            return;
        }
        this.loadCategories();
        com.stratadata.model3.taxon.Taxon query = wsTx.getTaxonCopy();
        com.stratadata.model3.taxon.Category category = query.getGenus().getCategory();
        if (category == null || category.getMnemonic().isEmpty()) {
            category = null;
        } else if (this.findCategory(category.getMnemonic()).isEmpty()) {
            if (ignoreUnknownCategories) {
                category = null;
            } else {
                return;
            }
        }
        query.getGenus().setCategory(category);
        query.setAlphaCode("%");
        List<com.stratadata.model3.taxon.Taxon> matchingTaxa = this.findMatchingTaxa(query, null, SearchMode.LOOKUP);
        if (matchingTaxa.isEmpty() && !query.getSpecies().isEmpty() && !query.getSpecies().startsWith("sp.") && query.getSubSpecies().isEmpty()) {
            String[] s = query.getSpecies().split("\\s+");
            if (s.length > 1) {
                String species = s[0];
                int l = 1;
                Object subSpec = s[l++];
                while (l < s.length) {
                    subSpec = (String)subSpec + " " + s[l++];
                }
                query.setSpecies(species);
                query.setSubSpecies((String)subSpec);
                matchingTaxa = this.findMatchingTaxa(query, null, SearchMode.LOOKUP);
            }
        } else if (matchingTaxa.isEmpty() && !query.getSpecies().isEmpty() && !query.getSubSpecies().isEmpty()) {
            String species = query.getSpecies() + " " + query.getSubSpecies();
            query.setSpecies(species);
            query.setSubSpecies("");
            matchingTaxa = this.findMatchingTaxa(query, null, SearchMode.LOOKUP);
        }
        if (!matchingTaxa.isEmpty()) {
            Taxon dbTaxon = this.getTaxon(matchingTaxa.get(0).getSpecID());
            wsTx.setLink(dbTaxon);
        }
    }

    void matchGenera(SBdb db, Collection<Genus> toMatch, boolean ignoreCategory) throws SQLException {
        assert (!this.sbdb.isConnected());
        for (Genus genus : toMatch) {
            List matchingGenera;
            if (this.getGenus(genus.getGenID()) != genus) {
                throw new IllegalArgumentException("Genus mismatch with ID: " + genus.getGenID());
            }
            if (genus.getLink() != null) continue;
            com.stratadata.model3.taxon.Genus query = genus.getGenusCopy();
            String cat_mnem = genus.getCategoryMnemonic();
            if (cat_mnem.isEmpty()) {
                query.setCategory(null);
            } else if (!cat_mnem.isEmpty() && db.getCategory(cat_mnem) == null) {
                if (!ignoreCategory) continue;
                query.setCategory(null);
            }
            if ((matchingGenera = db.getGenusService().findMatchingGenera(query, SearchMode.LOOKUP)).isEmpty()) continue;
            genus.setLink(db.getGenus(((com.stratadata.model3.taxon.Genus)matchingGenera.get(0)).getGenID()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getGenusCount() {
        try {
            String sql = "SELECT count(gen_id) AS ngenera FROM " + this.sbdb.DBTableName("GENUS");
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (!rs.next()) return 0;
                int n = rs.getInt("ngenera");
                return n;
            }
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
    }

    public int getTaxonCount() {
        try {
            String sql = "SELECT count(spec_id) AS nspecies FROM " + this.sbdb.DBTableName("species");
            int nSpecies = 0;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    nSpecies = rs.getInt("nspecies");
                }
            }
            return nSpecies;
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
    }

    public void addListener(GenusServiceListener listener) {
        this.genusServiceListeners.addListener((Object)listener);
    }

    public void removeListener(GenusServiceListener listener) {
        this.genusServiceListeners.deleteListener((Object)listener);
    }

    public void addListener(TaxonServiceListener listener) {
        this.taxonServiceListeners.addListener((Object)listener);
    }

    public void removeListener(TaxonServiceListener listener) {
        this.taxonServiceListeners.deleteListener((Object)listener);
    }

    @Override
    public void onTaxonDelete(Taxon taxon) {
    }

    @Override
    public void onTaxonDetailsUpdated(Taxon taxon) {
        com.stratadata.model3.taxon.Taxon t = taxon.getTaxonCopy();
        this.taxonServiceListeners.notify(listener -> listener.taxonUpdated(t));
    }

    public static class BuilderPair {
        public final Taxon.Builder taxonBuilder;
        public final Genus.Builder genusBuilder;

        BuilderPair(Taxon.Builder txBuilder, Genus.Builder genBuilder) {
            if (txBuilder == null || genBuilder == null) {
                throw new IllegalArgumentException("Attempt to create BuilderPair with one or more null Builder");
            }
            this.taxonBuilder = txBuilder;
            this.genusBuilder = genBuilder;
        }

        public String toString() {
            Object s = this.genusBuilder.getName();
            if (!this.genusBuilder.getSubGenus().isEmpty()) {
                s = (String)s + " " + this.genusBuilder.getSubGenus();
            }
            s = (String)s + " " + this.taxonBuilder.getName();
            if (!this.taxonBuilder.getSubSpecies().isEmpty()) {
                s = (String)s + " " + this.taxonBuilder.getSubSpecies();
            }
            return s;
        }
    }
}

