/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.ws.XmlWriter;
import com.stratadata.util.process.ProgressMonitor;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import model3.Audit;
import model3.CoOccurrence;
import model3.Genus;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TaxonCompareAlphaCode;
import model3.TaxonCompareCategory;
import model3.TaxonCompareSIPMCode;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.exception.SuppressedSQLException;
import model3.project.Project;
import model3.taxa.GenusListener;
import model3.taxa.TaxonCompareGenus;
import model3.taxa.TaxonCompareSpecies;
import model3.taxa.TaxonListener;
import model3.taxa.TaxonUpdatePublisher;
import org.apache.commons.lang3.StringUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.SortEntry;
import util.exception.StackError;
import util.listener.Observable;
import util.listener.Publisher;
import util.status.SbugsStatus;

public class Taxon
implements Comparable,
SortEntry,
SbugsStatus,
SbugsLink,
GenusListener,
Observable<TaxonListener>,
Publisher {
    private final SBdb sbdb;
    private com.stratadata.model3.taxon.Taxon taxon;
    String donorString = "";
    String noAuthorDonorString = null;
    String donorOccType = "In-situ";
    private Taxon link;
    private HashMap<Integer, Integer> sipmCode = null;
    public static final String INSITU_OCC = "In-situ";
    public static final String REWORKED_OCC = "Reworked";
    public static final String CAVED_OCC = "Caved";
    public static final String QUESTIONABLE_OCC = "Questionable";
    static Boolean exportImages = null;
    private final TaxonUpdatePublisher updatePublisher = new TaxonUpdatePublisher(this);
    static SimpleDateFormat databaseDate = new SimpleDateFormat("yyyy-MM-dd");
    public static boolean includeAuthorInString = false;
    public static boolean includeCategoryInString = true;
    public static boolean includeAlphaInString = false;
    static int NQUAL = 8;
    static int[] preqal = new int[]{1, 0, 1, 0, 1, 0, 1, 0};
    static int NSYM = 9;
    static int MAXSYM = 6;
    static String[] qulsym = new String[]{"\"", "?", "cf.", "aff.", "ss.", "sl.", "grp.", "sensu", "var."};
    static int[][] symord = new int[][]{{1, 2, 3, 0, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, 7}, {2, 3, 0, 8, -1, -1}, {1, 0, 4, 5, 7, -1}};
    static int[][] mutexc = new int[][]{{1, 1, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 2, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 2}, {1, 1, 0, 0, 2, 2, 0, 2, 0}};

    public void registerListener(TaxonListener l) {
        this.updatePublisher.registerListener(l);
    }

    public void deleteListener(TaxonListener l) {
        this.updatePublisher.deleteListener(l);
    }

    public void notifyListeners() {
        try {
            Genus genus = this.sbdb.getGenus(this.taxon.getGenus().getGenID());
            if (genus != null) {
                genus.notifyListeners();
            }
            this.updatePublisher.notifyListeners();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setNotifyDeleted() {
        this.updatePublisher.setTaxonDeleted();
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public Taxon getLink() {
        return this.link;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public void setLink(Taxon link) {
        this.link = link;
    }

    public int getSpecID() {
        return this.taxon.getSpecID();
    }

    public String getSortEntry() {
        return this.toString(false, true);
    }

    public int getGenID() {
        return this.taxon.getGenus().getGenID();
    }

    public String getDonorString() {
        return this.donorString;
    }

    public String getDonorOccType() {
        return this.donorOccType;
    }

    public void setDonorOccType(String str) {
        this.donorOccType = str;
    }

    public String getCatMnem() {
        return this.taxon.getGenus().getCategory().getMnemonic();
    }

    public String getGenusName() {
        return this.taxon.getGenus().getGenusName();
    }

    public String getSubGenus() {
        return this.taxon.getGenus().getSubGenus();
    }

    public String getSpecies() {
        return this.taxon.getSpecies();
    }

    public String getSubSpecies() {
        return this.taxon.getSubSpecies();
    }

    public String getAuthor() {
        return this.taxon.getAuthor();
    }

    public String getAlphaCode() {
        return this.taxon.getAlphaCode();
    }

    public Genus getGenus() {
        try {
            return this.sbdb.getGenus(this.taxon.getGenus().getGenID());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public com.stratadata.model3.taxon.Taxon getTaxonCopy() {
        com.stratadata.model3.taxon.Genus copiedGenus = com.stratadata.model3.taxon.Genus.copy((com.stratadata.model3.taxon.Genus)this.taxon.getGenus());
        com.stratadata.model3.taxon.Taxon copiedTaxon = com.stratadata.model3.taxon.Taxon.copy((com.stratadata.model3.taxon.Taxon)this.taxon);
        copiedTaxon.setGenus(copiedGenus);
        return copiedTaxon;
    }

    public com.stratadata.model3.audit.Audit getAudit() {
        return this.taxon.getAudit();
    }

    public Qualifier getQualifier(int pos) {
        return this.taxon.getQualifier(pos);
    }

    public Qualifier getQualifierSpecies(int field) {
        if (field < 0 || field > 3) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + field);
        }
        return this.getQualifier(field + 4);
    }

    public Qualifier getQ1() {
        return this.taxon.getQ1();
    }

    public Qualifier getQ2() {
        return this.taxon.getQ2();
    }

    public Qualifier getQ3() {
        return this.taxon.getQ3();
    }

    public Qualifier getQ4() {
        return this.taxon.getQ4();
    }

    public String getNotes() {
        return this.taxon.getNotes();
    }

    public String getReference() {
        return this.taxon.getReference();
    }

    public void setURL(String url, boolean storeInDatabase) {
        if (storeInDatabase) assert (false);
        this.taxon.setUrl(url);
    }

    public String getURL() {
        return this.taxon.getUrl();
    }

    void copyFields(Builder builder) {
        builder.validateFields();
        com.stratadata.model3.taxon.Taxon.copyFields((com.stratadata.model3.taxon.Taxon)this.taxon, (com.stratadata.model3.taxon.Taxon)builder.taxon);
        try {
            Genus modelGenus = this.sbdb.getGenus(this.getGenus().getGenID());
            this.taxon.setGenus(modelGenus.getGenusCopy());
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withoutRollback(ex);
        }
        this.updatePublisher.setTaxonDetailsChanged();
    }

    public void setAlphaCode(String alphaCode) throws SQLException {
        com.stratadata.model3.taxon.Taxon updatedTaxon = com.stratadata.model3.taxon.Taxon.copy((com.stratadata.model3.taxon.Taxon)this.taxon);
        updatedTaxon.setAlphaCode(alphaCode);
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                updatedTaxon.updateAudit((UserService)this.sbdb, Audit.getDatabaseServerDate(this.sbdb, stmt).toInstant());
                String sql = "UPDATE " + this.sbdb.DBTableName("species") + " SET alphacode=" + SB.DBString((String)alphaCode) + "," + Audit.sqlUpdate(updatedTaxon.getAudit()) + " WHERE spec_id=" + this.getSpecID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.taxon = updatedTaxon;
        this.updatePublisher.setTaxonDetailsChanged();
    }

    static PreparedStatement getFillSpeciesStatement(SBdb db) throws SQLException {
        Object sql = "SELECT gen_id,q1,species,q2,q3,sub_spec,q4,alphaCode,author,reference,notes,url," + Audit.sqlFieldString();
        sql = (String)sql + " FROM " + db.DBTableName("species") + " s WHERE spec_id=?";
        sql = db.modQuery((String)sql);
        PreparedStatement pStmt = db.getDatabase().prepareStatement((String)sql);
        return pStmt;
    }

    static String[] getSelectColumns() {
        return new String[]{"spec_id", "gen_id", "species", "sub_spec", "q1", "q2", "q3", "q4", "alphaCode", "author", "reference", "notes", "url", "creator", "created", "modifier", "modified", "updater", "updated"};
    }

    static List<String> getSearchQueryConditions(com.stratadata.model3.taxon.Taxon t, SearchMode searchMode) {
        BiFunction<String, String, String> queryFunction = switch (searchMode) {
            default -> throw new MatchException(null, null);
            case SearchMode.LOOKUP -> (columnName, s) -> "lcase(" + columnName + ")=lcase(" + SB.DBString((String)s) + ")";
            case SearchMode.SEARCH -> (columnName, s) -> "lcase(" + columnName + ") like lcase(" + SB.DBString((String)s) + ")";
            case SearchMode.SOUNDEX -> (columnName, s) -> "upper(soundex(" + columnName + "))=soundex('" + s.replaceAll("%", "") + "')";
        };
        Predicate<String> useField = fieldValue -> !fieldValue.trim().isEmpty() && !"%".equals(fieldValue);
        LinkedList<String> conditions = new LinkedList<String>();
        if (useField.test(t.getSpecies())) {
            String speciesName = t.getSpecies();
            Object speciesNameCondition = queryFunction.apply("s.species", speciesName);
            if (searchMode == SearchMode.SEARCH) {
                speciesNameCondition = t.getSpecies().split(" ").length > 1 && !useField.test(t.getSubSpecies()) ? queryFunction.apply("CONCAT(s.species, ' ', s.sub_spec)", speciesName) : "(" + (String)speciesNameCondition + " OR " + queryFunction.apply("s.species", "(" + speciesName + ")") + ")";
            }
            conditions.add((String)speciesNameCondition);
        }
        if (useField.test(t.getSubSpecies())) {
            String subSpeciesName = t.getSubSpecies();
            conditions.add(queryFunction.apply("s.sub_spec", subSpeciesName));
        } else if (searchMode == SearchMode.LOOKUP) {
            conditions.add("(s.sub_spec IS NULL or s.sub_spec='')");
        }
        for (int i = 4; i < 8; ++i) {
            if (t.getQualifier(i).hasQuals()) {
                if (searchMode == SearchMode.LOOKUP) {
                    conditions.add("lcase(s.q" + (i - 3) + ")='" + t.getQualifier(i).toString(false) + "'");
                    continue;
                }
                conditions.add("lcase(s.q" + (i - 3) + ") like '%" + t.getQualifier(i).toString(false) + "%'");
                continue;
            }
            if (searchMode != SearchMode.LOOKUP) continue;
            conditions.add("(s.q" + (i - 3) + " IS NULL or s.q" + (i - 3) + "='')");
        }
        if (useField.test(t.getAlphaCode()) && searchMode == SearchMode.SEARCH) {
            conditions.add(queryFunction.apply("s.alphacode", t.getAlphaCode()));
        }
        return conditions;
    }

    static int fillSpecies(int specID, PreparedStatement pStmt, Builder builder) throws SQLException {
        pStmt.setInt(1, specID);
        int genID = 0;
        ResultSet rs = pStmt.executeQuery();
        if (rs.next()) {
            AuditImpl audit = Audit.getAuditFromResultSet(rs);
            builder.taxon = new com.stratadata.model3.taxon.Taxon(specID, audit);
            genID = rs.getInt("gen_id");
            builder.qual(4, rs.getString("q1"));
            builder.species(rs.getString("species"));
            builder.qual(5, rs.getString("q2"));
            builder.qual(6, rs.getString("q3"));
            builder.subSpecies(rs.getString("sub_spec"));
            builder.qual(7, rs.getString("q4"));
            builder.alphaCode(rs.getString("alphacode"));
            builder.author(rs.getString("author"));
            builder.reference(rs.getString("reference"));
            builder.notes(rs.getString("notes"));
            builder.url(rs.getString("url"));
        }
        return genID;
    }

    static Builder getBuilderFromResultSet(ResultSet rs, int specID) throws SQLException {
        AuditImpl audit = Audit.getAuditFromResultSet(rs, "s_");
        com.stratadata.model3.taxon.Taxon taxon = new com.stratadata.model3.taxon.Taxon(specID, audit);
        taxon.setSpecies(rs.getString("s_species"));
        taxon.setSubSpecies(rs.getString("s_sub_spec"));
        for (int i = 4; i < 8; ++i) {
            taxon.setQualifier(i, new Qualifier(i, rs.getString("s_q" + (i - 3))));
        }
        taxon.setAlphaCode(rs.getString("s_alphacode"));
        taxon.setAuthor(rs.getString("s_author"));
        taxon.setReference(rs.getString("s_reference"));
        taxon.setNotes(rs.getString("s_notes"));
        taxon.setUrl(rs.getString("s_url"));
        Builder builder = new Builder(taxon);
        return builder;
    }

    public Integer getSipmCode(int dictionary) throws SQLException {
        if (this.sipmCode == null) {
            this.sipmCode = new HashMap();
            String sql = "SELECT ccode,sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.getSpecID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int ccode = rs.getInt("ccode");
                    int code = rs.getInt("sipm_code");
                    this.sipmCode.put(ccode, code);
                }
            }
        }
        if (this.sipmCode.get(dictionary) == null) {
            String sql = "SELECT sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.getSpecID() + " AND ccode=" + dictionary;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    int code = rs.getInt("SIPM_CODE");
                    this.sipmCode.put(dictionary, code);
                }
            }
        }
        return this.sipmCode.get(dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCoOccurrences(SBdb sbdb, int donor, int target, int targetSpecType, int wellListID, int restrictToWellID) throws SBException, SQLException {
        if (wellListID > 0 && restrictToWellID > 0) {
            throw new IllegalArgumentException("Error in call to checkOccOccurrences - can't specify both well list and wellID");
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT w.well_name,w.units,w.well_id,w.well_code,s.top_depth,s.base_depth,s.type,f1.samp_id,f1.analy_id,f1.ident_type,f1.situation,f1.spec_type_id FROM " + sbdb.DBTableName("TAXONOCC") + " f1, " + sbdb.DBTableName("TAXONOCC") + " f2," + sbdb.DBTableName("WELLS") + " w," + sbdb.DBTableName("SAMPLES") + " s ";
        if (wellListID > 0) {
            sql = sql + ", " + sbdb.DBTableName("WELLIST_MBR") + " l ";
        }
        sql = sql + " WHERE  f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id AND f1.spec_id=" + donor + " AND f2.spec_id=" + target + " AND f1.situation=f2.situation  AND f1.ident_type=f2.ident_type  AND f1.spec_type_id=f2.spec_type_id  AND f1.well_id=f2.well_id  AND f1.samp_id=s.samp_id AND f1.well_id=w.well_id AND w.well_id=s.well_id";
        if (wellListID > 0) {
            sql = sql + " AND s.well_id = l.well_id AND l.wellist_id=" + wellListID;
        }
        if (restrictToWellID > 0) {
            sql = sql + " AND s.well_id=" + restrictToWellID;
        }
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<CoOccurrence> coOccurrences = new LinkedList<CoOccurrence>();
            String lastCode = "";
            while (rs.next()) {
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                int wellID = rs.getInt("well_id");
                String wellCode = rs.getString("well_code");
                Object item = "";
                if (!wellCode.equals(lastCode)) {
                    item = wellName;
                    item = (String)item + "(";
                    item = (String)item + wellCode;
                    item = (String)item + ")";
                    item = (String)item + ", ";
                    lastCode = wellCode;
                } else {
                    item = (String)item + "  ...";
                }
                BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                if (topDepth != null) {
                    item = (String)item + SB.getDepthString((double)topDepth.doubleValue(), (char)units, (int)2);
                }
                if (baseDepth != null) {
                    if (topDepth != null) {
                        item = (String)item + "-";
                    }
                    item = (String)item + SB.getDepthString((double)baseDepth.doubleValue(), (char)units, (int)2);
                }
                item = (String)item + ", ";
                item = (String)item + rs.getString("type");
                item = (String)item + " (SampID=";
                int sampID = rs.getInt("samp_id");
                item = (String)item + sampID;
                item = (String)item + ")";
                int analyID = rs.getInt("analy_id");
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                Situation situation = Situation.parse((String)rs.getString("situation"));
                int specType = rs.getInt("spec_type_id");
                CoOccurrence coOcc = new CoOccurrence();
                coOcc.wellID = wellID;
                coOcc.sampID = sampID;
                coOcc.analyID = analyID;
                coOcc.reason = item;
                coOcc.target = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(target), situation, identType, specType);
                coOcc.donor = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(donor), situation, identType, specType);
                coOccurrences.add(coOcc);
            }
            if (coOccurrences.size() > 0) {
                SBException e = new SBException("Cannot update/merge taxon (ID=" + donor + ", to ID=" + target + ") because it would create co-occurring data\nThe samples in which this happens are listed");
                e.setData(coOccurrences);
                throw e;
            }
        }
        finally {
            stmt.close();
        }
    }

    public void updateOccSpecType(int newSpecType) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "SELECT w.well_name,f1.well_id,f1.samp_id,f1.analy_id,f1.ident_type,f1.situation,f1.spec_type_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " f1, " + this.sbdb.DBTableName("TAXONOCC") + " f2," + this.sbdb.DBTableName("WELLS") + " w  WHERE  f1.well_id=f2.well_id AND f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id AND f1.spec_id=" + this.getSpecID() + " AND f2.spec_id=" + this.getSpecID() + " AND f1.situation=f2.situation  AND f1.ident_type=f2.ident_type  AND f1.spec_type_id<>f2.spec_type_id AND f1.well_id=w.well_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashMap<CallSite, Integer> occs = new HashMap<CallSite, Integer>();
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                char identType = rs.getString("ident_type").charAt(0);
                Situation situation = Situation.parse((String)rs.getString("situation"));
                int specType = rs.getInt("spec_type_id");
                String wellName = rs.getString("well_name");
                String key = "" + wellID + sampID + analyID + identType + situation.toChar();
                if (occs.get(key) != null) {
                    throw new SBException("Cannot update sub-type for '" + String.valueOf(this) + "' because it would cause conflicting occurrences in well " + wellName + ".");
                }
                occs.put((CallSite)((Object)key), specType);
            }
            sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET spec_type_id=" + newSpecType + " WHERE spec_id=" + this.getSpecID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAll(SBdb sbdb, Map<Integer, Taxon> set, Map<Integer, Genus> genera) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,spec_id,q1,species,q2,q3,sub_spec,q4,alphacode,author,reference,notes,url," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("species") + " ORDER BY spec_id";
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int genID = rs.getInt("gen_id");
                int specID = rs.getInt("spec_id");
                if (set.get(specID) != null) continue;
                AuditImpl audit = Audit.getAuditFromResultSet(rs);
                com.stratadata.model3.taxon.Taxon taxon = new com.stratadata.model3.taxon.Taxon(specID, audit);
                Builder builder = new Builder(taxon);
                builder.genus(genera.get(genID).getGenusCopy());
                builder.qual(4, rs.getString("q1"));
                builder.species(SB.getDBString((ResultSet)rs, (String)"species"));
                builder.qual(5, rs.getString("q2"));
                builder.qual(6, rs.getString("q3"));
                builder.subSpecies(rs.getString("sub_spec"));
                builder.qual(7, rs.getString("q4"));
                builder.alphaCode(rs.getString("alphaCode"));
                builder.author(rs.getString("author"));
                builder.reference(rs.getString("reference"));
                builder.notes(rs.getString("notes"));
                builder.url(rs.getString("url"));
                try {
                    Taxon t = builder.build(specID, sbdb);
                    set.put(t.getSpecID(), t);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Throwable)re);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    static boolean merge(SBdb sbdb, boolean checkCoOccurrences, int donor, int target, int targetSpecType, int retainJuniorSynonym) throws SBException, SQLException, SBPermissionException {
        if (checkCoOccurrences) {
            Taxon.checkCoOccurrences(sbdb, donor, target, targetSpecType, 0, 0);
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            boolean bl;
            block35: {
                Statement stmt2 = sbdb.getDatabase().createStatement();
                try {
                    TxGroup g;
                    int grpID;
                    Object sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + target;
                    ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        grpID = rs.getInt("grp_id");
                        sql = "DELETE FROM ";
                        sql = (String)sql + sbdb.DBTableName("GROUPMBR");
                        sql = (String)sql + " WHERE spec_id=" + donor;
                        sql = (String)sql + " AND grp_id=" + grpID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        g = sbdb.getTxGroup(grpID);
                        g.updateAudit();
                    }
                    sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        grpID = rs.getInt("grp_id");
                        g = sbdb.getTxGroup(grpID);
                        g.updateAudit();
                    }
                    sql = "UPDATE " + sbdb.DBTableName("GROUPMBR") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    int donorGenID = 0;
                    sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        donorGenID = rs.getInt("gen_id");
                    }
                    boolean deleteGenus = true;
                    sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + donorGenID + " AND spec_id <>" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    if (rs.next()) {
                        deleteGenus = false;
                    }
                    if (retainJuniorSynonym == 0 && deleteGenus) {
                        Genus genus = sbdb.getGenus(donorGenID);
                        ArrayList<Genus> genera = new ArrayList<Genus>();
                        genera.add(genus);
                        sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=" + donorGenID;
                        rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                        while (rs.next()) {
                            grpID = rs.getInt("grp_id");
                            TxGroup g2 = sbdb.getTxGroup(grpID);
                            g2.deleteGenera(genera);
                            g2.updateAudit();
                        }
                    }
                    sql = "SELECT ovr_id FROM ";
                    sql = (String)sql + sbdb.DBTableName("OVR_MAP");
                    sql = (String)sql + " WHERE spec_id=" + target;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        int ovrID = rs.getInt("ovr_id");
                        sql = "DELETE FROM ";
                        sql = (String)sql + sbdb.DBTableName("OVR_MAP");
                        sql = (String)sql + " WHERE spec_id=" + donor;
                        sql = (String)sql + " AND ovr_id=" + ovrID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("OVR_MAP") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    if (retainJuniorSynonym == 0) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=" + donor + " AND pref=" + target;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=" + target + " AND pref=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    if (retainJuniorSynonym > 0) {
                        sql = "SELECT pref FROM ";
                        sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                        rs = stmt.executeQuery(sbdb.modQuery((String)(sql = (String)sql + " WHERE pref=" + target + " AND spec_id=" + donor + " AND sch_id=" + retainJuniorSynonym)));
                        if (!rs.next()) {
                            sql = "INSERT INTO ";
                            sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                            sql = (String)sql + " (sch_id, pref, spec_id) VALUES (" + retainJuniorSynonym + "," + target + "," + donor + ")";
                            stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        }
                    } else {
                        sql = "SELECT pref,sch_id FROM ";
                        sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                        sql = (String)sql + " WHERE spec_id=" + target;
                        rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                        while (rs.next()) {
                            int prefID = rs.getInt("pref");
                            int schID = rs.getInt("sch_id");
                            sql = "DELETE FROM ";
                            sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                            sql = (String)sql + " WHERE spec_id=" + donor;
                            sql = (String)sql + " AND pref=" + prefID;
                            sql = (String)sql + " AND sch_id=" + schID;
                            stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        }
                        sql = "UPDATE " + sbdb.DBTableName("SYNONYMY") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                        sql = "UPDATE " + sbdb.DBTableName("SYNONYMY") + " SET pref=" + target + " WHERE pref=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("SIPMCODE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    sql = "UPDATE " + sbdb.DBTableName("SPECIMEN") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    Audit.setServerDate(sbdb, stmt);
                    sql = "SELECT well_id, samp_id, analy_id FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        int wellID = rs.getInt("well_id");
                        int sampID = rs.getInt("samp_id");
                        int analyID = rs.getInt("analy_id");
                        sql = "UPDATE " + sbdb.DBTableName("SMPDTL") + " SET updater=" + sbdb.getUser().getUsrID() + ",updated='" + SB.DBdtf.format(Audit.serverDate) + "' WHERE  well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    stmt2.close();
                    sql = "UPDATE " + sbdb.DBTableName("TAXONOCC") + " SET spec_id=" + target;
                    if (targetSpecType > -1) {
                        sql = (String)sql + ",spec_type_id=" + targetSpecType;
                    }
                    sql = (String)sql + " WHERE spec_id=" + donor;
                    System.out.println("SQL: " + sbdb.modQuery((String)sql));
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXLOAD") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    sql = "UPDATE " + sbdb.DBTableName("TXIMAGE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    sql = "UPDATE " + sbdb.DBTableName("SPECIES") + " SET author=(SELECT author FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor + ") WHERE spec_id=" + target + " AND (author is null or author='')";
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    sql = "UPDATE " + sbdb.DBTableName("SPECIES") + " SET reference=(SELECT reference FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor + ") WHERE spec_id=" + target + " AND (reference is null or reference='')";
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    sql = "UPDATE " + sbdb.DBTableName("SPECIES") + " SET notes=(SELECT notes FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor + ") WHERE spec_id=" + target + " AND (notes is null or notes='')";
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    sql = "UPDATE " + sbdb.DBTableName("SPECIES") + " SET url=(SELECT url FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor + ") WHERE spec_id=" + target + " AND (url is null or url='')";
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    if (retainJuniorSynonym == 0) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                        if (deleteGenus) {
                            sql = "DELETE FROM " + sbdb.DBTableName("groupmbr_genus") + " WHERE gen_id=" + donorGenID;
                            sql = "DELETE FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + donorGenID;
                            stmt.executeUpdate(sbdb.modQuery((String)sql));
                        }
                    }
                    boolean bl2 = bl = deleteGenus && retainJuniorSynonym == 0;
                    if (stmt2 == null) break block35;
                }
                catch (Throwable throwable) {
                    if (stmt2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt2.close();
            }
            return bl;
        }
    }

    void updateMergeRefs(Taxon donor) {
        if (StringUtils.isBlank((CharSequence)this.getAuthor()) && !StringUtils.isBlank((CharSequence)donor.getAuthor())) {
            this.taxon.setAuthor(donor.getAuthor());
        }
        if (StringUtils.isBlank((CharSequence)this.getReference()) && !StringUtils.isBlank((CharSequence)donor.getReference())) {
            this.taxon.setReference(donor.getReference());
        }
        if (StringUtils.isBlank((CharSequence)this.getNotes()) && !StringUtils.isBlank((CharSequence)donor.getNotes())) {
            this.taxon.setNotes(donor.getNotes());
        }
        if (StringUtils.isBlank((CharSequence)this.getURL()) && !StringUtils.isBlank((CharSequence)donor.getURL())) {
            this.taxon.setUrl(donor.getURL());
        }
    }

    void update(SBdb sbdb, Builder builder) throws SQLException, SBPermissionException {
        if (sbdb.isConnected() && !SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException("No permission to edit taxon");
        }
        if (sbdb.isConnected()) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                builder.taxon.updateAudit((UserService)sbdb, Audit.getDatabaseServerDate(sbdb, stmt).toInstant());
                String sql = "UPDATE " + sbdb.DBTableName("species") + " SET gen_id=" + builder.taxon.getGenus().getGenID() + ",q1=" + SB.DBString((String)builder.taxon.getQ1().toString(false)) + ",q2=" + SB.DBString((String)builder.taxon.getQ2().toString(false)) + ",q3=" + SB.DBString((String)builder.taxon.getQ3().toString(false)) + ",q4=" + SB.DBString((String)builder.taxon.getQ4().toString(false)) + ",species=" + SB.DBString((String)builder.taxon.getSpecies()) + ",sub_spec=" + SB.DBString((String)builder.taxon.getSubSpecies()) + ",alphacode=" + SB.DBString((String)builder.taxon.getAlphaCode()) + ",author=" + SB.DBString((String)builder.taxon.getAuthor()) + ",reference=" + SB.DBString((String)builder.taxon.getReference()) + ",notes=" + SB.DBString((String)builder.taxon.getNotes()) + ",url=" + SB.DBString((String)builder.taxon.getUrl()) + "," + Audit.sqlUpdate(builder.taxon.getAudit()) + " WHERE spec_id=" + this.getSpecID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.copyFields(builder);
    }

    void update(SBdb sbdb, com.stratadata.model3.taxon.Taxon taxon) throws SQLException {
        if (sbdb.isConnected()) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                taxon.updateAudit((UserService)sbdb, Audit.getDatabaseServerDate(sbdb, stmt).toInstant());
                String sql = "UPDATE " + sbdb.DBTableName("species") + " SET gen_id=" + taxon.getGenus().getGenID() + ",q1=" + SB.DBString((String)taxon.getQ1().toString(false)) + ",q2=" + SB.DBString((String)taxon.getQ2().toString(false)) + ",q3=" + SB.DBString((String)taxon.getQ3().toString(false)) + ",q4=" + SB.DBString((String)taxon.getQ4().toString(false)) + ",species=" + SB.DBString((String)taxon.getSpecies()) + ",sub_spec=" + SB.DBString((String)taxon.getSubSpecies()) + ",alphacode=" + SB.DBString((String)taxon.getAlphaCode()) + ",author=" + SB.DBString((String)taxon.getAuthor()) + ",reference=" + SB.DBString((String)taxon.getReference()) + ",notes=" + SB.DBString((String)taxon.getNotes()) + ",url=" + SB.DBString((String)taxon.getUrl()) + "," + Audit.sqlUpdate(taxon.getAudit()) + " WHERE spec_id=" + this.getSpecID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        taxon.setGenus((com.stratadata.model3.taxon.Genus)sbdb.getGenusService().findGenus(taxon.getGenus().getGenID()).get());
        com.stratadata.model3.taxon.Taxon.copyFields((com.stratadata.model3.taxon.Taxon)this.taxon, (com.stratadata.model3.taxon.Taxon)taxon);
        this.updatePublisher.setTaxonDetailsChanged();
    }

    public int checkOcc(boolean withSpecType) throws SQLException {
        if (this.getSpecID() < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        Object sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.getSpecID();
        if (withSpecType) {
            sql = (String)sql + " AND spec_type_id > 0";
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        return nSpecies;
    }

    public int checkOcc(int specTypeID) throws SQLException {
        if (this.getSpecID() < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        Object sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.getSpecID() + " AND spec_type_id=" + specTypeID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        return nSpecies;
    }

    public int checkGroupOcc() throws SQLException {
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkGroupOcc()");
        }
        int nGroups = 0;
        Object sql = "SELECT count(grp_id) as ngroup FROM ";
        sql = (String)sql + this.sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + this.getSpecID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nGroups += rs.getInt("ngroup");
            }
        }
        return nGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDB(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        this.taxon.updateAudit((UserService)sbdb, Audit.getDatabaseServerDate(sbdb, stmt).toInstant());
        String sql = "INSERT INTO " + sbdb.DBTableName("species") + " ( gen_id, species, spec_id ";
        if (this.getQ1().hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.getQ2().hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.getQ3().hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.getSubSpecies().isEmpty()) {
            sql = sql + ",sub_spec";
        }
        if (this.getQ4().hasQuals()) {
            sql = sql + ",q4";
        }
        if (!this.getAlphaCode().isEmpty()) {
            sql = sql + ",alphacode";
        }
        if (!this.getAuthor().isEmpty()) {
            sql = sql + ",author";
        }
        if (!StringUtils.isBlank((CharSequence)this.getReference())) {
            sql = sql + ",reference";
        }
        if (!StringUtils.isBlank((CharSequence)this.getNotes())) {
            sql = sql + ",notes";
        }
        if (!StringUtils.isBlank((CharSequence)this.getURL())) {
            sql = sql + ",url";
        }
        sql = sql + "," + Audit.sqlFieldString();
        sql = sql + ") VALUES (" + this.getGenID() + "," + SB.DBString((String)this.getSpecies()) + "," + this.getSpecID();
        if (this.getQ1().hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.getQ1().toString(false));
        }
        if (this.getQ2().hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.getQ2().toString(false));
        }
        if (this.getQ3().hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.getQ3().toString(false));
        }
        if (!this.getSubSpecies().isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.getSubSpecies());
        }
        if (this.getQ4().hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.getQ4().toString(false));
        }
        if (!this.getAlphaCode().isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.getAlphaCode());
        }
        if (!this.getAuthor().isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.getAuthor());
        }
        if (!StringUtils.isBlank((CharSequence)this.getReference())) {
            sql = sql + "," + SB.DBString((String)this.getReference());
        }
        if (!StringUtils.isBlank((CharSequence)this.getNotes())) {
            sql = sql + "," + SB.DBString((String)this.getNotes());
        }
        if (!StringUtils.isBlank((CharSequence)this.getURL())) {
            sql = sql + "," + SB.DBString((String)this.getURL());
        }
        sql = sql + "," + Audit.sqlInsert(this.taxon.getAudit()) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    void clean(boolean convertSpeciesCase, Boolean spSpp) {
        this.taxon.clean(convertSpeciesCase, spSpp);
    }

    public static List<String> lookupSpecies(SBdb sbdb, String catMnem, String genus, String species) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT s.species, s.sub_spec FROM " + sbdb.DBTableName("GENUS") + " g," + sbdb.DBTableName("SPECIES") + " s WHERE ";
        if (!catMnem.isEmpty()) {
            sql = sql + "g.cat_mnem='" + catMnem + "' AND ";
        }
        if (!genus.isEmpty()) {
            sql = sql + " ucase(g.genus)='" + genus.toUpperCase() + "' AND ";
        }
        if (!species.isEmpty()) {
            sql = sql + " ucase(s.species) like '" + species.toUpperCase() + "%' AND";
        }
        sql = sql + " g.gen_id=s.gen_id ORDER by species";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Object item = rs.getString("species");
                String subSpec = rs.getString("sub_spec");
                if (subSpec != null && subSpec.length() > 0) {
                    item = (String)item + " subsp. " + subSpec;
                }
                list.add((String)item);
            }
        }
        return list;
    }

    public Discipline getDisc() {
        return this.taxon.getGenus().getCategory().getDiscipline();
    }

    static Taxon[] load(SBdb sbdb, Statement stmt, Genus g, String species, String subSpecies, Qualifier sq1, Qualifier sq2, Qualifier sq3, Qualifier sq4) throws SQLException {
        String sql = "SELECT spec_id, species, q1, q2, q3, sub_spec, q4, alphacode, author, reference, notes, url, " + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("SPECIES");
        sql = sql + " WHERE (species=" + SB.DBString((String)species) + " OR ucase(species)=" + SB.DBString((String)species.toUpperCase()) + ") AND gen_id=" + g.getGenID();
        if (sq1 != null) {
            sql = sq1.hasQuals() ? sql + " AND lcase(q1)='" + String.valueOf(sq1) + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (sq2 != null) {
            sql = sq2.hasQuals() ? sql + " AND lcase(q2)='" + String.valueOf(sq2) + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (sq3 != null) {
            sql = sq3.hasQuals() ? sql + " AND lcase(q3)='" + String.valueOf(sq3) + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subSpecies != null) {
            sql = !subSpecies.isEmpty() ? sql + " AND ucase(sub_spec)=" + SB.DBString((String)subSpecies.toUpperCase()) : sql + " AND (sub_spec IS NULL or sub_spec='')";
        }
        if (sq4 != null) {
            sql = sq4.hasQuals() ? sql + " AND lcase(q4)='" + String.valueOf(sq4) + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        LinkedList<Taxon> results = new LinkedList<Taxon>();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            Builder builder = new Builder();
            int specID = rs.getInt("spec_id");
            builder.genus(g.getGenusCopy());
            builder.species(rs.getString("species"));
            builder.qual(4, rs.getString("q1"));
            builder.qual(5, rs.getString("q2"));
            builder.qual(6, rs.getString("q3"));
            builder.subSpecies(rs.getString("sub_spec"));
            builder.qual(7, rs.getString("q4"));
            builder.alphaCode(rs.getString("alphacode"));
            builder.author(rs.getString("author"));
            builder.reference(rs.getString("reference"));
            builder.notes(rs.getString("notes"));
            builder.url(rs.getString("url"));
            results.add(builder.build(specID, sbdb));
        }
        if (!results.isEmpty()) {
            return results.toArray(new Taxon[results.size()]);
        }
        return null;
    }

    public String statusString() {
        return this.toString(true, false, true);
    }

    public String toString() {
        return this.toString(includeAuthorInString, includeAlphaInString, includeCategoryInString);
    }

    public AttributedString toAttributedString(boolean useAuthor, boolean includeCat) {
        return this.taxon.toAttributedString(useAuthor, includeCat);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean useAuthor, boolean includeCat) {
        return this.taxon.toAttributedString(useItalics, useAuthor, includeCat);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean useAuthor, boolean includeCat, String suffix) {
        return this.taxon.toAttributedString(useItalics, useAuthor, includeCat, suffix);
    }

    public String toString(boolean useAuthor, boolean useAlphaCode, boolean includeCat) {
        return this.taxon.toString(useAuthor, includeCat, useAlphaCode);
    }

    public String toString(boolean useAuthor) {
        return this.taxon.toString(useAuthor, true, false);
    }

    public String toString(boolean useAuthor, boolean includeCat) {
        return this.taxon.toString(useAuthor, includeCat, false);
    }

    public String toGenString(boolean abr, boolean includeCat) {
        return this.taxon.toAbbreviatedGenusString(abr, includeCat);
    }

    public int isUndifferentiated() {
        return this.taxon.isUndifferentiated() ? 1 : 0;
    }

    public String getAuthorString(boolean useAuthor) {
        return this.taxon.getAuthorString(useAuthor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != Taxon.class) {
            return false;
        }
        return ((Taxon)o).taxon == this.taxon && ((Taxon)o).sbdb == this.sbdb;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((Taxon)rhs);
    }

    public int compareTo(Taxon rhs) {
        return this.taxon.compareTo(rhs.taxon);
    }

    public int hashCode() {
        return this.getSpecID();
    }

    public void writeDEX(FileWriter out, String eol, boolean usePreferredTerm, int synScheme) throws IOException, SQLException, SBException {
        Taxon taxon;
        if (usePreferredTerm && (taxon = this.getPreferred(synScheme)) != null) {
            taxon.writeDEX(out, eol, usePreferredTerm, synScheme);
            return;
        }
        out.write("Species = " + this.toString(true, false, false) + eol);
        out.write("   ID : " + this.getSpecID() + eol);
        this.sbdb.getGenus(this.getGenID()).writeDEX(out, eol);
        if (this.getQ1().hasQuals()) {
            out.write("   Pre-Species qualifier : " + this.getQ1().toString() + eol);
        }
        out.write("   Species : " + this.getSpecies() + eol);
        if (this.getQ2().hasQuals()) {
            out.write("   Post-Species qualifier : " + this.getQ2().toString() + eol);
        }
        if (this.getQ3().hasQuals()) {
            out.write("   Pre-Subspecies qualifier : " + this.getQ3().toString() + eol);
        }
        if (!StringUtils.isBlank((CharSequence)this.getSubSpecies())) {
            out.write("   Subspecies : " + this.getSubSpecies() + eol);
        }
        if (this.getQ4().hasQuals()) {
            out.write("   Post-Subspecies qualifier : " + this.getQ4().toString() + eol);
        }
        if (!StringUtils.isBlank((CharSequence)this.getAuthor())) {
            out.write("   Author : " + this.getAuthor() + eol);
        }
        if (!StringUtils.isBlank((CharSequence)this.getAlphaCode())) {
            out.write("   Alphanumeric Code : " + this.getAlphaCode() + eol);
        }
        out.write(eol);
    }

    @Deprecated
    public void writeSbugs(FileWriter out) throws IOException {
        out.write(String.valueOf(this.getSpecID()) + "\t" + this.toString() + "\n");
        out.write(this.getCatMnem() + "\t" + this.taxon.getGenus().getQ1().toString(true) + "\t" + this.getGenusName() + "\t" + this.taxon.getGenus().getQ2().toString(true) + "\t" + this.taxon.getGenus().getQ3().toString(true) + "\t" + this.getSubGenus() + "\t" + this.taxon.getGenus().getQ4().toString(true) + "\t" + this.getQ1().toString() + "\t" + this.getSpecies() + "\t" + this.getQ2().toString() + "\t" + this.getQ3().toString() + "\t" + this.getSubSpecies() + "\t" + this.getQ4().toString() + "\t" + this.getAuthor() + "\t");
        out.write("\t\n");
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        assert (!this.sbdb.isConnected());
        XmlWriter.writeLines(out, XmlWriter.getIndentString(indent), XmlWriter.getTaxonLines(this.taxon));
        int typeImageSetID = this.sbdb.getTaxonImageService().getTypeImageSetID(this.getSpecID());
        if (typeImageSetID > 0) {
            if (exportImages == null) {
                exportImages = JOptionPane.showConfirmDialog(null, "Export taxon images for type specimens?", "Export Type Images", 0) == 0;
            }
            if (exportImages.booleanValue()) {
                Object ind = new String();
                while (((String)ind).length() < indent) {
                    ind = (String)ind + " ";
                }
                XmlWriter.writeImageSetXML(out, (String)ind, files, true, typeImageSetID, this.sbdb.getImageRecordService(), this.sbdb.getImageLoader());
            }
        }
    }

    public void storeSipmCode(int dictionary, Integer code) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException("Insufficient privilege to update taxon numeric code");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT COUNT(*) FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND sipm_code=" + code + " AND spec_id<>" + this.getSpecID();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int count = rs.getInt(1);
                if (count <= 0) continue;
                throw new SBException("SIPM code is not unique to dictionary");
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND spec_id=" + this.getSpecID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (code != null) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("sipmcode") + "(spec_ID,ccode,sipm_code) VALUES (" + this.getSpecID() + "," + dictionary + "," + code + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        if (this.sipmCode != null) {
            this.sipmCode.remove(dictionary);
        } else {
            this.sipmCode = new HashMap();
        }
        if (code != null) {
            this.sipmCode.put(dictionary, code);
        }
    }

    public Taxon getPreferred(int synSch) throws SQLException, SBException {
        if (this.getSpecID() > 0) {
            return this.sbdb.getPreferredTerm(synSch, this.getSpecID());
        }
        return null;
    }

    public String getPrefString(int synSch) throws SQLException, SBException {
        if (this.getSpecID() > 0) {
            Taxon t = this.sbdb.getPreferredTerm(synSch, this.getSpecID());
            if (t != null) {
                return t.toString();
            }
            List<Taxon> syns = this.sbdb.getSynonymy(synSch, this.getSpecID());
            String s = null;
            for (Taxon syn : syns) {
                s = (String)(s == null ? "(" : (String)s + ",") + syn.toString();
            }
            if (s != null) {
                s = s + ")";
            }
            return s;
        }
        return null;
    }

    public boolean hasEvents() throws SQLException {
        String sql = "SELECT count(spec_id) AS total FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + this.getSpecID();
        int nRows = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nRows = rs.getInt("total");
            }
        }
        return nRows > 0;
    }

    public void getStats(int[] stats) throws SQLException {
        String sql = "SELECT situation,ident_type FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.getSpecID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            for (int i = 0; i < stats.length; ++i) {
                stats[i] = 0;
            }
            while (rs.next()) {
                Situation situation = Situation.parse((String)rs.getString("situation"));
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                stats[0] = stats[0] + 1;
                if (situation == Situation.INSITU) {
                    stats[1] = stats[1] + 1;
                }
                if (situation == Situation.RW) {
                    stats[2] = stats[2] + 1;
                }
                if (identType == '?') {
                    stats[4] = stats[4] + 1;
                } else {
                    stats[3] = stats[3] + 1;
                }
                if (situation == Situation.TR) {
                    stats[5] = stats[5] + 1;
                }
                if (situation != Situation.CV) continue;
                stats[6] = stats[6] + 1;
            }
        }
    }

    public int updateOcc(String field, char value) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET " + field + "='" + value + "' WHERE spec_id=" + this.getSpecID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int nUpdated;
            int n = nUpdated = stmt.executeUpdate(this.sbdb.modQuery(sql));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteSpecies(SBdb sbdb, Collection<Integer> specIDs, boolean delFss, ProgressMonitor monitor) throws SQLException {
        int n;
        LinkedList<PreparedStatement> pStmt = new LinkedList<PreparedStatement>();
        String sql = "DELETE FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("TXIMAGE") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE pref=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("TXDEPTH") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=?";
        pStmt.add(sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql)));
        int i = 0;
        Iterator<Integer> it = specIDs.iterator();
        try {
            while (it.hasNext()) {
                int specID = it.next();
                Logger.getLogger(Taxon.class.getName()).log(Level.INFO, "Deleting species: " + specID);
                int n2 = n = delFss ? 0 : 1;
                while (n < pStmt.size()) {
                    PreparedStatement p = (PreparedStatement)pStmt.get(n);
                    p.setInt(1, specID);
                    p.execute();
                    ++n;
                }
                if (monitor == null) continue;
                if (monitor.isInterrupted()) {
                    return;
                }
                monitor.setValue(i++);
            }
            return;
        }
        finally {
            n = 0;
            while (true) {
                if (n >= pStmt.size()) {
                }
                ((PreparedStatement)pStmt.get(n)).close();
                ++n;
            }
        }
    }

    public static List<Taxon> search(SBdb SB2, Discipline disc, String catMnem, boolean includeSubCategories, String genus, String subGenus, String species, String subSpecies, String alphaCode, String gq1, String gq2, String gq3, String gq4, String sq1, String sq2, String sq3, String sq4) throws SQLException, SBException {
        LinkedList<Taxon> resultList;
        Object sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s ";
        if (disc != null) {
            sql = (String)sql + ", " + SB2.DBTableName("category") + " c ";
        }
        sql = (String)sql + "WHERE s.gen_id=g.gen_id AND ";
        sql = (String)sql + Genus.getSearchString(SB2, disc, catMnem, includeSubCategories, genus.trim(), subGenus.trim());
        String text = species.trim().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
        if (text.length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "(ucase(s.species) like '" + text + "' OR ucase(s.species) like '(" + text + "')" : (String)sql + "ucase(s.species)='" + text + "'";
        }
        if ((text = subSpecies.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "(ucase(s.sub_spec) like '" + text + "' OR ucase(s.sub_spec) like '(" + text + "')" : (String)sql + "ucase(s.sub_spec)='" + text + "'";
        }
        if ((text = alphaCode.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(s.alphaCode) like '" + text + "'" : (String)sql + "ucase(s.alphaCode)='" + text + "'";
        }
        if (((String)(sql = ((String)sql).trim())).endsWith("AND")) {
            sql = ((String)sql).substring(0, ((String)sql).length() - 4);
        }
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery((String)sql));
            resultList = new LinkedList<Taxon>();
            while (rs.next()) {
                Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
                boolean toAdd = true;
                if (gq1 != null && !taxon.getQualifier(0).toString().equalsIgnoreCase(gq1)) {
                    toAdd = false;
                }
                if (gq2 != null && !taxon.getQualifier(1).toString().equalsIgnoreCase(gq2)) {
                    toAdd = false;
                }
                if (gq3 != null && !taxon.getQualifier(2).toString().equalsIgnoreCase(gq3)) {
                    toAdd = false;
                }
                if (gq4 != null && !taxon.getQualifier(3).toString().equalsIgnoreCase(gq4)) {
                    toAdd = false;
                }
                if (sq1 != null && !taxon.getQualifier(4).toString().equalsIgnoreCase(sq1)) {
                    toAdd = false;
                }
                if (sq2 != null && !taxon.getQualifier(5).toString().equalsIgnoreCase(sq2)) {
                    toAdd = false;
                }
                if (sq3 != null && !taxon.getQualifier(6).toString().equalsIgnoreCase(sq3)) {
                    toAdd = false;
                }
                if (sq4 != null && !taxon.getQualifier(7).toString().equalsIgnoreCase(sq4)) {
                    toAdd = false;
                }
                if (!toAdd) continue;
                resultList.add(taxon);
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        }
        return resultList;
    }

    public static List<Taxon> searchSoundex(SBdb SB2, String genus, String subGenus, String species, String subSpecies) throws SQLException, SBException {
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s WHERE s.gen_id=g.gen_id ";
        String text = genus.toUpperCase();
        if (text.length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(g.genus))=soundex('" + text + "')";
        }
        if ((text = subGenus.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(g.sub_genus))=soundex('" + text + "')";
        }
        if ((text = species.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(s.species))=soundex('" + text + "')";
        }
        if ((text = subSpecies.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(s.sub_spec))=soundex('" + text + "')";
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
            resultList.add(taxon);
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    public static List<Integer> getUnusedSpecies(SBdb sbdb) throws SQLException {
        LinkedList<Integer> taxaToDie = new LinkedList<Integer>();
        String sql = "SELECT spec_id FROM " + sbdb.DBTableName("species");
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            int specID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                taxaToDie.add(rs.getInt("spec_id"));
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("taxonocc");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove((Object)specID)) continue;
                System.out.println("TAXONOCC SpecID with no corresponding species record: " + specID);
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("eventdic");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove((Object)specID)) continue;
            }
        }
        return taxaToDie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonWellOccTotal> search(SBdb db, Project project, Double upper, Double lower, int abund, String addSql) throws SQLException {
        Object sql = "SELECT f.well_id, count(f.spec_id) as Total FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC");
        sql = (String)sql + " f, ";
        if (project != null && project.getID() > 0) {
            sql = (String)sql + db.DBTableName("WELLIST_MBR");
            sql = (String)sql + " w, ";
            sql = (String)sql + db.DBTableName("WELLIST");
            sql = (String)sql + " wl, ";
        }
        sql = (String)sql + this.sbdb.DBTableName("SAMPLES");
        sql = (String)sql + " s WHERE f.well_id=s.well_id AND f.samp_id=s.samp_id AND f.spec_id=" + this.getSpecID();
        if (abund > 0) {
            sql = (String)sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = this.sbdb.getDBType() == DBType.ACCESS ? (String)sql + " AND IIF(IsNull(s.top_depth),s.base_depth,s.top_depth)>=" + upper : (String)sql + " AND NVL(s.top_depth,s.base_depth)>=" + upper;
        }
        if (lower != null) {
            sql = this.sbdb.getDBType() == DBType.ACCESS ? (String)sql + " AND IIF(IsNull(s.base_depth),s.top_depth,s.base_depth)<=" + lower : (String)sql + " AND NVL(s.base_depth,s.top_depth)<=" + lower;
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + " AND f.well_id=w.well_id AND w.wellist_id=wl.wellist_id AND wl.proj_id=" + project.getID();
        }
        if (addSql != null) {
            sql = (String)sql + addSql;
        }
        sql = (String)sql + " Group by f.well_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            LinkedList<TaxonWellOccTotal> resultList = new LinkedList<TaxonWellOccTotal>();
            while (rs.next()) {
                resultList.add(new TaxonWellOccTotal(this, rs.getInt("well_id"), rs.getInt("total")));
            }
            LinkedList<TaxonWellOccTotal> linkedList = resultList;
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Taxon> search(SBdb db, int upperCode, int lowerCode, int dictID) throws SQLException {
        if (upperCode < lowerCode) {
            int temp = upperCode;
            upperCode = lowerCode;
            lowerCode = temp;
        }
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT DISTINCT spec_id FROM " + db.DBTableName("SIPMCODE") + " WHERE sipm_code";
        sql = upperCode < 0 ? sql + "=" + lowerCode : (lowerCode < 0 ? sql + "=" + upperCode : sql + ">=" + lowerCode + " AND sipm_code<=" + upperCode);
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                resultList.add(db.getTaxon(rs.getInt("spec_id")));
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
            LinkedList<Taxon> linkedList = resultList;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    public static List<Taxon> search(SBdb SB2, Set<Discipline> discs, TxGroup group, Project project, IGDUnitBase unit, int abund, String addSql) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        String sql = "SELECT i.well_id,min(s1." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS upper,max(s2." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS lower ";
        sql = sql + "FROM " + (unit instanceof IGDUnit ? SB2.DBTableName("IGD") : SB2.DBTableName("IGD_LSTRAT")) + " i, " + SB2.DBTableName("SAMPLES") + " s1, " + SB2.DBTableName("SAMPLES") + " s2";
        if (project != null && project.getID() > 0) {
            sql = sql + ",";
            sql = sql + SB2.DBTableName("WELLIST_MBR");
            sql = sql + " w ";
            sql = sql + ",";
            sql = sql + SB2.DBTableName("WELLIST");
            sql = sql + " wl ";
        }
        sql = sql + " WHERE (i.upp_zone=" + unit.getUnitID() + " OR i.low_zone=" + unit.getUnitID() + ") AND s1.well_id=i.well_id AND s2.well_id=i.well_id AND s1.samp_id=i.top_id AND s2.samp_id=i.base_id ";
        if (project != null && project.getID() > 0) {
            sql = sql + " AND i.well_id=w.well_id AND w.wellist_id=wl.wellist_id AND wl.proj_id=" + project.getID();
        }
        sql = sql + " GROUP BY i.well_id";
        System.out.println(sql);
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            BigDecimal upper = rs.getBigDecimal("upper");
            BigDecimal lower = rs.getBigDecimal("lower");
            if (upper == null || lower == null) continue;
            System.out.println("Executing query for wellID=" + wellID + " upper=" + String.valueOf(upper) + ", lower=" + String.valueOf(lower));
            List<Taxon> wellResultList = Taxon.search(SB2, discs, group, null, wellID, upper.doubleValue(), lower.doubleValue(), abund, addSql);
            for (Taxon taxon : wellResultList) {
                if (resultList.contains(taxon)) continue;
                resultList.add(taxon);
            }
        }
        stmt.close();
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        return resultList;
    }

    public static List<Taxon> search(SBdb SB2, Set<Discipline> discs, TxGroup group, Project project, int wellID, Double upper, Double lower, int abund, String addSql) throws SQLException, SBException {
        LinkedList<Taxon> resultList;
        Object sql = "SELECT DISTINCT f.spec_id FROM ";
        sql = (String)sql + SB2.DBTableName("TAXONOCC");
        sql = (String)sql + " f, ";
        sql = (String)sql + SB2.DBTableName("ANALY_HDR");
        sql = (String)sql + " a, ";
        if (group != null) {
            sql = (String)sql + SB2.DBTableName("GROUPMBR");
            sql = (String)sql + " g, ";
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + SB2.DBTableName("WELLIST_MBR");
            sql = (String)sql + " w, ";
            sql = (String)sql + SB2.DBTableName("WELLIST");
            sql = (String)sql + " wl, ";
        }
        sql = (String)sql + SB2.DBTableName("SAMPLES");
        sql = (String)sql + " s WHERE f.analy_id=a.analy_id AND a.well_id=f.well_id AND f.samp_id=s.samp_id AND f.well_id=s.well_id";
        sql = (String)sql + " AND (" + StringUtils.join(discs.stream().map(disc -> "a.disc_id='" + disc.getChar() + "'").toList(), (String)" OR ") + ")";
        if (abund > 0) {
            sql = (String)sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = (String)sql + " AND (s.top_depth>" + upper + " OR s.base_depth > " + upper + ")";
        }
        if (lower != null) {
            sql = (String)sql + " AND (s.base_depth<" + lower + " OR s.top_depth < " + lower + ")";
        }
        if (group != null) {
            sql = (String)sql + " AND f.spec_id=g.spec_id AND g.grp_id=" + group.getID();
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + " AND f.well_id=w.well_id AND w.wellist_id=wl.wellist_id AND wl.proj_id=" + project.getID();
        }
        if (wellID > 0) {
            sql = (String)sql + " AND f.well_id=" + wellID;
        }
        if (addSql != null) {
            sql = (String)sql + addSql;
        }
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery((String)sql));
            resultList = new LinkedList<Taxon>();
            while (rs.next()) {
                resultList.add(SB2.getTaxon(rs.getInt("spec_id")));
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        }
        return resultList;
    }

    public static List<Taxon> search(SBdb sbdb, Date dateFrom, Date dateTo, Integer modifier) throws SQLException, SBException {
        LinkedList<Taxon> resultList;
        if (dateFrom == null && dateTo == null) {
            throw new SBException("No dates to search on");
        }
        if (dateFrom == null && dateTo != null) {
            throw new SBException("Date from null in between date search");
        }
        String sql = "SELECT distinct spec_id from " + sbdb.DBTableName("SPECIES");
        sql = dateTo != null ? sql + " WHERE modified BETWEEN " + sbdb.DBDate(dateFrom) + " AND " + sbdb.DBDate(dateTo) : sql + " WHERE modified > " + sbdb.DBDate(dateFrom);
        if (modifier != null) {
            sql = sql + " AND modifier=" + modifier;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            resultList = new LinkedList<Taxon>();
            while (rs.next()) {
                resultList.add(sbdb.getTaxon(rs.getInt("spec_id")));
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        }
        return resultList;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    @Override
    public void onGenusDetailsUpdated(Genus genus) {
        this.taxon.setGenus(genus.getGenusCopy());
        this.updatePublisher.setTaxonDetailsChanged();
        this.updatePublisher.notifyListeners();
    }

    @Override
    public void onGenusSpeciesListUpdated(Genus genus, Collection<Integer> speciesAdded, Collection<Integer> speciesRemoved) {
    }

    @Override
    public void onGenusDelete(Genus genus) {
    }

    public static void sort(List<Taxon> list, SortOrder order) {
        switch (order.ordinal()) {
            case 0: {
                Collections.sort(list, new TaxonCompareGenus(new TaxonCompareSpecies()));
                break;
            }
            case 1: {
                Collections.sort(list, new TaxonCompareSpecies());
                break;
            }
            case 2: {
                Collections.sort(list, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            case 3: {
                Collections.sort(list, new TaxonCompareAlphaCode(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
        }
    }

    public static void sort(List<Taxon> list, SortOrder order, int sipmDictID) {
        switch (order.ordinal()) {
            case 4: {
                Collections.sort(list, new TaxonCompareSIPMCode(sipmDictID, new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            default: {
                Taxon.sort(list, order);
            }
        }
    }

    public List<TxGroup> getGroups() throws SQLException, SBException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Taxon.getGroups(). Not connected to database.");
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("groupmbr") + " WHERE spec_id=" + this.getSpecID();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                groups.add(this.sbdb.getTxGroup(rs.getInt("grp_id")));
            }
            sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("groupmbr_genus") + " WHERE gen_id=" + this.getGenID();
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                TxGroup group = this.sbdb.getTxGroup(rs.getInt("grp_id"));
                if (groups.contains(group)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    private boolean hasUnreferencedImages() throws SQLException {
        String imageFolder = this.sbdb.getImageFolder();
        if (imageFolder == null || imageFolder.isEmpty()) {
            return false;
        }
        File dir = new File(imageFolder);
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getPath().toLowerCase().startsWith((imageFolder + "\\" + this.subsFileNameChars(this.toString(false, false))).toLowerCase() + "_")) continue;
            return true;
        }
        return false;
    }

    private String subsFileNameChars(String name) {
        char[] ILLEGAL_CHARACTERS = new char[]{'/', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
        Object newName = "";
        for (int n : name.toCharArray()) {
            for (char ill : ILLEGAL_CHARACTERS) {
                if (ill != n) continue;
                n = ill == '\"' ? 39 : 45;
                break;
            }
            newName = (String)newName + (char)n;
        }
        return newName;
    }

    public int nSlideStoreEntries() throws SQLException {
        if (this.getSpecID() < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nEntries = 0;
        Object sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = (String)sql + this.sbdb.DBTableName("SPECIMEN") + " WHERE spec_id=" + this.getSpecID() + " AND slidecell_id >  0";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nEntries += rs.getInt("nspecies");
            }
        }
        return nEntries;
    }

    public boolean equalsBuilder(Builder builder) {
        if (!this.equalsBuilder(builder, true)) {
            return false;
        }
        if (!this.getAuthor().equals(builder.taxon.getAuthor())) {
            return false;
        }
        return this.getAlphaCode().equals(builder.taxon.getAuthor());
    }

    public boolean equalsBuilder(Builder builder, boolean uniqueFieldsOnly) {
        if (!builder.taxon.equivalent(this.taxon)) {
            return false;
        }
        if (!this.getAlphaCode().equals(builder.taxon.getAlphaCode())) {
            return false;
        }
        if (!this.getAuthor().equals(builder.taxon.getAuthor())) {
            return false;
        }
        if (!Objects.equals(this.getReference(), builder.taxon.getReference())) {
            return false;
        }
        if (!Objects.equals(this.getNotes(), builder.taxon.getNotes())) {
            return false;
        }
        return Objects.equals(this.getURL(), builder.taxon.getUrl());
    }

    private Taxon(Builder builder, int specID, SBdb sbdb) {
        this.sbdb = sbdb;
        this.taxon = new com.stratadata.model3.taxon.Taxon(specID);
        com.stratadata.model3.taxon.Taxon.copyFields((com.stratadata.model3.taxon.Taxon)this.taxon, (com.stratadata.model3.taxon.Taxon)builder.taxon);
        try {
            Genus modelGenus = sbdb.getGenus(builder.taxon.getGenus().getGenID());
            this.taxon.setGenus(modelGenus.getGenusCopy());
            modelGenus.registerListener(this);
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withoutRollback(ex);
        }
    }

    public static class Builder {
        private com.stratadata.model3.taxon.Taxon taxon;

        public Builder() {
            this.taxon = new com.stratadata.model3.taxon.Taxon();
        }

        Builder(com.stratadata.model3.taxon.Taxon taxon) {
            this.taxon = taxon;
        }

        static Builder copyOf(Taxon taxon) {
            Builder builder = new Builder();
            builder.taxon = com.stratadata.model3.taxon.Taxon.copy((com.stratadata.model3.taxon.Taxon)taxon.taxon);
            return builder;
        }

        private void validateFields() {
            if (this.taxon.getGenus() == null || this.taxon.getGenus().getGenID() == 0) {
                throw new IllegalStateException("Attempt to build Taxon with no Genus: " + this.taxon.getSpecies());
            }
            if (this.taxon.getSpecies().isEmpty()) {
                throw new IllegalStateException("Attempt to build Taxon with no name: " + String.valueOf(this.taxon.getGenus()));
            }
        }

        Taxon build(int specID, SBdb sbdb) {
            if (specID < 1) {
                throw new IllegalArgumentException("Attempt to build Taxon with illegal specID: " + specID);
            }
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build Taxon with null data model");
            }
            this.validateFields();
            try {
                if (sbdb.getGenus(this.taxon.getGenus().getGenID()) == null) {
                    throw new IllegalStateException("New taxon genus does not exist");
                }
            }
            catch (SQLException ex) {
                throw SuppressedSQLException.withoutRollback(ex);
            }
            return new Taxon(this, specID, sbdb);
        }

        Taxon store(SBdb sbdb) throws SQLException, SBPermissionException {
            if (!SBRestrictable.canWrite(sbdb)) {
                throw new SBPermissionException("No permission to create new taxon");
            }
            int specID = sbdb.nextControl("SPECIES", "spec_id");
            Taxon taxon = this.build(specID, sbdb);
            taxon.storeDB(sbdb);
            return taxon;
        }

        public Builder genus(com.stratadata.model3.taxon.Genus g) {
            this.taxon.setGenus(g);
            return this;
        }

        public Builder qual(int pos, String q) {
            this.taxon.setQualifier(pos, new Qualifier(pos, q));
            return this;
        }

        public Builder qual(int pos, Qualifier q) {
            if (pos < 4 || pos > 7) {
                return this;
            }
            if (q == null) {
                this.taxon.setQualifier(pos, new Qualifier(pos));
            } else {
                this.taxon.setQualifier(pos, q);
            }
            return this;
        }

        public Builder qual(int pos, TaxonQual q) {
            this.taxon.getQualifier(pos).addQual(q);
            return this;
        }

        public Builder speciesAdd(String species) {
            if (species != null) {
                this.taxon.setSpecies(this.taxon.getSpecies() + " " + species);
            }
            return this;
        }

        public Builder species(String species) {
            this.taxon.setSpecies(species);
            return this;
        }

        public Builder subSpecies(String subSpecies) {
            this.taxon.setSubSpecies(subSpecies);
            return this;
        }

        public Builder author(String author) {
            this.taxon.setAuthor(StringUtils.trimToEmpty((String)author));
            return this;
        }

        public Builder alphaCode(String alphaCode) {
            this.taxon.setAlphaCode(StringUtils.trimToEmpty((String)alphaCode));
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            return this.taxon.hasQualifier(qual);
        }

        Builder notes(String notes) {
            this.taxon.setNotes(notes);
            return this;
        }

        Builder reference(String reference) {
            this.taxon.setReference(reference);
            return this;
        }

        Builder url(String url) {
            this.taxon.setUrl(url);
            return this;
        }

        Qualifier getQualifier(int i) {
            return this.taxon.getQualifier(i + 4);
        }

        public String getName() {
            return this.taxon.getSpecies();
        }

        public String getSubSpecies() {
            return this.taxon.getSubSpecies();
        }

        public String getAlphaCode() {
            return this.taxon.getAlphaCode();
        }

        String getAuthor() {
            return this.taxon.getAuthor();
        }

        com.stratadata.model3.taxon.Genus getGenus() {
            return this.taxon.getGenus();
        }
    }

    public class TaxonWellOccTotal {
        int wellID;
        int nOcc;

        TaxonWellOccTotal(Taxon this$0, int w, int n) {
            Objects.requireNonNull(this$0);
            this.wellID = w;
            this.nOcc = n;
        }

        public int getWellID() {
            return this.wellID;
        }

        public int getNOcc() {
            return this.nOcc;
        }
    }

    public static enum SortOrder {
        SORT_GENUS,
        SORT_SPECIES,
        SORT_CATEGORY,
        SORT_ALPHACODE,
        SORT_SIPMCODE;

    }

    public static enum OccType {
        INSITU("In-situ"),
        REWORKED("Reworked"),
        CAVED("Caved"),
        QUESTIONABLE("Questionable");

        String name;

        private OccType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static OccType getType(String type) {
            for (OccType val : OccType.values()) {
                if (!val.toString().equalsIgnoreCase(type)) continue;
                return val;
            }
            return null;
        }
    }
}

