/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.sample.SampleType;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.ImportFileReader;
import model3.ImportFileReaderType;
import model3.SBdb;
import model3.Sample;
import model3.SampleInsertException;
import model3.Well;
import model3.WellHeader;
import model3.WellInterp;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellChronoPickXLS
implements ImportFileReader {
    static final int COL_WELL_CODE = 0;
    static final int COL_WELL_NAME = 1;
    static final int COL_PICK = 2;
    static final int COL_MD = 3;
    static final int COL_UNITS = 4;
    static final int COL_KIND = 5;
    static final ImportFileReader.ImportFileReaderColumn[] COLUMNS = new ImportFileReader.ImportFileReaderColumn[]{new ImportFileReader.ImportFileReaderColumn(0, false, "UWBI"), new ImportFileReader.ImportFileReaderColumn(1, true, "Wellbore name"), new ImportFileReader.ImportFileReaderColumn(2, true, "Pick Name"), new ImportFileReader.ImportFileReaderColumn(3, true, "Pick Depth"), new ImportFileReader.ImportFileReaderColumn(4, true, "Depth Unit"), new ImportFileReader.ImportFileReaderColumn(5, true, "Pick Kind")};
    SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    final SBdb ws;

    @Override
    public ImportFileReaderType getType() {
        return ImportFileReaderType.PETREL_CHRONO;
    }

    @Override
    public ImportFileReader.ImportFileReaderColumn[] getColumns() {
        return COLUMNS;
    }

    public WellChronoPickXLS() {
        this.ws = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellChronoPickXLS(SBdb ws, File file, Set dataTypes, IGDScheme dbScheme) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        this.ws = ws;
        IGDScheme scheme = IGDScheme.copyToWorkspace(ws, dbScheme);
        if (scheme == null) {
            String unassignedSchemeName = IGDInterval.getIGDName(3) + " (undefined)";
            scheme = ws.addIGDScheme(3, unassignedSchemeName, "");
        } else {
            ws.addIGDScheme(scheme);
        }
        GridReader in = null;
        WsWell well = null;
        boolean firstRow = true;
        WellInterp wellInterp = null;
        LinkedList<IGDIntervalZone.Builder> topBuilders = new LinkedList<IGDIntervalZone.Builder>();
        LinkedList<IGDIntervalZone.Builder> baseBuilders = new LinkedList<IGDIntervalZone.Builder>();
        dataTypes.add(10);
        double depth = 0.0;
        double totalDepth = 0.0;
        try {
            in = GridReader.getGridReader((String)file.getPath(), null);
            while (in.nextRow()) {
                IGDIntervalZone.Builder builder;
                String cell;
                int column;
                if (firstRow) {
                    firstRow = false;
                    column = 0;
                    while ((cell = in.getNextCell()) != null) {
                        this.setArrayIndex(cell, column);
                        ++column;
                    }
                    String strg = this.checkColumns();
                    if (strg == null) continue;
                    throw new SBException("Warning: columns incorrect for this reader: " + strg);
                }
                String wellCode = null;
                String wellName = null;
                String pick = null;
                String unitsString = null;
                String depthString = null;
                column = 0;
                boolean isChrono = false;
                while ((cell = in.getNextCell()) != null) {
                    ImportFileReader.ImportFileReaderColumn columnType;
                    if ((columnType = this.getColumn(column++)) == null) continue;
                    switch (columnType.colNumber) {
                        case 0: {
                            wellCode = cell;
                            break;
                        }
                        case 1: {
                            wellName = cell;
                            break;
                        }
                        case 2: {
                            pick = cell;
                            break;
                        }
                        case 3: {
                            depthString = cell;
                            break;
                        }
                        case 4: {
                            unitsString = cell;
                        }
                        case 5: {
                            if (!cell.equalsIgnoreCase("CHRONOSTRATIGRAPHY")) break;
                            isChrono = true;
                            break;
                        }
                    }
                }
                if (!isChrono) continue;
                char units = 'M';
                if (unitsString != null) {
                    units = unitsString.toUpperCase().charAt(0);
                }
                if (depthString == null) continue;
                depth = DepthUtils.convToM((double)Double.parseDouble(depthString), (char)units);
                if (wellName == null) {
                    throw new SBException("Well name is null");
                }
                if (well == null || !wellName.equalsIgnoreCase(well.getWellName())) {
                    if (well != null) {
                        this.addIntervals(scheme, well, wellInterp, topBuilders, baseBuilders, totalDepth);
                    }
                    well = ws.addWellToWorkspace(0, null);
                    WellHeader wh = well.getHeader();
                    wh.setWellUnits(units);
                    wh.setDatum(WellDatum.ROTARY_TABLE.getDbInt());
                    wh.setWellName(wellName);
                    wh.setWellCode(wellCode);
                    well.loadInterps();
                    wellInterp = well.getInterp(0);
                    totalDepth = 0.0;
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)pick, (CharSequence[])new CharSequence[]{"Total Depth"}) || StringUtils.equalsAnyIgnoreCase((CharSequence)pick, (CharSequence[])new CharSequence[]{"TD"})) {
                    totalDepth = depth;
                    continue;
                }
                if (well == null) continue;
                if (pick.toLowerCase().endsWith(" base")) {
                    builder = this.addBuilder(well, depth, scheme, pick);
                    if (builder == null) continue;
                    baseBuilders.add(builder);
                    continue;
                }
                builder = this.addBuilder(well, depth, scheme, pick);
                if (builder == null) continue;
                topBuilders.add(builder);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (well != null) {
            this.addIntervals(scheme, well, wellInterp, topBuilders, baseBuilders, totalDepth);
            Iterator<Well> it = ws.getWellIterator();
            while (it.hasNext()) {
                well = (WsWell)it.next();
                well.updateStatus();
            }
        }
    }

    private IGDIntervalZone.Builder addBuilder(Well well, double topDepth, IGDScheme scheme, String pick) throws SBPermissionException, SampleInsertException, SQLException {
        int unitHier;
        Sample topSample = well.getSample(topDepth, "LOG", true);
        if (topSample == null) {
            topSample = well.addSample(topDepth, SampleType.LOG, null);
        }
        pick = pick.trim();
        IGDUnitBase unit = scheme.findUnitBase(pick = pick.replace("Top", "").replace("TOP", "").replace("Base", "").replace("BASE", "").replace("  ", "").trim());
        if (unit == null) {
            System.out.println("Warning: for well: " + String.valueOf(well) + "\tCould not find unit for: " + pick + "\tAdding as informal.");
            unitHier = IGDIntervalZone.getNHier(scheme.getIGDType(), true);
        } else {
            unitHier = unit.getHier();
        }
        IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, 3, topSample, topSample, unitHier, scheme.getSchID()).uppInf(pick).topBnd(3).baseBnd(3);
        if (unit != null) {
            builder.uppZone(unit.getUnitID());
        }
        return builder;
    }

    private void addIntervals(IGDScheme scheme, Well well, WellInterp wellInterp, List<IGDIntervalZone.Builder> tops, List<IGDIntervalZone.Builder> bases, double totalDepth) throws SBPermissionException, SBException, SQLException {
        int index;
        Sample baseSampleTD = null;
        if (totalDepth < (double)0.0029f) {
            baseSampleTD = bases.size() > 0 ? bases.getLast().getTopSample() : tops.getLast().getTopSample();
        } else {
            baseSampleTD = well.getSample(totalDepth, "LOG", true);
            if (baseSampleTD == null) {
                baseSampleTD = well.addSample(totalDepth, SampleType.LOG, null);
            }
        }
        boolean removedTop = true;
        block4: while (removedTop) {
            removedTop = false;
            block5: for (index = 0; index < tops.size(); ++index) {
                IGDIntervalZone.Builder builder = tops.get(index);
                for (int index2 = 0; index2 < bases.size(); ++index2) {
                    IGDIntervalZone.Builder builder2 = bases.get(index2);
                    if (!builder.getName().equalsIgnoreCase(builder2.getName())) continue;
                    if (builder.getTopSample().equals(builder2.getTopSample())) {
                        bases.remove(index2);
                        tops.remove(index);
                        removedTop = true;
                        continue block4;
                    }
                    builder.baseSample(builder2.getTopSample());
                    bases.remove(index2);
                    continue block5;
                }
            }
        }
        if (bases.size() > 0) {
            System.out.println("\n ** Warning: bases left:" + bases.size());
            for (index = 0; index < bases.size(); ++index) {
                System.out.println(bases.get(index).getName());
            }
        }
        boolean lastHier = false;
        for (int index2 = 0; index2 < tops.size(); ++index2) {
            IGDIntervalZone.Builder builder = tops.get(index2);
            IGDIntervalZone.Builder nextBuilderAtLevel = null;
            for (int index22 = index2 + 1; index22 < tops.size(); ++index22) {
                if (tops.get(index22).getHier() > builder.getHier()) continue;
                nextBuilderAtLevel = tops.get(index22);
                break;
            }
            if (nextBuilderAtLevel == null) {
                builder.baseSample(baseSampleTD);
                continue;
            }
            builder.baseSample(nextBuilderAtLevel.getTopSample());
        }
        for (IGDIntervalZone.Builder builder : tops) {
            try {
                wellInterp.addZone(builder, well);
            }
            catch (InvalidFieldException ex) {
                boolean inserted = false;
                while (!inserted && builder.getHier() + 1 <= IGDIntervalZone.getNHier(scheme.getIGDType(), true)) {
                    IGDIntervalZone.Builder newBuilder = new IGDIntervalZone.Builder(builder.sbdb, builder.igdType, builder.getTopSample(), builder.getBaseSample(), builder.getHier() + 1, builder.getSchID());
                    newBuilder.uppZone(builder.getUppZone()).uppInf(builder.getName());
                    builder = newBuilder;
                    inserted = true;
                    try {
                        wellInterp.addZone(builder, well);
                    }
                    catch (InvalidFieldException ex2) {
                        inserted = false;
                    }
                }
                if (inserted) continue;
                System.out.println("Can't insert: " + builder.getIntervalName() + " into well: " + well.toString() + "\tReason: " + ex.getMessage());
            }
        }
        tops.clear();
        bases.clear();
    }
}

