/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.InterpHdr;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellEPaleoReader {
    Set dataTypes;
    public HashMap<String, InterpHdr> interpMap = new HashMap();
    EnvScheme envScheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellEPaleoReader(SBdb ws, File file, char units, Set dataTypes, EnvScheme dbEnvScheme) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        GridReader in = null;
        Well well = null;
        boolean firstRow = true;
        String lastUWI = "";
        int nSource = 0;
        try {
            this.envScheme = ws.getEnvScheme(dbEnvScheme.getName());
            if (this.envScheme == null) {
                this.envScheme = EnvScheme.createCopy(dbEnvScheme, ws);
                ws.addEnvScheme(this.envScheme);
            }
            in = GridReader.getGridReader((String)file.getPath(), null);
            while (in.nextRow()) {
                int termIndex;
                SBEvent event;
                InterpHdr interp;
                String cell;
                if (firstRow) {
                    firstRow = false;
                    continue;
                }
                int column = 0;
                String UWI = "";
                double lat_dec = 0.0;
                double long_dec = 0.0;
                String operator = "";
                String wellNum = "";
                String block = "";
                String source = "";
                double depth = 0.0;
                String eventName = "";
                String eventAbr = "";
                String eventQual = "";
                String env = "";
                String eventComment = "";
                while ((cell = in.getNextCell()) != null) {
                    String colchar = this.toAlphabetic(column);
                    ++column;
                    if (cell.isEmpty()) continue;
                    cell = cell.trim();
                    switch (colchar) {
                        case "A": {
                            UWI = cell;
                            break;
                        }
                        case "B": {
                            lat_dec = Double.parseDouble(cell);
                            break;
                        }
                        case "C": {
                            long_dec = Double.parseDouble(cell);
                            break;
                        }
                        case "D": {
                            operator = cell;
                            break;
                        }
                        case "E": {
                            wellNum = cell;
                            break;
                        }
                        case "F": {
                            block = cell;
                            break;
                        }
                        case "G": {
                            source = cell;
                            break;
                        }
                        case "I": {
                            depth = Double.parseDouble(cell);
                            break;
                        }
                        case "K": {
                            eventName = cell;
                            break;
                        }
                        case "L": {
                            eventAbr = cell;
                            break;
                        }
                        case "M": {
                            eventQual = cell;
                            break;
                        }
                        case "P": {
                            env = cell;
                            break;
                        }
                        case "T": {
                            eventComment = cell;
                        }
                    }
                }
                if (!UWI.equals(lastUWI)) {
                    WellHeader wh = new WellHeader();
                    wh.setUnits(DepthUnits.getUnits((char)units));
                    wh.setCountry("USA");
                    wh.setDatum(WellDatum.ROTARY_TABLE);
                    wh.setWellName(block + " " + wellNum);
                    wh.setOperator(operator);
                    wh.setWellCode(UWI);
                    wh.setLat_dec(Double.valueOf(lat_dec));
                    wh.setLong_dec(Double.valueOf(long_dec));
                    well = ws.addWellToWorkspace(0, null, wh);
                    well.loadInterps();
                }
                if ((interp = this.interpMap.get(source)) == null) {
                    interp = ws.addInterp(source, ++nSource);
                    this.interpMap.put(source, interp);
                }
                WellInterp wellInterp = well.getAddInterp(ws.getInterp(source));
                Sample sample = well.getSample(DepthUtils.convToM((double)depth, (char)units), "CU", true);
                if (sample == null) {
                    sample = well.addSample(DepthUtils.convToM((double)depth, (char)units), SampleType.CU, null);
                }
                if ((event = ws.getSBEvent(eventName)) == null) {
                    try {
                        event = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(true));
                    }
                    catch (SBPermissionException pe) {
                        throw new SBException(pe.getMessage());
                    }
                }
                if (!eventAbr.isEmpty()) {
                    event.setAbr(eventAbr);
                }
                WellEvent wellEvent = new WellEvent.Builder().sample(sample).type(EventType.TOP).event(event).comments(eventComment).qualifier(eventQual).build(ws);
                try {
                    wellInterp.insertEvent(wellEvent);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert event: " + String.valueOf(wellEvent) + " into well: " + String.valueOf(well) + ". Reason: " + ex.toString());
                }
                if (!env.isEmpty() && (termIndex = this.envScheme.getTermIndex(env)) > 0) {
                    IGDIntervalEnv.Builder b = new IGDIntervalEnv.Builder(ws, sample, sample, this.envScheme.getID());
                    b.up(termIndex).ud(termIndex).lp(termIndex).ld(termIndex);
                    wellInterp.insertEnv(b);
                }
                lastUWI = UWI;
            }
            dataTypes.add(1);
            dataTypes.add(16);
            dataTypes.add(15);
            Iterator<Well> it = ws.getWellIterator();
            while (it.hasNext()) {
                ((WsWell)it.next()).updateStatus(dataTypes);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private String toAlphabetic(int i) {
        if (i < 0) {
            return "-" + this.toAlphabetic(-i - 1);
        }
        int quot = i / 26;
        int rem = i % 26;
        char letter = (char)(65 + rem);
        if (quot == 0) {
            return "" + letter;
        }
        return this.toAlphabetic(quot - 1) + letter;
    }
}

