/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.well.DegreesMinutesSecondsCoordinate;
import com.stratadata.model3.well.GeoDatum;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.util.DateUtils;
import com.stratadata.util.depth.DepthUnits;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import model3.Audit;
import model3.DEXFile;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import util.ColourUtils;
import util.DepthUtils;
import util.RSUtils;
import util.SB;
import util.SBException;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class WellHeader
implements Comparable<WellHeader> {
    private static final Logger LOGGER = Logger.getLogger(WellHeader.class.getName());
    private com.stratadata.model3.well.WellHeader details;
    private boolean isUpdateable = false;
    Audit audit = new Audit();
    private final Set<Integer> wellLists = new HashSet<Integer>();

    public WellHeader() {
        this.isUpdateable = true;
        this.details = new com.stratadata.model3.well.WellHeader();
    }

    public WellHeader(com.stratadata.model3.well.WellHeader details) {
        this.details = (com.stratadata.model3.well.WellHeader)SerializationUtils.clone((Serializable)details);
        this.isUpdateable = true;
    }

    public com.stratadata.model3.well.WellHeader getWellHeaderCopy() {
        return (com.stratadata.model3.well.WellHeader)SerializationUtils.clone((Serializable)this.details);
    }

    public String toString() {
        return this.details.toString();
    }

    public String getWellName() {
        return this.details.getWellName();
    }

    public String getWellAltName(boolean defaultToWellName) {
        return this.details.getWellAltName(defaultToWellName);
    }

    public String getWellAltName() {
        return this.details.getWellAltName();
    }

    public String getWellCode() {
        return this.details.getWellCode();
    }

    @Deprecated
    public char getType() {
        return this.details.getSectionType().getCharType();
    }

    public SectionType getSectionType() {
        return this.details.getSectionType();
    }

    @Deprecated
    public char getWellUnits() {
        return this.details.getUnits().getChar();
    }

    public DepthUnits getDepthUnits() {
        return this.details.getUnits();
    }

    public String getOperator() {
        return this.details.getOperator();
    }

    public String getClient() {
        return this.details.getClient();
    }

    public String getCountry() {
        return this.details.getCountry();
    }

    public String getLocState() {
        return this.details.getLocState();
    }

    public String getField() {
        return this.details.getField();
    }

    public String getArea() {
        return this.details.getArea();
    }

    public String getBasin() {
        return this.details.getBasin();
    }

    public double getGridX() {
        return this.details.getGridX();
    }

    public double getGridY() {
        return this.details.getGridY();
    }

    public String getUtmZone() {
        return this.details.getUtmZone();
    }

    public LocalDate getSpudDate() {
        return this.details.getSpudDate();
    }

    public LocalDate getCompletionDate() {
        return this.details.getCompletionDate();
    }

    public double getTD() {
        return this.details.getTerminalDepth();
    }

    public Double getSL() {
        return this.details.getSeaLevel();
    }

    public Double getSB() {
        return this.details.getSeaBed();
    }

    public Double getRTE() {
        return this.details.getRotaryTableElevation();
    }

    public Double getKicko() {
        return this.details.getKickOff();
    }

    public int getParentWellID() {
        return this.details.getParentWellID() != null ? this.details.getParentWellID() : 0;
    }

    public float getDefaultScale() {
        return this.details.getDefaultChartScale();
    }

    public double getSLValue() {
        return Optional.ofNullable(this.details.getSeaLevel()).orElse(0.0);
    }

    public double getSBValue() {
        return Optional.ofNullable(this.details.getSeaBed()).orElse(0.0);
    }

    public double getRTEValue() {
        return Optional.ofNullable(this.details.getRotaryTableElevation()).orElse(0.0);
    }

    public double getKickoValue() {
        return Optional.ofNullable(this.details.getKickOff()).orElse(0.0);
    }

    public String getOcs() {
        return this.details.getOcs();
    }

    public String getCounty() {
        return this.details.getCounty();
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public WellDatum getDepthDatum() {
        return this.details.getDatum();
    }

    public Double getLat_dec() {
        return this.details.getLat_dec();
    }

    public Double getLong_dec() {
        return this.details.getLong_dec();
    }

    public boolean lithologyDepthsAreDrilled() {
        return this.details.lithologyDepthsAreDrilled();
    }

    public Color getColour() {
        return this.details.getColour();
    }

    public DegreesMinutesSecondsCoordinate getLatitudeCoordinate() {
        return this.details.getLatitudeCoordinate();
    }

    public DegreesMinutesSecondsCoordinate getLongitudeCoordinate() {
        return this.details.getLongitudeCoordinate();
    }

    public String getLatString(boolean decimal) {
        return this.details.getLatitudeString(decimal);
    }

    public String getLongString(boolean decimal) {
        return this.details.getLongitudeString(decimal);
    }

    public boolean hasLocation() {
        return this.getLat_dec() != null && this.getLong_dec() != null;
    }

    public String getGeoDatum() {
        return this.details.getGeoDatum();
    }

    public String getEpsgCode(boolean useDefault) {
        return GeoDatum.parseEpsgCode((String)this.getGeoDatum(), (boolean)useDefault);
    }

    public String getDescription() {
        return this.details.getDescription();
    }

    public void setWellName(String wellName) throws SBException {
        if (!wellName.equals(this.details.getWellName())) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update well name");
            }
            this.details.setWellName(wellName);
        }
    }

    public void setWellCode(String wellCode) {
        this.details.setWellCode(wellCode);
    }

    public void setType(SectionType type) throws SBException {
        if (type == null) {
            throw new SBException("Unrecognised section type: " + String.valueOf(type));
        }
        if (type != this.details.getSectionType()) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update type");
            }
            this.details.setSectionType(type);
        }
    }

    public void setWellUnits(char wellUnits) throws SBException {
        if (wellUnits != 'F' && wellUnits != 'M') {
            throw new SBException("Unrecognised section wellUnits: " + wellUnits);
        }
        DepthUnits depthUnits = DepthUnits.getUnits((char)wellUnits);
        if (depthUnits != this.details.getUnits()) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update wellUnits");
            }
            this.details.setUnits(depthUnits);
        }
    }

    void updateWellHeaderField(SBdb db, String field, String value) throws SQLException {
        String sql = "UPDATE " + db.DBTableName("WELLS") + " SET " + field + "=" + SB.DBString((String)value);
        sql = sql + " WHERE well_code='" + this.getWellCode() + "'";
        try (Statement stmt = db.getDatabase().createStatement();){
            stmt.executeUpdate(db.modQuery(sql));
        }
    }

    public void updateLithologyDepths(SBdb sbdb, boolean drilledDepths) throws SQLException {
        if (this.details.lithologyDepthsAreDrilled() == drilledDepths) {
            return;
        }
        this.updateWellHeaderField(sbdb, "lith_depth", drilledDepths ? "D" : "L");
        this.details.setLithologyDepthsAreDrilled(drilledDepths);
    }

    public void setCountry(String country) throws SBException {
        if (!country.equals(this.getCountry())) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update country");
            }
            this.details.setCountry(country);
        }
    }

    public static List<String> getCountries(SBdb sbdb) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT DISTINCT (country) FROM " + sbdb.DBTableName("WELLS") + " ORDER BY COUNTRY";
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            list.add(rs.getString("country"));
        }
        stmt.close();
        return list;
    }

    public void setTD(double td) throws SBException {
        if (td != this.getTD()) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Termination Depth");
            }
            this.details.setTerminalDepth(td);
        }
    }

    public void setRTE(Double rte) throws SBException {
        if (!Objects.equals(rte, this.getRTE())) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update RTE");
            }
            this.details.setRotaryTableElevation(rte);
        }
    }

    public void setKicko(Double kicko) throws SBException {
        if (!Objects.equals(kicko, this.getKicko())) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Kick off Depth");
            }
            this.details.setKickOff(kicko);
        }
    }

    public void setDatum(int datum) throws SBException {
        if (datum != this.details.getDatum().getDbInt()) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update datum");
            }
            WellDatum wd = WellDatum.parse((int)datum);
            if (wd == null) {
                throw new SBException("Unrecognised datum: " + datum);
            }
            this.details.setDatum(wd);
        }
    }

    public boolean updateFromMaster(SBdb sbdb, boolean updateTableData, int wellID) throws SQLException {
        if (!sbdb.hasWellsMaster) {
            return false;
        }
        com.stratadata.model3.well.WellHeader temp = this.getWellHeaderCopy();
        WellHeader.updateFromMaster(sbdb, temp);
        if (updateTableData && !temp.equals((Object)this.details)) {
            this.update(sbdb, wellID, temp);
            return true;
        }
        return false;
    }

    public static void updateFromMaster(SBdb sbdb, com.stratadata.model3.well.WellHeader temp) throws SQLException {
        if (!sbdb.hasWellsMaster) {
            return;
        }
        String sql = "SELECT " + StringUtils.join((Iterable)sbdb.wellMasterFields, (String)", ");
        sql = sql + " FROM " + sbdb.DBTableName("WELLS_MASTER") + " WHERE well_code=" + SB.DBString((String)temp.getWellCode());
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                for (String fieldName : sbdb.wellMasterFields) {
                    Double fieldData;
                    if (fieldName.equalsIgnoreCase("well_name")) {
                        temp.setWellName((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getWellName()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("well_alt_name")) {
                        temp.setWellAltName((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getWellAltName()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("operator")) {
                        temp.setOperator((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getOperator()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("country")) {
                        temp.setCountry((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getCountry()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("loc_state")) {
                        temp.setLocState((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getLocState()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("county")) {
                        temp.setCounty((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getCounty()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("ocs")) {
                        temp.setOcs((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getOcs()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("area")) {
                        temp.setArea((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getArea()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("basin")) {
                        temp.setBasin((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getBasin()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("field")) {
                        temp.setField((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getField()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("grid_x")) {
                        temp.setGridX((double)rs.getLong(fieldName));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("grid_y")) {
                        temp.setGridY((double)rs.getLong(fieldName));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("utm_zone")) {
                        temp.setUtmZone((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getUtmZone()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("spud_date")) {
                        temp.setSpudDate((LocalDate)ObjectUtils.defaultIfNull((Object)rs.getObject(fieldName, LocalDate.class), (Object)temp.getSpudDate()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("comp_date")) {
                        temp.setCompletionDate((LocalDate)ObjectUtils.defaultIfNull((Object)rs.getObject(fieldName, LocalDate.class), (Object)temp.getCompletionDate()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("lat_dec")) {
                        BigDecimal bigDecimalLat = rs.getBigDecimal(fieldName);
                        fieldData = bigDecimalLat == null ? null : Double.valueOf(bigDecimalLat.doubleValue());
                        temp.setLat_dec((Double)ObjectUtils.defaultIfNull((Object)fieldData, (Object)temp.getLat_dec()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("long_dec")) {
                        BigDecimal bigDecimalLong = rs.getBigDecimal(fieldName);
                        fieldData = bigDecimalLong == null ? null : Double.valueOf(bigDecimalLong.doubleValue());
                        temp.setLong_dec((Double)ObjectUtils.defaultIfNull((Object)fieldData, (Object)temp.getLong_dec()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("td")) {
                        temp.setTerminalDepth(((Double)ObjectUtils.defaultIfNull((Object)rs.getDouble(fieldName), (Object)temp.getTerminalDepth())).doubleValue());
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("sl")) {
                        temp.setSeaLevel((Double)ObjectUtils.defaultIfNull((Object)rs.getDouble(fieldName), (Object)temp.getSeaLevel()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("sb")) {
                        temp.setSeaBed((Double)ObjectUtils.defaultIfNull((Object)rs.getDouble(fieldName), (Object)temp.getSeaBed()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("rte")) {
                        temp.setRotaryTableElevation((Double)ObjectUtils.defaultIfNull((Object)rs.getDouble(fieldName), (Object)temp.getRotaryTableElevation()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("kicko")) {
                        temp.setKickOff((Double)ObjectUtils.defaultIfNull((Object)rs.getDouble(fieldName), (Object)temp.getKickOff()));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("datum")) {
                        int fieldData2 = rs.getInt(fieldName);
                        WellDatum datum = WellDatum.parse((int)fieldData2);
                        temp.setDatum(datum);
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("type")) {
                        char fieldData3 = SB.getDBChar((ResultSet)rs, (String)fieldName);
                        temp.setSectionType(SectionType.getSectionType((char)fieldData3));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("units")) {
                        char fieldData4 = SB.getDBChar((ResultSet)rs, (String)fieldName);
                        temp.setUnits(DepthUnits.getUnits((char)fieldData4));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("geodatum")) continue;
                    temp.setGeoDatum((String)StringUtils.defaultIfBlank((CharSequence)rs.getString(fieldName), (CharSequence)temp.getGeoDatum()));
                }
            }
        }
    }

    void update(SBdb conn, int wellID, com.stratadata.model3.well.WellHeader newDetails) throws SQLException {
        if (!conn.isConnected()) {
            this.details = (com.stratadata.model3.well.WellHeader)SerializationUtils.clone((Serializable)newDetails);
            return;
        }
        record Column(String fieldName, int sqlType, Object value) {
            static Column string(String fieldName, String value) {
                return new Column(fieldName, 12, value);
            }

            static Column doubleOrNull(String fieldName, Double value) {
                return new Column(fieldName, 8, value != null && Math.abs(value) > 0.0 ? value : null);
            }

            static Column doubleZeroOrNull(String fieldName, Double value) {
                return new Column(fieldName, 8, value);
            }

            static Column doubleNotNull(String fieldName, double value) {
                return new Column(fieldName, 8, value);
            }

            static Column intNotNull(String fieldName, int value) {
                return new Column(fieldName, 4, value);
            }

            static Column intOrNull(String fieldName, int value) {
                return new Column(fieldName, 4, value > 0 ? Integer.valueOf(value) : null);
            }

            static Column date(String fieldName, LocalDate value) {
                return new Column(fieldName, 91, value);
            }

            static Column charCol(String fieldName, char value) {
                return new Column(fieldName, 12, "" + value);
            }
        }
        LinkedList<Column> columns = new LinkedList<Column>();
        columns.add(Column.string("well_name", newDetails.getWellName()));
        columns.add(Column.string("well_alt_name", newDetails.getWellAltName()));
        columns.add(Column.string("well_code", newDetails.getWellCode()));
        columns.add(Column.string("descrip", newDetails.getDescription()));
        columns.add(Column.string("operator", newDetails.getOperator()));
        columns.add(Column.string("client", newDetails.getClient()));
        columns.add(Column.string("country", newDetails.getCountry()));
        columns.add(Column.string("loc_state", newDetails.getLocState()));
        columns.add(Column.string("county", newDetails.getCounty()));
        columns.add(Column.string("ocs", newDetails.getOcs()));
        columns.add(Column.string("area", newDetails.getArea()));
        columns.add(Column.string("basin", newDetails.getBasin()));
        columns.add(Column.string("field", newDetails.getField()));
        columns.add(Column.doubleOrNull("grid_x", newDetails.getGridX()));
        columns.add(Column.doubleOrNull("grid_y", newDetails.getGridY()));
        columns.add(Column.string("utmzone", newDetails.getUtmZone()));
        columns.add(Column.date("spud_date", newDetails.getSpudDate()));
        columns.add(Column.date("comp_date", newDetails.getCompletionDate()));
        columns.add(Column.doubleZeroOrNull("lat_dec", newDetails.getLat_dec()));
        columns.add(Column.doubleZeroOrNull("long_dec", newDetails.getLong_dec()));
        columns.add(Column.doubleNotNull("td", newDetails.getTerminalDepth()));
        columns.add(Column.doubleOrNull("sl", newDetails.getSeaLevel()));
        columns.add(Column.doubleOrNull("sb", newDetails.getSeaBed()));
        columns.add(Column.doubleOrNull("rte", newDetails.getRotaryTableElevation()));
        columns.add(Column.doubleOrNull("kicko", newDetails.getKickOff()));
        columns.add(Column.intNotNull("datum", newDetails.getDatum().getDbInt()));
        columns.add(Column.charCol("type", newDetails.getSectionType().getCharType()));
        columns.add(Column.charCol("units", newDetails.getUnits().getChar()));
        columns.add(Column.string("geodatum", newDetails.getGeoDatum()));
        columns.add(Column.charCol("lith_depth", newDetails.lithologyDepthsAreDrilled() ? (char)'D' : 'L'));
        columns.add(Column.string("colour", ColourUtils.DBColourString((Color)newDetails.getColour(), (boolean)false, (boolean)false)));
        columns.add(Column.intOrNull("scale", (int)newDetails.getDefaultChartScale()));
        StringBuilder s = new StringBuilder("UPDATE ").append(conn.DBTableName("WELLS")).append(" SET ");
        columns.forEach(col -> s.append(col.fieldName).append("=?,"));
        s.append(Audit.sqlPreparedUpdateString());
        s.append(" WHERE well_id=").append(wellID);
        try (PreparedStatement stmt = conn.getDatabase().prepareStatement(conn.modQuery(s.toString()));){
            int n = 0;
            for (Column col2 : columns) {
                stmt.setObject(++n, col2.value, col2.sqlType);
            }
            this.audit.sqlPreparedUpdate(conn, stmt, ++n, false);
            stmt.executeUpdate();
            conn.commit();
        }
        if (!Objects.equals(this.details.getParentWellID(), newDetails.getParentWellID())) {
            String sql = "DELETE FROM " + conn.DBTableName("WELL_TRACK") + " WHERE WELL_ID=" + wellID;
            try (Statement stmt = conn.getDatabase().createStatement();){
                stmt.executeUpdate(conn.modQuery(sql));
                if (newDetails.getParentWellID() != null) {
                    sql = "INSERT INTO " + conn.DBTableName("WELL_TRACK") + " (WELL_ID, PARENT_ID) VALUES (" + wellID + "," + newDetails.getParentWellID() + ")";
                    stmt.executeUpdate(conn.modQuery(sql));
                }
            }
        }
        this.details = (com.stratadata.model3.well.WellHeader)SerializationUtils.clone((Serializable)newDetails);
    }

    void updateInWorkspace(SBdb conn, com.stratadata.model3.well.WellHeader newDetails) {
        if (conn.isConnected()) {
            throw new IllegalArgumentException("Attempt to update workspace well header in connected database");
        }
        try {
            this.update(conn, 0, newDetails);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Unexcpected SQLException in workspace", e, conn);
        }
    }

    @Override
    public int compareTo(WellHeader o) {
        return this.details.compareTo(o.details);
    }

    synchronized void refresh(SBdb SB2, int wellID, Statement stmt) throws SQLException, SBException {
        Timestamp time;
        Object sql = "SELECT updated  FROM " + SB2.DBTableName("WELLS") + " WHERE well_id=" + wellID;
        ResultSet rs = stmt.executeQuery((String)(sql = SB2.modQuery((String)sql)));
        if (rs.next() && (time = rs.getTimestamp("updated")) != null && time.after(this.audit.updated)) {
            this.load(SB2, wellID);
        }
    }

    void load(SBdb sbdb, int wellID) throws SQLException, SBException, MissingWellException {
        String sql = "SELECT well_name,well_alt_name,well_code,descrip,operator,client,country,loc_state,area,basin,county,ocs,field,grid_x,grid_y,utmzone,spud_date,comp_date,td,sl,sb,rte,kicko,datum,type,units," + Audit.sqlFieldString("w") + ",geodatum,lith_depth,colour,scale,lat_dec,long_dec,t.parent_id FROM " + sbdb.DBTableName("WELLS") + " w LEFT JOIN " + sbdb.DBTableName("WELL_TRACK") + " t ON t.well_id=w.well_id WHERE w.well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                BigDecimal bdLongDec;
                BigDecimal bdLatDec;
                this.details = new com.stratadata.model3.well.WellHeader(0);
                this.details.setWellName(rs.getString("well_name"));
                this.details.setWellAltName(rs.getString("well_alt_name"));
                this.details.setWellCode(rs.getString("well_code"));
                this.details.setDescription(SB.getDBString((ResultSet)rs, (String)"descrip"));
                this.details.setOperator(SB.getDBString((ResultSet)rs, (String)"operator"));
                this.details.setClient(SB.getDBString((ResultSet)rs, (String)"client"));
                this.details.setOcs(SB.getDBString((ResultSet)rs, (String)"ocs"));
                this.details.setCountry(SB.getDBString((ResultSet)rs, (String)"country"));
                this.details.setLocState(SB.getDBString((ResultSet)rs, (String)"loc_state"));
                this.details.setArea(SB.getDBString((ResultSet)rs, (String)"area"));
                this.details.setBasin(SB.getDBString((ResultSet)rs, (String)"basin"));
                this.details.setCounty(SB.getDBString((ResultSet)rs, (String)"county"));
                this.details.setField(SB.getDBString((ResultSet)rs, (String)"field"));
                this.details.setGridX(rs.getDouble("grid_x"));
                this.details.setGridY(rs.getDouble("grid_y"));
                this.details.setUtmZone(SB.getDBString((ResultSet)rs, (String)"utmzone"));
                this.details.setSpudDate(rs.getObject("spud_date", LocalDate.class));
                this.details.setCompletionDate(rs.getObject("comp_date", LocalDate.class));
                this.details.setTerminalDepth(rs.getDouble("td"));
                this.details.setSeaLevel(RSUtils.getDoubleOrNull((ResultSet)rs, (String)"sl"));
                this.details.setSeaBed(RSUtils.getDoubleOrNull((ResultSet)rs, (String)"sb"));
                this.details.setRotaryTableElevation(RSUtils.getDoubleOrNull((ResultSet)rs, (String)"rte"));
                this.details.setKickOff(RSUtils.getDoubleOrNull((ResultSet)rs, (String)"kicko"));
                this.details.setDatum(WellDatum.parse((int)rs.getInt("datum")));
                String s = rs.getString("type");
                if (s != null && s.length() > 0) {
                    this.details.setSectionType(SectionType.getSectionType((char)s.charAt(0)));
                }
                if ((s = rs.getString("units")) != null && s.length() > 0) {
                    this.details.setUnits(DepthUnits.getUnits((char)s.charAt(0)));
                }
                this.audit = new Audit(rs, "w");
                this.details.setGeoDatum(SB.getDBString((ResultSet)rs, (String)"geodatum"));
                String lithString = SB.getDBString((ResultSet)rs, (String)"lith_depth");
                this.details.setLithologyDepthsAreDrilled(!lithString.isEmpty() && lithString.toUpperCase().charAt(0) == 'D');
                this.details.setColour(ColourUtils.getDBColour((String)rs.getString("colour")));
                Float scaleTemp = RSUtils.getFloatOrNull((ResultSet)rs, (String)"scale");
                if (scaleTemp != null) {
                    this.details.setDefaultChartScale(scaleTemp.floatValue());
                }
                if ((bdLatDec = SB.getBigDecimal((ResultSet)rs, (String)"lat_dec", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0)) != null) {
                    this.details.setLat_dec(Double.valueOf(bdLatDec.doubleValue()));
                }
                if ((bdLongDec = SB.getBigDecimal((ResultSet)rs, (String)"long_dec", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0)) != null) {
                    this.details.setLong_dec(Double.valueOf(bdLongDec.doubleValue()));
                }
            } else {
                throw new MissingWellException("Cannot create well with wellID: " + wellID);
            }
            this.details.setParentWellID(rs.getObject("parent_id", Integer.class));
            this.updateFromMaster(sbdb, true, wellID);
            sql = "SELECT wellist_id FROM " + sbdb.DBTableName("WELLIST_MBR") + " WHERE well_id=" + wellID;
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                this.wellLists.add(rs.getInt("wellist_id"));
            }
        }
    }

    void writeDEX(Writer out, String eol, boolean fullHeader, char units) throws IOException {
        out.write("[HEADER]" + eol);
        out.write("Well Name = " + this.getWellName() + eol);
        if (fullHeader) {
            out.write("Well Code = " + this.getWellCode() + eol);
            if (!this.getOperator().isBlank()) {
                out.write("Operator = " + this.getOperator() + eol);
            }
            if (!this.getField().isBlank()) {
                out.write("Field = " + this.getField() + eol);
            }
            if (!this.getCountry().isBlank()) {
                out.write("Country = " + this.getCountry() + eol);
            }
            if (!this.getCounty().isBlank()) {
                out.write("County = " + this.getCounty() + eol);
            }
            if (!this.getOcs().isBlank()) {
                out.write("OCS number = " + this.getOcs() + eol);
            }
            out.write("Type = " + this.details.getSectionType().getStringType() + eol);
            out.write("Units = " + this.details.getUnits().getFullName() + eol);
            if (this.getLong_dec() != null) {
                out.write("Longitude = " + this.getLong_dec() + eol);
            }
            if (this.getLat_dec() != null) {
                out.write("Latitude = " + this.getLat_dec() + eol);
            }
            if (this.getGridX() > 0.0) {
                out.write("Grid X = " + this.getGridX() + eol);
            }
            if (this.getGridY() > 0.0) {
                out.write("Grid Y = " + this.getGridY() + eol);
            }
            if (this.getSpudDate() != null) {
                out.write("Spud Date = " + this.getSpudDate().format(DateUtils.DISPLAY_FORMAT) + eol);
            }
            if (this.getCompletionDate() != null) {
                out.write("Completion Date = " + this.getCompletionDate().format(DateUtils.DISPLAY_FORMAT) + eol);
            }
            if (this.getTD() > 0.0) {
                out.write("Terminal depth = " + com.stratadata.util.depth.DepthUtils.depthString((double)this.getTD(), (DepthUnits)this.details.getUnits(), (int)2, (SectionType)this.details.getSectionType()) + eol);
            }
            if (this.getSL() != null) {
                out.write("SL = " + com.stratadata.util.depth.DepthUtils.depthString((double)this.getSL(), (DepthUnits)this.details.getUnits(), (int)2, (SectionType)this.details.getSectionType()) + eol);
            }
            if (this.getSB() != null) {
                out.write("SB = " + com.stratadata.util.depth.DepthUtils.depthString((double)this.getSB(), (DepthUnits)this.details.getUnits(), (int)2, (SectionType)this.details.getSectionType()) + eol);
            }
            if (this.getRTE() != null) {
                out.write("RTE = " + com.stratadata.util.depth.DepthUtils.depthString((double)this.getRTE(), (DepthUnits)this.details.getUnits(), (int)2, (SectionType)this.details.getSectionType()) + eol);
            }
            if (this.getKicko() != null) {
                out.write("Kick off depth = " + com.stratadata.util.depth.DepthUtils.depthString((double)this.getKicko(), (DepthUnits)this.details.getUnits(), (int)2, (SectionType)this.details.getSectionType()) + eol);
            }
            out.write("Depth Datum = " + this.details.getDatum().getShortDescr() + eol);
        }
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write((String)ind + SB.getXMLfieldString((String)"WellCode", (String)this.details.getWellCode()));
        if (!this.details.getWellAltName().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"WellAltName", (String)this.details.getWellAltName()));
        }
        out.write((String)ind + SB.getXMLfieldString((String)"Country", (String)this.getCountry()));
        out.write((String)ind + "<Type>" + this.details.getSectionType().getStringType() + "</Type>\n");
        out.write((String)ind + "<Units>" + this.details.getUnits().getFullName() + "</Units>\n");
        if (!this.getOperator().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"Operator", (String)this.getOperator()));
        }
        if (!this.getOcs().isBlank()) {
            out.write((String)ind + "<Ocs>" + this.getOcs() + "</Ocs>\n");
        }
        if (!this.getField().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"Field", (String)this.getField()));
        }
        if (!this.getCounty().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"County", (String)this.getCounty()));
        }
        if (!this.getLocState().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"LocState", (String)this.getLocState()));
        }
        if (!this.getArea().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"Area", (String)this.getArea()));
        }
        if (!this.getBasin().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"Basin", (String)this.getBasin()));
        }
        if (this.getLat_dec() != null) {
            out.write((String)ind + "<Latitude>" + this.getLat_dec() + "</Latitude>\n");
        }
        if (this.getLong_dec() != null) {
            out.write((String)ind + "<Longitude>" + this.getLong_dec() + "</Longitude>\n");
        }
        if (!this.getGeoDatum().isBlank()) {
            out.write((String)ind + SB.getXMLfieldString((String)"GeodeticDatum", (String)this.getGeoDatum()));
        }
        if (this.getGridX() > 0.0) {
            out.write((String)ind + "<GridX>" + this.getGridX() + "</GridX>\n");
        }
        if (this.getGridY() > 0.0) {
            out.write((String)ind + "<GridY>" + this.getGridY() + "</GridY>\n");
        }
        if (!this.getUtmZone().isBlank()) {
            out.write((String)ind + "<UTMZone>" + SB.getXMLstring((String)this.getUtmZone()) + "</UTMZone>\n");
        }
        if (this.getSpudDate() != null) {
            out.write((String)ind + SB.getXMLfieldString((String)"SpudDate", (String)this.getSpudDate().format(DateUtils.DB_DATE_FORMAT)));
        }
        if (this.getCompletionDate() != null) {
            out.write((String)ind + SB.getXMLfieldString((String)"CompletionDate", (String)this.getCompletionDate().format(DateUtils.DB_DATE_FORMAT)));
        }
        out.write((String)ind + "<TerminalDepth>" + com.stratadata.util.depth.DepthUtils.convFromM((double)this.getTD(), (DepthUnits)this.getDepthUnits(), (SectionType)this.details.getSectionType()) + "</TerminalDepth>\n");
        out.write((String)ind + "<DepthDatum>" + this.details.getDatum().getShortDescr() + "</DepthDatum>\n");
        if (this.getRTE() != null) {
            out.write((String)ind + "<RotaryTableElevation>" + com.stratadata.util.depth.DepthUtils.convFromM((double)this.getRTE(), (DepthUnits)this.getDepthUnits(), (SectionType)this.details.getSectionType()) + "</RotaryTableElevation>\n");
        }
        if (this.getSL() != null) {
            out.write((String)ind + "<SeaLevel>" + com.stratadata.util.depth.DepthUtils.convFromM((double)this.getSL(), (DepthUnits)this.getDepthUnits(), (SectionType)this.details.getSectionType()) + "</SeaLevel>\n");
        }
        if (this.getSB() != null) {
            out.write((String)ind + "<SeaBed>" + com.stratadata.util.depth.DepthUtils.convFromM((double)this.getSB(), (DepthUnits)this.getDepthUnits(), (SectionType)this.details.getSectionType()) + "</SeaBed>\n");
        }
        if (this.getKicko() != null) {
            out.write((String)ind + "<KickOffDepth>" + com.stratadata.util.depth.DepthUtils.convFromM((double)this.getKicko(), (DepthUnits)this.getDepthUnits(), (SectionType)this.details.getSectionType()) + "</KickOffDepth>\n");
        }
        out.write((String)ind + "<LithologyDepths>" + (this.details.lithologyDepthsAreDrilled() ? "Drilled" : "Logged") + "</LithologyDepths>\n");
        LinkedList<Integer> userIDList = this.audit.writeXML(out, indent);
        return userIDList;
    }

    boolean parseDEX(DEXFile.DEXsection section, int[] wellAbn) throws SBException {
        int abnSchemeID = 0;
        boolean wellUnitsSet = false;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Operator")) {
                this.details.setOperator(value);
                continue;
            }
            if (label.equalsIgnoreCase("Well name")) {
                this.details.setWellName(value);
                continue;
            }
            if (label.equalsIgnoreCase("Well code")) {
                this.details.setWellCode(value);
                continue;
            }
            if (label.equalsIgnoreCase("Field")) {
                this.details.setField(value);
                continue;
            }
            if (label.equalsIgnoreCase("Country")) {
                this.details.setCountry(value);
                continue;
            }
            if (label.equalsIgnoreCase("County")) {
                this.details.setCounty(value);
                continue;
            }
            if (label.equalsIgnoreCase("OCS number")) {
                this.details.setOcs(value);
                continue;
            }
            if (label.equalsIgnoreCase("Type")) {
                if (value.equalsIgnoreCase("Outcrop")) {
                    this.details.setSectionType(SectionType.OUTCROP);
                    continue;
                }
                this.details.setSectionType(SectionType.WELL);
                continue;
            }
            if (label.equalsIgnoreCase("Units")) {
                this.details.setUnits(DepthUnits.getUnits((char)value.toUpperCase().charAt(0)));
                wellUnitsSet = true;
                continue;
            }
            if (label.equalsIgnoreCase("Longtitude") || label.equalsIgnoreCase("Longitude")) {
                this.details.setLong_dec(Double.valueOf(Double.parseDouble(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Latitude")) {
                this.details.setLat_dec(Double.valueOf(Double.parseDouble(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Grid X")) {
                this.details.setGridX(Double.parseDouble(value));
                continue;
            }
            if (label.equalsIgnoreCase("Grid Y")) {
                this.details.setGridY(Double.parseDouble(value));
                continue;
            }
            if (label.equalsIgnoreCase("Spud Date")) {
                try {
                    this.details.setSpudDate(LocalDate.parse(value, DateUtils.DISPLAY_FORMAT));
                }
                catch (DateTimeParseException dateTimeParseException) {}
                continue;
            }
            if (label.equalsIgnoreCase("Completion Date")) {
                try {
                    this.details.setCompletionDate(LocalDate.parse(value, DateUtils.DISPLAY_FORMAT));
                }
                catch (DateTimeParseException dateTimeParseException) {}
                continue;
            }
            if (label.equalsIgnoreCase("Terminal depth")) {
                try {
                    this.details.setTerminalDepth(DepthUtils.parseDepthString((String)value));
                }
                catch (SBException ue) {
                    System.out.println("Exception parsing td: " + String.valueOf((Object)ue));
                }
                continue;
            }
            if (label.equalsIgnoreCase("Total depth")) {
                this.details.setTerminalDepth(DepthUtils.parseDepthString((String)value));
                continue;
            }
            if (label.equalsIgnoreCase("SL")) {
                this.details.setSeaLevel(Double.valueOf(DepthUtils.parseDepthString((String)value)));
                continue;
            }
            if (label.equalsIgnoreCase("SB")) {
                this.details.setSeaBed(Double.valueOf(DepthUtils.parseDepthString((String)value)));
                continue;
            }
            if (label.equalsIgnoreCase("RTE")) {
                this.details.setRotaryTableElevation(Double.valueOf(DepthUtils.parseDepthString((String)value)));
                continue;
            }
            if (label.equalsIgnoreCase("Kick off depth")) {
                this.details.setKickOff(Double.valueOf(DepthUtils.parseDepthString((String)value)));
                continue;
            }
            if (label.equalsIgnoreCase("Depth Datum")) {
                if (this.details.getSectionType() == SectionType.OUTCROP) {
                    this.details.setDatum(WellDatum.SEA_LEVEL);
                    continue;
                }
                this.details.setDatum(WellDatum.parse((String)value));
                continue;
            }
            if (label.equalsIgnoreCase("Abundance scheme ID")) {
                abnSchemeID = Integer.parseInt(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Discipline") || sepChar != ':') continue;
            wellAbn[SBdb.did2i((char)value.charAt((int)0))] = abnSchemeID;
            abnSchemeID = 0;
        }
        return wellUnitsSet;
    }

    @Deprecated
    void parseXML(String chars, String element) throws ParseException {
        if (element.compareTo("WellCode") == 0) {
            this.details.setWellCode(chars);
        } else if (element.compareTo("Country") == 0) {
            this.details.setCountry(chars);
        } else if (element.compareTo("County") == 0) {
            this.details.setCounty(chars);
        } else if (element.compareTo("Field") == 0) {
            this.details.setField(chars);
        } else if (element.compareTo("Type") == 0) {
            if (chars.compareToIgnoreCase("Outcrop") == 0) {
                this.details.setSectionType(SectionType.OUTCROP);
            }
        } else if (element.compareTo("Operator") == 0) {
            this.details.setOperator(chars);
        } else if (element.compareTo("Ocs") == 0) {
            this.details.setOcs(chars);
        } else if (element.compareTo("Longitude") == 0) {
            this.details.setLong_dec(Double.valueOf(Double.parseDouble(chars)));
        } else if (element.compareTo("Latitude") == 0) {
            this.details.setLat_dec(Double.valueOf(Double.parseDouble(chars)));
        } else if (element.compareTo("GeodeticDatum") == 0) {
            this.details.setGeoDatum(chars);
        } else if (element.compareTo("GridX") == 0) {
            this.details.setGridX(Double.parseDouble(chars));
        } else if (element.compareTo("GridY") == 0) {
            this.details.setGridY(Double.parseDouble(chars));
        } else if (element.compareTo("SpudDate") == 0) {
            this.details.setSpudDate(LocalDate.from(DateUtils.DB_DATE_FORMAT.parse(chars)));
        } else if (element.compareTo("CompletionDate") == 0) {
            this.details.setCompletionDate(LocalDate.from(DateUtils.DB_DATE_FORMAT.parse(chars)));
        } else if (element.compareTo("Units") == 0) {
            this.details.setUnits(DepthUnits.getUnits((char)chars.toUpperCase().charAt(0)));
        } else if (element.compareTo("TerminalDepth") == 0) {
            this.details.setTerminalDepth(com.stratadata.util.depth.DepthUtils.convToM((float)Float.parseFloat(chars), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType()));
        } else if (element.compareTo("SeaLevel") == 0) {
            this.details.setSeaLevel(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((float)Float.parseFloat(chars), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        } else if (element.compareTo("SeaBed") == 0) {
            this.details.setSeaBed(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((float)Float.parseFloat(chars), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        } else if (element.compareTo("KickOffDepth") == 0) {
            this.details.setKickOff(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((float)Float.parseFloat(chars), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        } else if (element.compareTo("RotaryTableElevation") == 0) {
            this.details.setRotaryTableElevation(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((float)Float.parseFloat(chars), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        } else if (element.compareTo("DepthDatum") == 0) {
            this.details.setDatum(WellDatum.parse((String)chars));
        }
    }

    static Color getStatus(com.stratadata.model3.well.WellHeader wsH, com.stratadata.model3.well.WellHeader dbH) {
        if (dbH == null) {
            return SbugsStatus.NOTSTORED;
        }
        MergeStatus m = new MergeStatus(SbugsStatus.STORED);
        m.compareCharField("Well/outcrop", wsH.getSectionType().getCharType(), dbH.getSectionType().getCharType());
        m.compareCharField("Depth units", wsH.getUnits().getChar(), dbH.getUnits().getChar());
        m.compareStringField("Operator", wsH.getOperator(), dbH.getOperator(), true);
        m.compareStringField("OCS number", wsH.getOcs(), dbH.getOcs(), true);
        m.compareLocalDateField("Spud date", wsH.getSpudDate(), dbH.getSpudDate());
        m.compareLocalDateField("Completion date", wsH.getCompletionDate(), dbH.getCompletionDate());
        m.compareStringField("Country", wsH.getCountry(), dbH.getCountry(), true);
        m.compareStringField("County", wsH.getCounty(), dbH.getCounty(), true);
        m.compareStringField("State", wsH.getLocState(), dbH.getLocState(), true);
        m.compareStringField("Field", wsH.getField(), dbH.getField(), true);
        m.compareStringField("Basin", wsH.getBasin(), dbH.getBasin(), true);
        m.compareStringField("Area", wsH.getArea(), dbH.getArea(), true);
        m.compareStringField("Geodetic datum", wsH.getGeoDatum(), dbH.getGeoDatum(), true);
        m.compareDoubleField("Grid X", wsH.getGridX(), dbH.getGridX());
        m.compareDoubleField("Grid Y", wsH.getGridY(), dbH.getGridY());
        m.compareStringField("UTM Zone", wsH.getUtmZone(), dbH.getUtmZone(), true);
        m.compareNullableDoubleField("Latitude", wsH.getLat_dec(), dbH.getLat_dec());
        m.compareNullableDoubleField("Longitude", wsH.getLong_dec(), dbH.getLong_dec());
        m.compareIntField("Depth datum", wsH.getDatum().getDbInt(), wsH.getDatum().getDbInt());
        m.compareNullableDoubleField("RTE", wsH.getRotaryTableElevation(), dbH.getRotaryTableElevation());
        m.compareNullableDoubleField("Sea Level", wsH.getSeaLevel(), dbH.getSeaLevel());
        m.compareNullableDoubleField("Sea Bed", wsH.getSeaBed(), dbH.getSeaBed());
        m.compareNullableDoubleField("Kickoff depth", wsH.getKickOff(), dbH.getKickOff());
        m.compareDoubleField("Termination depth", wsH.getTerminalDepth(), dbH.getTerminalDepth());
        m.compareCharField("Lithology depths", wsH.lithologyDepthsAreDrilled() ? (char)'D' : 'L', dbH.lithologyDepthsAreDrilled() ? (char)'D' : 'L');
        return m.getStatus();
    }

    void updateFromLink(SBdb db, int wellID, com.stratadata.model3.well.WellHeader link) throws SQLException {
        MergeStatus m = new MergeStatus(SbugsStatus.NOTSTORED);
        m.compareCharField("Well/outcrop", this.details.getSectionType().getCharType(), link.getSectionType().getCharType());
        m.compareCharField("Depth units", this.details.getUnits().getChar(), link.getUnits().getChar());
        com.stratadata.model3.well.WellHeader headerCopy = this.getWellHeaderCopy();
        headerCopy.setOperator(m.compareStringField("Operator", link.getOperator(), this.getOperator(), true));
        headerCopy.setOcs(m.compareStringField("OCS number", link.getOcs(), this.getOcs(), true));
        headerCopy.setSpudDate(m.compareLocalDateField("Spud date", link.getSpudDate(), this.details.getSpudDate()));
        headerCopy.setCompletionDate(m.compareLocalDateField("Completion date", link.getCompletionDate(), this.details.getCompletionDate()));
        headerCopy.setCountry(m.compareStringField("Country", link.getCountry(), this.details.getCountry(), true));
        headerCopy.setCounty(m.compareStringField("County", link.getCounty(), this.details.getCounty(), true));
        headerCopy.setField(m.compareStringField("Field", link.getField(), this.details.getField(), true));
        headerCopy.setLocState(m.compareStringField("State", link.getLocState(), this.details.getLocState(), true));
        headerCopy.setBasin(m.compareStringField("Basin", link.getBasin(), this.details.getBasin(), true));
        headerCopy.setArea(m.compareStringField("Area", link.getArea(), this.details.getArea(), true));
        headerCopy.setGeoDatum(m.compareStringField("Geodetic datum", link.getGeoDatum(), this.details.getGeoDatum(), true));
        headerCopy.setGridX(m.compareDoubleField("Grid X", link.getGridX(), this.details.getGridX()));
        headerCopy.setGridY(m.compareDoubleField("Grid Y", link.getGridY(), this.details.getGridY()));
        headerCopy.setUtmZone(m.compareStringField("UTM zone", link.getUtmZone(), this.details.getUtmZone(), true));
        headerCopy.setLat_dec(m.compareNullableDoubleField("Latitude", link.getLat_dec(), this.details.getLat_dec()));
        headerCopy.setLong_dec(m.compareNullableDoubleField("Longitude", link.getLong_dec(), this.details.getLong_dec()));
        headerCopy.setDatum(WellDatum.parse((int)m.compareIntField("Depth datum", link.getDatum().getDbInt(), this.details.getDatum().getDbInt())));
        headerCopy.setRotaryTableElevation(m.compareNullableDoubleField("RTE", link.getRotaryTableElevation(), this.details.getRotaryTableElevation()));
        headerCopy.setSeaLevel(m.compareNullableDoubleField("Sea Level", link.getSeaLevel(), this.details.getSeaLevel()));
        headerCopy.setSeaBed(m.compareNullableDoubleField("Sea Bed", link.getSeaBed(), this.details.getSeaBed()));
        headerCopy.setKickOff(m.compareNullableDoubleField("Kickoff depth", link.getKickOff(), this.details.getKickOff()));
        headerCopy.setTerminalDepth(m.compareDoubleField("Terminal depth", link.getTerminalDepth(), this.details.getTerminalDepth()));
        if (m.getStatus() == SbugsStatus.PARTSTORED) {
            this.update(db, wellID, headerCopy);
        }
    }

    void parseXML(Element xml) throws ParseException {
        String strg = xml.getChildTextNormalize("WellCode");
        if (strg != null) {
            this.details.setWellCode(strg);
        }
        if ((strg = xml.getChildTextNormalize("WellAltName")) != null) {
            this.details.setWellAltName(strg);
        }
        if ((strg = xml.getChildTextNormalize("Country")) != null) {
            this.details.setCountry(strg);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.compareToIgnoreCase("Outcrop") == 0) {
            this.details.setSectionType(SectionType.OUTCROP);
        }
        if ((strg = xml.getChildTextNormalize("Units")) != null) {
            this.details.setUnits(DepthUnits.getUnits((char)strg.toUpperCase().charAt(0)));
        }
        if ((strg = xml.getChildTextNormalize("Operator")) != null) {
            this.details.setOperator(strg);
        }
        if ((strg = xml.getChildTextNormalize("Ocs")) != null) {
            this.details.setOcs(strg);
        }
        if ((strg = xml.getChildTextNormalize("Field")) != null) {
            this.details.setField(strg);
        }
        if ((strg = xml.getChildTextNormalize("County")) != null) {
            this.details.setCounty(strg);
        }
        if ((strg = xml.getChildTextNormalize("LocState")) != null) {
            this.details.setLocState(strg);
        }
        if ((strg = xml.getChildTextNormalize("Area")) != null) {
            this.details.setArea(strg);
        }
        if ((strg = xml.getChildTextNormalize("Basin")) != null) {
            this.details.setBasin(strg);
        }
        if ((strg = xml.getChildTextNormalize("Latitude")) != null) {
            this.details.setLat_dec(Double.valueOf(Double.parseDouble(strg)));
        }
        if ((strg = xml.getChildTextNormalize("Longitude")) != null) {
            this.details.setLong_dec(Double.valueOf(Double.parseDouble(strg)));
        }
        if ((strg = xml.getChildTextNormalize("GeodeticDatum")) != null) {
            this.details.setGeoDatum(strg);
        }
        if ((strg = xml.getChildTextNormalize("GridX")) != null) {
            this.details.setGridX(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("GridY")) != null) {
            this.details.setGridY(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("UTMZone")) != null) {
            this.details.setUtmZone(strg);
        }
        if ((strg = xml.getChildTextNormalize("SpudDate")) != null) {
            this.details.setSpudDate(LocalDate.from(DateUtils.DB_DATE_FORMAT.parse(strg)));
        }
        if ((strg = xml.getChildTextNormalize("CompletionDate")) != null) {
            this.details.setCompletionDate(LocalDate.from(DateUtils.DB_DATE_FORMAT.parse(strg)));
        }
        if ((strg = xml.getChildTextNormalize("TerminalDepth")) != null) {
            this.details.setTerminalDepth(com.stratadata.util.depth.DepthUtils.convToM((double)Double.parseDouble(strg), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType()));
        }
        if ((strg = xml.getChildTextNormalize("DepthDatum")) != null) {
            this.details.setDatum(WellDatum.parse((String)strg));
        }
        if ((strg = xml.getChildTextNormalize("RotaryTableElevation")) != null) {
            this.details.setRotaryTableElevation(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((double)Double.parseDouble(strg), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        }
        if ((strg = xml.getChildTextNormalize("SeaLevel")) != null) {
            this.details.setSeaLevel(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((double)Double.parseDouble(strg), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        }
        if ((strg = xml.getChildTextNormalize("SeaBed")) != null) {
            this.details.setSeaBed(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((double)Double.parseDouble(strg), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        }
        if ((strg = xml.getChildTextNormalize("KickOffDepth")) != null) {
            this.details.setKickOff(Double.valueOf(com.stratadata.util.depth.DepthUtils.convToM((double)Double.parseDouble(strg), (DepthUnits)this.details.getUnits(), (SectionType)this.details.getSectionType())));
        }
        if ((strg = xml.getChildTextNormalize("LithologyDepths")) != null) {
            this.details.setLithologyDepthsAreDrilled(strg.toUpperCase().trim().charAt(0) == 'D');
        }
    }

    void removeFromWellList(int wellListID) {
        this.wellLists.remove(wellListID);
    }

    public boolean isWellListMember(int wellListID) {
        return this.wellLists.contains(wellListID);
    }

    public Set<Integer> getWellListIDs() {
        return new HashSet<Integer>(this.wellLists);
    }

    boolean addToWellList(int projID) throws SQLException {
        return this.wellLists.add(projID);
    }

    void storeWellListMembership(SBdb sbdb, int wellID) throws SQLException {
        String sql = "DELETE FROM " + sbdb.DBTableName("WELLIST_MBR") + " WHERE well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
            for (Integer projID : this.wellLists) {
                sql = "INSERT INTO " + sbdb.DBTableName("WELLIST_MBR") + " (wellist_id,well_id) VALUES (" + projID + "," + wellID + ")";
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        }
    }

    public void fillAuditWorkspace(SBdb db, SBdb ws) throws SQLException, SBException {
        this.audit.fillWorkspace(db, ws);
    }

    public float getRTDepth() {
        return (float)this.details.getRTDepth();
    }

    public float getSLDepth() {
        return (float)this.details.getSLDepth();
    }

    public float getSBDepth() {
        return (float)this.details.getSBDepth();
    }

    public static class MissingWellException
    extends RuntimeException {
        public MissingWellException(String message) {
            super(message);
        }
    }
}

