/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import model3.SBdb;
import model3.WsWell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellHeaderXLS {
    SimpleDateFormat[] dfs = new SimpleDateFormat[]{new SimpleDateFormat("dd.MM.yyyy"), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("MMM dd yyyy", Locale.US), new SimpleDateFormat("MMM dd yyyy", Locale.UK)};
    private static final Pattern DMS_LAT_PATTERN = Pattern.compile("(-?)([0-9]{1,2})\u00b0([0-5]?[0-9])'([0-5]?[0-9]\\.[0-9]{1,})\"([NS])\\s*");
    private static final Pattern DMS_LONG_PATTERN = Pattern.compile("(-?)([0-1]?[0-9]{1,2})\u00b0([0-5]?[0-9])'([0-5]?[0-9]\\.[0-9]{1,})\"([EW])\\s*");

    public static String[] getSheets(File file) throws IOException {
        Workbook wb = WorkbookFactory.create((File)file);
        String[] sheets = new String[wb.getNumberOfSheets()];
        for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            sheets[j] = wb.getSheetName(j);
        }
        wb.close();
        return sheets;
    }

    public WellHeaderXLS(SBdb ws, GridReader in, char defaultUnits) throws GridReaderException, SBException, SBPermissionException, SQLException {
        boolean COL_CODE = true;
        int COL_GRIDX = 2;
        int COL_GRIDY = 3;
        int COL_LAT = 4;
        int COL_LONG = 5;
        int COL_OPER = 6;
        int COL_NAME = 7;
        int COL_ALTNAME = 8;
        int COL_COUNTY = 9;
        int COL_COUNTRY = 10;
        int COL_TD = 11;
        int COL_RTE = 12;
        int COL_SPUD = 13;
        int COL_COMP = 14;
        int COL_FIELD = 15;
        int COL_SB = 16;
        int COL_GEODATUM = 17;
        int COL_SL = 18;
        int COL_OCS = 19;
        int COL_KICKO = 20;
        int COL_DATUM = 21;
        int COL_AREA = 22;
        int COL_BASIN = 23;
        int COL_DEPTHUNITS = 24;
        String[] columnNames = new String[]{"name", "altName", "alias", "code", "well code", "api", "well name", "wellnumber", "Surface X", "Surface Y", "lat", "latitude", "long", "longitude", "operator", "county", "country", "td", "rte", "Elevation", "SPUD date", "Completion date", "Field", "Location", "Water depth", "SB", "Geodatum", "Sea Level", "SL", "OCS", "OCS Number", "Kickoff", "Datum", "Area", "Basin", "Units"};
        int[] columnType = new int[]{7, 8, 8, 1, 1, 1, 7, 7, 2, 3, 4, 4, 5, 5, 6, 9, 10, 11, 12, 12, 13, 14, 15, 9, 16, 16, 17, 18, 18, 19, 19, 20, 21, 22, 23, 24};
        boolean first = true;
        Boolean removeWellNameSpace = null;
        int[] cols = null;
        while (in.nextRow()) {
            WellDatum parsedDatum;
            String cell;
            if (first) {
                LinkedList<String> titles = new LinkedList<String>();
                while ((cell = in.getNextCell()) != null) {
                    titles.add(cell);
                }
                cols = new int[titles.size()];
                block52: for (int i = 0; i < cols.length; ++i) {
                    for (int j = 0; j < columnNames.length; ++j) {
                        if (!columnNames[j].equalsIgnoreCase((String)titles.get(i))) continue;
                        cols[i] = columnType[j];
                        continue block52;
                    }
                }
                first = false;
                continue;
            }
            if (cols == null) {
                throw new SBException("No column titles in first row of file/sheet");
            }
            int i = 0;
            String name = "";
            String altName = "";
            String code = "";
            String OCS = null;
            Double lat = null;
            Double lon = null;
            String operator = null;
            String county = null;
            String field = null;
            String country = null;
            Double td = null;
            Double sb = null;
            Double rte = null;
            Double sl = null;
            Double kicko = null;
            Double gridX = null;
            Double gridY = null;
            Date spud = null;
            Date comp = null;
            String geodatum = null;
            String depthDatum = null;
            String area = null;
            String basin = null;
            String depthUnits = null;
            char units = defaultUnits;
            while ((cell = in.getNextCell()) != null) {
                if (i >= cols.length) {
                    System.out.println("Line for cell: " + cell + " Exceeds titles length");
                    break;
                }
                if (cell == null || cell.isEmpty()) {
                    ++i;
                    continue;
                }
                switch (cols[i]) {
                    case 7: {
                        name = cell.trim();
                        if (!name.contains("- ")) break;
                        if (removeWellNameSpace == null) {
                            removeWellNameSpace = JOptionPane.showConfirmDialog(null, "Remove embedded spaces in well names like: " + name + "?", "XLS Reader", 0, 3) == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        }
                        if (!removeWellNameSpace.booleanValue()) break;
                        name = name.replace("- ", "-");
                        break;
                    }
                    case 8: {
                        altName = cell;
                        break;
                    }
                    case 1: {
                        code = cell;
                        break;
                    }
                    case 4: {
                        try {
                            lat = Double.parseDouble(cell);
                            lat = (double)Math.round(lat * 1000000.0) / 1000000.0;
                        }
                        catch (IllegalArgumentException p) {
                            try {
                                lat = this.convertCoord(cell, true);
                            }
                            catch (NumberFormatException e) {
                                System.out.println(e.getMessage());
                                System.out.println(p.getMessage());
                            }
                        }
                        break;
                    }
                    case 5: {
                        try {
                            lon = Double.parseDouble(cell);
                            lon = (double)Math.round(lon * 1000000.0) / 1000000.0;
                        }
                        catch (IllegalArgumentException p) {
                            try {
                                lon = this.convertCoord(cell, false);
                            }
                            catch (NumberFormatException e) {
                                System.out.println(e.getMessage());
                                System.out.println(p.getMessage());
                            }
                        }
                        break;
                    }
                    case 2: {
                        try {
                            gridX = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 3: {
                        try {
                            gridY = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 9: {
                        county = cell;
                        break;
                    }
                    case 15: {
                        field = cell;
                        break;
                    }
                    case 19: {
                        OCS = cell;
                        break;
                    }
                    case 10: {
                        country = cell;
                        break;
                    }
                    case 6: {
                        operator = cell;
                        break;
                    }
                    case 17: {
                        geodatum = cell;
                        break;
                    }
                    case 11: {
                        try {
                            td = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 16: {
                        try {
                            sb = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 12: {
                        try {
                            rte = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 18: {
                        try {
                            sl = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 20: {
                        try {
                            kicko = Double.parseDouble(cell);
                        }
                        catch (IllegalArgumentException p) {
                            System.out.println(p.getMessage());
                        }
                        break;
                    }
                    case 13: {
                        spud = this.parseDate(cell);
                        break;
                    }
                    case 14: {
                        comp = this.parseDate(cell);
                        break;
                    }
                    case 21: {
                        depthDatum = cell;
                        break;
                    }
                    case 22: {
                        area = cell;
                        break;
                    }
                    case 23: {
                        basin = cell;
                        break;
                    }
                    case 24: {
                        depthUnits = cell;
                    }
                }
                ++i;
            }
            if (name.isBlank() && code.isBlank()) continue;
            WsWell well = ws.addWellToWorkspace(0, null);
            WellHeader wh = new WellHeader();
            System.out.println("Setting well name as: " + name);
            wh.setWellName(name);
            wh.setWellCode(code);
            if (depthUnits != null) {
                units = DepthUnits.parseDepthUnitsFromString((String)depthUnits).getChar();
            }
            wh.setUnits(com.stratadata.util.depth.DepthUnits.getUnits((char)units));
            wh.setWellAltName(altName);
            wh.setCounty(county);
            wh.setField(field);
            wh.setOcs(OCS);
            wh.setCountry(country);
            if (td != null) {
                wh.setTerminalDepth(DepthUtils.convToM((double)td, (char)units));
            }
            if (sb != null) {
                wh.setSeaBed(Double.valueOf(DepthUtils.convToM((double)sb, (char)units)));
            }
            if (sl != null) {
                wh.setSeaLevel(Double.valueOf(DepthUtils.convToM((double)sl, (char)units)));
            }
            if (rte != null) {
                wh.setRotaryTableElevation(Double.valueOf(DepthUtils.convToM((double)rte, (char)units)));
            }
            if (kicko != null) {
                wh.setKickOff(Double.valueOf(DepthUtils.convToM((double)kicko, (char)units)));
            }
            if (gridX != null) {
                wh.setGridX(gridX.doubleValue());
            }
            if (gridY != null) {
                wh.setGridY(gridY.doubleValue());
            }
            if (lat != null) {
                wh.setLat_dec(lat);
            }
            if (lon != null) {
                wh.setLong_dec(lon);
            }
            if (operator != null) {
                wh.setOperator(operator);
            }
            if (geodatum != null) {
                wh.setGeoDatum(geodatum);
            }
            if (basin != null) {
                wh.setBasin(basin);
            }
            if (area != null) {
                wh.setArea(area);
            }
            if (spud != null) {
                wh.setSpudDate(spud.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if (comp != null) {
                wh.setCompletionDate(comp.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if (depthDatum != null && (parsedDatum = WellDatum.parse((String)depthDatum)) != null) {
                wh.setDatum(parsedDatum);
            }
            try {
                well.update(wh);
            }
            catch (InvalidFieldException e) {
                throw new SBException("Error updating well header", (Throwable)e);
            }
            well.loadInterps();
        }
    }

    private double toDouble(Matcher m, int offset) {
        int sign = "".equals(m.group(1 + offset)) ? 1 : -1;
        double degrees = Double.parseDouble(m.group(2 + offset));
        double minutes = Double.parseDouble(m.group(3 + offset));
        double seconds = Double.parseDouble(m.group(4 + offset));
        int direction = "NE".contains(m.group(5 + offset)) ? 1 : -1;
        double dms = (double)(sign * direction) * (degrees + minutes / 60.0 + seconds / 3600.0);
        return (double)Math.round(dms * 1000000.0) / 1000000.0;
    }

    public double convertCoord(String dms, boolean isLatitude) {
        Double dDMS = null;
        if (isLatitude) {
            Matcher mLat = DMS_LAT_PATTERN.matcher(dms.trim());
            if (mLat.matches()) {
                dDMS = this.toDouble(mLat, 0);
            }
        } else {
            Matcher mLong = DMS_LONG_PATTERN.matcher(dms.trim());
            if (mLong.matches()) {
                dDMS = this.toDouble(mLong, 0);
            }
        }
        if (dDMS == null || isLatitude && Math.abs(dDMS) > 90.0 || !isLatitude && Math.abs(dDMS) > 180.0) {
            throw new NumberFormatException("Invalid latitude or longitude");
        }
        return dDMS;
    }

    final Date parseDate(String cell) {
        Date d = null;
        String parseMessage = "";
        boolean parseException = false;
        for (SimpleDateFormat df : this.dfs) {
            try {
                d = df.parse(cell);
                parseException = false;
                break;
            }
            catch (ParseException p) {
                parseException = true;
                parseMessage = p.getMessage();
            }
        }
        if (parseException) {
            try {
                d = new Date(Long.parseLong(cell));
            }
            catch (NumberFormatException p2) {
                System.out.println(parseMessage);
                System.out.println(p2.getMessage());
            }
        }
        return d;
    }
}

