/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.sample.SampleType;
import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import model3.Audit;
import model3.Biocom;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.ImportFileReader;
import model3.ImportFileReaderType;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleInsertException;
import model3.Surface;
import model3.Well;
import model3.WellHeader;
import model3.WellInterp;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellSQPickPetrelXLS
implements ImportFileReader {
    static final int COL_WELL_NAME = 0;
    static final int COL_SURFACE = 1;
    static final int COL_MD = 2;
    static final int COL_INTERPRETER = 3;
    static final int COL_OBS = 4;
    static final int COL_UNITS = 5;
    static final int COL_DATE = 6;
    static final int COL_COMMENT = 7;
    static final ImportFileReader.ImportFileReaderColumn[] COLUMNS = new ImportFileReader.ImportFileReaderColumn[]{new ImportFileReader.ImportFileReaderColumn(0, true, "Well identifier (Well name)", "Well name"), new ImportFileReader.ImportFileReaderColumn(1, true, "Surface"), new ImportFileReader.ImportFileReaderColumn(2, true, "MD"), new ImportFileReader.ImportFileReaderColumn(3, false, "Interpreter"), new ImportFileReader.ImportFileReaderColumn(4, false, "Observation number"), new ImportFileReader.ImportFileReaderColumn(5, false, "depth_unit"), new ImportFileReader.ImportFileReaderColumn(6, false, "pick_date", "last edited"), new ImportFileReader.ImportFileReaderColumn(7, false, "comment")};
    SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    final SBdb ws;

    @Override
    public ImportFileReaderType getType() {
        return ImportFileReaderType.PETREL_SEQUENCE;
    }

    @Override
    public ImportFileReader.ImportFileReaderColumn[] getColumns() {
        return COLUMNS;
    }

    public WellSQPickPetrelXLS() {
        this.ws = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellSQPickPetrelXLS(SBdb ws, File file, Set dataTypes, String country, IGDScheme dbScheme) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        this.ws = ws;
        IGDScheme scheme = IGDScheme.copyToWorkspace(ws, dbScheme);
        ws.addIGDScheme(scheme);
        GridReader in = null;
        WsWell well = null;
        boolean firstRow = true;
        WellInterp wellInterp = null;
        LinkedList<SQPick.Builder> builders = new LinkedList<SQPick.Builder>();
        dataTypes.add(14);
        dataTypes.add(9);
        LinkedList<Biocom.Builder> biocoms = new LinkedList<Biocom.Builder>();
        double totalDepth = 0.0;
        try {
            in = GridReader.getGridReader((String)file.getPath(), null);
            block21: while (in.nextRow()) {
                Biocom.Builder biocom;
                String cell;
                int column;
                if (firstRow) {
                    firstRow = false;
                    column = 0;
                    while ((cell = in.getNextCell()) != null) {
                        this.setArrayIndex(cell, column);
                        ++column;
                    }
                    String strg = this.checkColumns();
                    if (strg == null) continue;
                    throw new SBException("Warning: columns incorrect for this reader: " + strg);
                }
                String wellName = null;
                String pick = null;
                String data_source = null;
                String description = null;
                int pick_obs_no = 0;
                char units = 'M';
                Date date = null;
                column = 0;
                double depth = 0.0;
                while ((cell = in.getNextCell()) != null) {
                    ImportFileReader.ImportFileReaderColumn columnType;
                    if ((columnType = this.getColumn(column++)) == null) continue;
                    switch (columnType.colNumber) {
                        case 0: {
                            wellName = cell;
                            if (!StringUtils.isBlank((CharSequence)wellName)) break;
                            continue block21;
                        }
                        case 1: {
                            pick = cell;
                            break;
                        }
                        case 4: {
                            try {
                                pick_obs_no = Integer.parseInt(cell);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case 2: {
                            try {
                                depth = DepthUtils.convToM((double)Double.parseDouble(cell), (char)units);
                                break;
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Unable to read depth from : " + cell + " for well: " + wellName);
                                continue block21;
                            }
                        }
                        case 5: {
                            if (cell.toUpperCase().startsWith("F")) {
                                units = 'F';
                            }
                        }
                        case 7: {
                            description = cell;
                            break;
                        }
                        case 6: {
                            try {
                                date = this.df.parse(cell);
                            }
                            catch (ParseException e) {
                                long dateLong = Long.parseLong(cell);
                                try {
                                    date = new Date(dateLong);
                                }
                                catch (Exception e2) {
                                    System.out.println("Well: " + wellName + "\tCould not parse date: " + cell + "\n" + e2.getMessage());
                                }
                            }
                            break;
                        }
                        case 3: {
                            data_source = cell;
                            break;
                        }
                    }
                }
                if (wellName == null) {
                    throw new SBException("Well name is null");
                }
                if (well == null || !wellName.equalsIgnoreCase(well.getWellName())) {
                    if (well != null) {
                        this.addPicks(scheme, well, wellInterp, builders, totalDepth);
                        this.addBiocoms(well, wellInterp, biocoms);
                    }
                    well = ws.addWellToWorkspace(0, null);
                    WellHeader wh = well.getHeader();
                    wh.setWellUnits(units);
                    wh.setCountry(country);
                    wh.setDatum(WellDatum.ROTARY_TABLE.getDbInt());
                    well.loadInterps();
                    wh.setWellName(wellName);
                    wh.setWellCode(wellName);
                    wellInterp = well.getInterp(0);
                    totalDepth = 0.0;
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)pick, (CharSequence[])new CharSequence[]{"Total Depth"})) {
                    totalDepth = depth;
                    continue;
                }
                if (well == null) continue;
                SQPick.Builder builder = this.addBuilder(well, depth, scheme, pick, data_source, date);
                if (builder != null) {
                    builders.add(builder);
                }
                if ((biocom = this.addBiocom(well, depth, data_source, description)) == null) continue;
                this.addBiocomToList(biocoms, biocom);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (well != null) {
            this.addPicks(scheme, well, wellInterp, builders, totalDepth);
            this.addBiocoms(well, wellInterp, biocoms);
            Iterator<Well> it = ws.getWellIterator();
            while (it.hasNext()) {
                well = (WsWell)it.next();
                well.updateStatus();
            }
        }
    }

    private SQPick.Builder addBuilder(Well well, double topDepth, IGDScheme scheme, String pick, String description, Date date) throws SBPermissionException, SBException, SQLException, InvalidFieldException {
        Surface surface;
        Sample topSample = well.getSample(topDepth, "LOG", true);
        if (topSample == null) {
            topSample = well.addSample(topDepth, SampleType.LOG, null);
        }
        if ((surface = this.getSurface(scheme, pick)) != null) {
            SQPick.Builder builder = new SQPick.Builder(this.ws, surface, topSample, 3);
            int userID = this.getUserID(this.ws, description);
            builder.audit(new Audit(userID, date, userID, date));
            return builder;
        }
        System.out.println("Can't find surface for pick: " + pick);
        return null;
    }

    private Biocom.Builder addBiocom(Well well, double depth, String dataSource, String description) throws SBPermissionException, SampleInsertException, SQLException {
        Sample sample = well.getSample(depth, "LOG", true);
        if (sample == null) {
            sample = well.addSample(depth, SampleType.LOG, null);
        }
        int analyst = this.getUserID(this.ws, dataSource);
        Biocom.Builder builder = new Biocom.Builder(this.ws, Discipline.MACRO, analyst, sample, description);
        return builder;
    }

    private void addBiocomToList(List<Biocom.Builder> biocoms, Biocom.Builder builder) {
        for (Biocom.Builder b : biocoms) {
            if (b.getTopSample() != builder.getTopSample() || b.getAnalyst() != builder.getAnalyst()) continue;
            if (!b.getText().contains(builder.getText())) {
                b.appendComment(builder.getText());
            }
            return;
        }
        biocoms.add(builder);
    }

    private void addBiocoms(Well well, WellInterp wellInterp, List<Biocom.Builder> biocoms) throws SBPermissionException, SBException, SQLException, InvalidFieldException {
        for (Biocom.Builder biocom : biocoms) {
            wellInterp.insertBiocom(biocom.build());
        }
        biocoms.clear();
    }

    private int getUserID(SBdb ws, String source) throws SQLException {
        int userID = ws.getUserID(source);
        if (userID == 0) {
            ws.getAddUserID(source);
        }
        return userID;
    }

    Surface getSurface(IGDScheme scheme, String pick) throws SQLException, SBException, InvalidFieldException {
        Surface surface = scheme.getSurface(pick);
        if (surface == null) {
            for (Surface s : scheme.getSurfaces()) {
                if (s.getName().contains(".") && s.getName().startsWith(pick)) {
                    surface = s;
                }
                if (!s.getName().endsWith("a") || !s.getName().startsWith(pick)) continue;
                surface = s;
            }
        }
        if (surface == null) {
            IGDUnit unit = scheme.findUnit(pick);
            if (unit == null) {
                unit = scheme.findUnit(pick);
            }
            if (unit != null) {
                Surface.Builder builder = new Surface.Builder(this.ws);
                builder.age(unit.getUage()).audit(unit.getAudit()).name(pick);
                int opt = JOptionPane.showConfirmDialog(null, "Add surface to scheme?: " + builder.getName(), "Add Surface", 1, 3);
                if (opt == 2) {
                    throw new SBException("Import cancelled");
                }
                if (opt == 0) {
                    return scheme.addSurface(builder);
                }
                System.out.println("Surface not added for pick: " + pick);
                return null;
            }
            return null;
        }
        return surface;
    }

    private void addPicks(IGDScheme scheme, Well well, WellInterp wellInterp, List<SQPick.Builder> builders, double totalDepth) throws SBPermissionException, SBException, SQLException {
        for (SQPick.Builder builder : builders) {
            try {
                wellInterp.addSQPick(well, builder);
            }
            catch (InvalidFieldException ex) {
                builder.observed(false);
                try {
                    wellInterp.addSQPick(well, builder);
                }
                catch (InvalidFieldException ex2) {
                    System.out.println("Can't insert: " + String.valueOf(builder.getSurface()) + " into well: " + well.toString() + "\tReason: " + ex.getMessage());
                }
            }
        }
        builders.clear();
    }
}

