/*
 * Decompiled with CFR 0.152.
 */
package model3.exception;

import java.sql.SQLException;
import model3.ConnectionProvider;

public class SuppressedSQLException
extends RuntimeException {
    private boolean hasRolledBack = false;
    private Exception rollbackException;

    private SuppressedSQLException(String msg, SQLException cause) {
        super(msg, cause);
    }

    public static SuppressedSQLException withRollback(String msg, SQLException cause, ConnectionProvider con) {
        SuppressedSQLException r = new SuppressedSQLException(msg, cause);
        try {
            con.doRollback();
            r.hasRolledBack = true;
        }
        catch (Exception e) {
            r.rollbackException = e;
        }
        return r;
    }

    public static SuppressedSQLException withoutRollback(SQLException cause) {
        return new SuppressedSQLException(null, cause);
    }

    public boolean hasRolledBack() {
        return this.hasRolledBack;
    }
}

