/*
 * Decompiled with CFR 0.152.
 */
package model3.organiser;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.sample.SampleType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import model3.AnalystHeader;
import model3.Audit;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class AnnotationReader {
    private static final Logger LOGGER = Logger.getLogger(AnnotationReader.class.getName());
    private final SBdb ws;
    private final WsWell well;
    private int specID = 1;

    public AnnotationReader(SBdb ws, File wellDir) throws IOException, SQLException, SBPermissionException, GridReaderException, SBException {
        this.ws = ws;
        this.well = ws.addWellToWorkspace(0, wellDir.getPath());
        this.well.getHeader().setWellCode(wellDir.getName());
        this.well.getHeader().setWellName(wellDir.getName());
        this.well.getSamples();
        try (Stream<Path> entries = Files.list(wellDir.toPath());){
            for (Path analysis : entries.filter(p -> Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).toList()) {
                this.parseAnalysis(analysis);
            }
        }
    }

    public WsWell getWell() {
        return this.well;
    }

    private void parseAnalysis(Path analyPath) throws IOException, GridReaderException, SQLException, SBException, SBPermissionException {
        String analyFileName = analyPath.getFileName().toString();
        String[] s = analyFileName.split("_");
        if (s.length < 6) {
            return;
        }
        try {
            DepthUnits depthUnits = DepthUnits.parseDepthUnitsFromString((String)s[1]);
            this.well.getHeader().setWellUnits(depthUnits.getChar());
            Sample.Builder sb = Sample.parseDepthString(s[0], depthUnits.getChar(), true, this.ws.useSampleTops());
            sb.type(SampleType.parseType((String)s[2]));
            Sample sample = this.well.getSample(sb);
            if (sample == null) {
                sample = this.well.addSample(sb, 0, null);
            }
            Discipline disc = Discipline.parseDisc((String)s[3]);
            String analyst = s[4];
            int analyNo = Integer.parseInt(s[5]);
            AnalystHeader analystHeader = this.well.getAnalystHeader(analyst, disc.getChar(), analyNo, true);
            Smpdtl smpdtl = new Smpdtl(this.ws, sample, analystHeader, null, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.PREPARED);
            try (Stream<Path> list = Files.list(analyPath);){
                List<Path> csv = list.filter(p -> p.toString().endsWith("csv")).toList();
                HashMap<Integer, TaxonOcc.Builder> occs = new HashMap<Integer, TaxonOcc.Builder>();
                for (Path csvFile : csv) {
                    this.parseCounts(csvFile, occs);
                }
                for (TaxonOcc.Builder b : occs.values()) {
                    try {
                        smpdtl.insertOccurrence(b, this.well.getWellID(), false);
                    }
                    catch (SQLException | SBException e) {
                        LOGGER.log(Level.WARNING, "Unexpected error in workspace", e);
                    }
                }
                if (!smpdtl.getOccurUnsorted().isEmpty()) {
                    smpdtl.updateBarren(this.well.getWellID(), Smpdtl.AnalysisType.ANALYSED, false);
                }
                sample.addDtl(smpdtl);
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Exception parsing analysis file - ignoring this analysis", nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCounts(Path csvFile, HashMap<Integer, TaxonOcc.Builder> occs) throws GridReaderException {
        GridReader reader = GridReader.getGridReader((String)csvFile.toString(), null);
        Integer valueColumn = null;
        int row = 0;
        while (reader.nextRow()) {
            if (row != 0) {
                String cellContents;
                int col = 0;
                while ((cellContents = reader.getNextCell()) != null) {
                    try {
                        Object taxon;
                        if (valueColumn == null) {
                            if (cellContents.isEmpty() || cellContents.toLowerCase().startsWith("annotation") || (taxon = TaxonFactory.parse((String)cellContents)) == null) continue;
                            valueColumn = col;
                        }
                        if (col != valueColumn || StringUtils.isBlank((CharSequence)cellContents)) continue;
                        taxon = this.ws.getTaxon(cellContents, this.specID, true);
                        if (((Taxon)taxon).getSpecID() == this.specID) {
                            ++this.specID;
                        }
                        TaxonOcc.Builder occ = occs.get(((Taxon)taxon).getSpecID());
                        if (occs.get(((Taxon)taxon).getSpecID()) == null) {
                            try {
                                occ = new TaxonOcc.Builder(this.ws, this.ws.getTaxon(((Taxon)taxon).getSpecID()), Situation.INSITU, false, 0);
                                occ.count(1);
                                occs.put(((Taxon)taxon).getSpecID(), occ);
                            }
                            catch (SQLException e) {
                                LOGGER.log(Level.WARNING, "Unexpected error in workspace", e);
                            }
                            continue;
                        }
                        occ.count(occ.getMedium() + 1);
                    }
                    finally {
                        ++col;
                    }
                }
                ++row;
            }
            ++row;
        }
    }
}

