/*
 * Decompiled with CFR 0.152.
 */
package model3.organiser;

import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.SBdb;
import model3.Well;
import model3.WsLithology;
import model3.WsWell;
import util.DepthParseException;
import util.DepthUnits;
import util.DepthUtils;
import util.SBException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class LithologyImporter {
    public LithologyImporter(File file, SBdb ws, SBdb db, LinkedList<WsLithology> wsLithology, Map<WsWell, LinkedList<LithBase>> wells) throws GridReaderException, DepthParseException, SBException, SQLException {
        DepthUnits units = DepthUnits.M;
        boolean header = true;
        Well well = null;
        GridReader reader = GridReader.getGridReader((String)file.getPath(), null);
        while (reader.nextRow()) {
            LinkedList<LithBase> lithIntervals;
            String lithology;
            String baseDepth;
            String topDepth;
            if (header) {
                String value = reader.getNextCell();
                if (value == null || value.trim().isEmpty()) continue;
                if ((value = value.trim()).startsWith("#")) {
                    if (!value.contains("Units")) continue;
                    if (value.contains("metres")) {
                        units = DepthUnits.M;
                        continue;
                    }
                    if (!value.contains("feet")) continue;
                    units = DepthUnits.F;
                    continue;
                }
                if (!value.startsWith("Well")) continue;
                header = false;
                continue;
            }
            String wellName = reader.getNextCell();
            if (wellName == null || reader.getNextCell() == null || reader.getNextCell() == null || (topDepth = reader.getNextCell()) == null || (baseDepth = reader.getNextCell()) == null || (lithology = reader.getNextCell()) == null) continue;
            Double top = DepthUtils.parseDepthString((String)topDepth, (char)units.getChar());
            Double base = DepthUtils.parseDepthString((String)baseDepth, (char)units.getChar());
            if (base - top < (double)0.0029f || (wellName = wellName.trim()).isEmpty()) continue;
            if (well == null || !wellName.equals(well.getWellName())) {
                well = ws.addWellToWorkspace(0, null);
                well.loadInterps();
                well.getHeader().setWellName(wellName);
                well.getHeader().setWellCode(wellName);
                wells.put((WsWell)well, new LinkedList());
            }
            if ((lithIntervals = wells.get(well)) == null) {
                System.out.println("Lith Interval list null for well: " + String.valueOf(well));
                continue;
            }
            this.addInterval(ws, wsLithology, lithIntervals, top, base, lithology, 0);
        }
    }

    private void addInterval(SBdb ws, LinkedList<WsLithology> wsLiths, LinkedList<LithBase> intervals, double topDepth, double baseDepth, String mnem, int code) throws SBException, SQLException {
        WsLithology lith = null;
        for (WsLithology wsl : wsLiths) {
            if (code > 0) {
                if (wsl.getCode() != code) continue;
                lith = wsl;
                break;
            }
            if (!wsl.getDescription().equals(mnem)) continue;
            lith = wsl;
            break;
        }
        if (lith == null) {
            lith = new WsLithology(mnem, code);
            wsLiths.add(lith);
        }
        intervals.add(new LithInterval(ws, topDepth, baseDepth, lith));
    }

    public void addIntervals(Map<WsWell, LinkedList<LithBase>> wells) throws SBException, SQLException {
        for (WsWell well : wells.keySet()) {
            List lithIntervals = wells.get(well);
            if (lithIntervals == null) continue;
            for (LithBase lithInterval : lithIntervals) {
                WsLithology wslith = (WsLithology)lithInterval.getLithology();
                if (wslith.getLink() == null) continue;
                lithInterval.setLithology(lithInterval.getLithology());
                if (wslith.getLink().isQual()) {
                    lithInterval = new LithQualifier(well.getDataModel(), (lithInterval.getTopDepth() + ((LithInterval)lithInterval).getBaseDepth()) / 2.0, wslith, 'C', 0.0f);
                }
                well.insertLithInterval(lithInterval);
            }
        }
    }
}

