/*
 * Decompiled with CFR 0.152.
 */
package model3.project;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import model3.Audit;
import model3.SBRestrictable;
import model3.SBdb;
import model3.project.ProjectObserver;
import util.SB;
import util.SBPermissionException;
import util.listener.WeakListenerList;

public class Project
extends com.stratadata.model3.project.Project {
    private Audit audit;
    private final WeakListenerList<ProjectObserver> listeners = new WeakListenerList();

    public Project(int projID, String name, String descr, Audit audit) {
        super(projID, name, descr);
        assert (projID > 0);
        assert (name != null && !name.isEmpty());
        assert (audit != null);
        this.audit = audit;
    }

    public Date getUpdated() {
        return this.audit.getUpdated();
    }

    public void addListener(ProjectObserver listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(ProjectObserver listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public List<ProjectObserver> getListeners() {
        return this.listeners.getListeners();
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void update(SBdb sbdb, String name, String descr) throws SQLException, SBPermissionException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Attempt to change project name to " + name);
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("PROJECT") + " SET name=" + SB.DBString((String)name) + ",descr=" + SB.DBString((String)descr) + "," + temp.sqlUpdate(sbdb, stmt, false) + " WHERE proj_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.setName(name);
            this.setDescription(descr);
            this.audit = temp;
        }
        this.listeners.getListeners().forEach(l -> l.projectDetailsChanged(this));
    }

    public void updateAudit(SBdb sbdb) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("PROJECT") + " SET " + temp.sqlUpdate(sbdb, stmt, false) + " WHERE proj_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.audit = temp;
        }
    }

    public void store(SBdb sbdb) throws SQLException, SBPermissionException {
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new IllegalStateException("Attempt to store well list with no name");
        }
        if (this.getID() <= 0) {
            throw new IllegalStateException("Attempt to store well list with illegal ID: " + this.getID());
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("PROJECT") + " (proj_id,name,descr," + Audit.sqlFieldString() + ") VALUES (" + this.getID() + "," + SB.DBString((String)this.getName()) + "," + SB.DBString((String)this.getDescription()) + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    public void delete(SBdb sbdb) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + sbdb.DBTableName("PROJECT") + " WHERE proj_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }
}

