/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.SB;

public enum AgeFormat {
    MA("Ma", 1.0, 6),
    KA("Ka", 1000.0, 3);

    String descr;
    double multiplyer;
    int precision;

    private AgeFormat(String descr, double multiplyer, int precision) {
        this.descr = descr;
        this.multiplyer = multiplyer;
        this.precision = precision;
    }

    public String getDescr() {
        return this.descr;
    }

    public double getMultiplyer() {
        return this.multiplyer;
    }

    public int getPrecision() {
        return this.precision;
    }

    public double getMinRepresentableValue() {
        return Math.pow(0.1, this.precision);
    }

    public String toAgeString(double age, int dp, boolean descriptor) {
        Object str = SB.floatString(age *= this.multiplyer, dp).trim();
        if (descriptor) {
            str = (String)str + " " + this.descr;
        }
        return str;
    }

    public String toAgeString(double age, int dp) {
        return this.toAgeString(age, dp, true);
    }
}

