/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Locale;
import util.DepthParseException;
import util.DepthUnits;

public class DepthUtils {
    private static final double DEPTH_TOLERANCE = 0.003048;
    public static final double FT_PER_M = 0.3048;

    private DepthUtils() {
    }

    public static boolean equalWithinTolerance(double d1, double d2) {
        double diff = Math.abs(d2 - d1);
        return diff < 0.006096;
    }

    public static boolean gtOrEqWithinTolerance(double depth, double comp) {
        if (DepthUtils.equalWithinTolerance(depth, comp)) {
            return true;
        }
        return depth > comp;
    }

    public static boolean ltOrEqWithinTolerance(double depth, double comp) {
        if (DepthUtils.equalWithinTolerance(depth, comp)) {
            return true;
        }
        return depth < comp;
    }

    public static double convToM(double value, char units) {
        if (DepthUnits.getUnits(units) == DepthUnits.F) {
            value *= 0.3048;
        }
        if (units > '\u0000') {
            value = (double)Math.round(value * 1000.0) / 1000.0;
        }
        return value;
    }

    public static float convToM(float value, char units) {
        if (DepthUnits.getUnits(units) == DepthUnits.F) {
            value *= 0.3048f;
        }
        if (units > '\u0000') {
            value = (float)Math.round(value * 1000.0f) / 1000.0f;
        }
        return value;
    }

    public static double convToM(double value, char units, char type) {
        value = DepthUtils.convToM(value, units);
        return value * (double)DepthUtils.getSectionTypeConversion(type);
    }

    public static double convToM(float value, char units, char type) {
        value = DepthUtils.convToM(value, units);
        return value * (float)DepthUtils.getSectionTypeConversion(type);
    }

    public static int getSectionTypeConversion(char sectionType) {
        switch (sectionType) {
            case 'O': 
            case 'o': {
                return -1;
            }
        }
        return 1;
    }

    public static double convFromM(double value, char units) {
        if (DepthUnits.getUnits(units) == DepthUnits.F) {
            value /= (double)0.3048f;
            value = (double)Math.round(value * 100.0) / 100.0;
        }
        return value;
    }

    public static float convFromM(float value, char units) {
        if (DepthUnits.getUnits(units) == DepthUnits.F) {
            value /= 0.3048f;
            value = (float)Math.round(value * 100.0f) / 100.0f;
        }
        return value;
    }

    public static double convFromM(double value, char units, char type) {
        if (Math.abs(value = DepthUtils.convFromM(value, units)) > 0.0) {
            value *= (double)DepthUtils.getSectionTypeConversion(type);
        }
        return value;
    }

    public static float convFromM(float value, char units, char type) {
        if (Math.abs(value = DepthUtils.convFromM(value, units)) > 0.0f) {
            value *= (float)DepthUtils.getSectionTypeConversion(type);
        }
        return value;
    }

    public static double parseDepthString(String strg, boolean reverseSign) throws DepthParseException {
        double d = DepthUtils.parseDepthString(strg, 'M');
        return reverseSign ? -d : d;
    }

    public static double parseDepthString(String strg) throws DepthParseException {
        return DepthUtils.parseDepthString(strg, 'M');
    }

    public static double parseDepthString(String strg, char defaultUnits) throws DepthParseException {
        if ((strg = strg.trim()).isEmpty()) {
            return 0.0;
        }
        strg = strg.toLowerCase(Locale.UK);
        strg = strg.replace(" ", "");
        try {
            if (strg.endsWith("m")) {
                return Double.parseDouble(strg.substring(0, strg.indexOf(109)));
            }
            if (strg.indexOf(34) >= 0) {
                throw new DepthParseException("Attempt to parse feet & inches in string: " + strg);
            }
            if (strg.endsWith("'")) {
                return DepthUtils.convToM(Double.parseDouble(strg.substring(0, strg.indexOf(39))), 'F');
            }
            if (strg.endsWith("f") || strg.endsWith("ft")) {
                return DepthUtils.convToM(Double.parseDouble(strg.substring(0, strg.indexOf(102))), 'F');
            }
            return DepthUtils.convToM(Double.parseDouble(strg), defaultUnits);
        }
        catch (NumberFormatException e) {
            throw new DepthParseException("Cannot parse depth string: " + strg, e);
        }
    }
}

