/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    private NumberUtils() {
    }

    public static double significantDigitRounder(double value, int nSigDig, int dir) {
        double intermediate = value / Math.pow(10.0, Math.floor(Math.log10(Math.abs(value))) - (double)(nSigDig - 1));
        intermediate = dir > 0 ? Math.ceil(intermediate) : (dir < 0 ? Math.floor(intermediate) : (double)Math.round(intermediate));
        double result = intermediate * Math.pow(10.0, Math.floor(Math.log10(Math.abs(value))) - (double)(nSigDig - 1));
        return result;
    }

    public static Double maxDouble(Double defaultValue, Double ... values) {
        Double maxVal = null;
        for (Double D : values) {
            if (D == null || maxVal != null && !(D > maxVal)) continue;
            maxVal = D;
        }
        if (defaultValue != null && (maxVal == null || defaultValue > maxVal)) {
            maxVal = defaultValue;
        }
        return maxVal != null ? maxVal : defaultValue;
    }

    public static Double minDouble(Double defaultValue, Double ... values) {
        Double minVal = null;
        for (Double D : values) {
            if (D == null || minVal != null && !(D < minVal)) continue;
            minVal = D;
        }
        if (defaultValue != null && (minVal == null || defaultValue < minVal)) {
            minVal = defaultValue;
        }
        return minVal != null ? minVal : defaultValue;
    }

    public static boolean allEqual(float ... values) {
        Float lastValue = null;
        for (float f : values) {
            if (lastValue == null) {
                lastValue = Float.valueOf(f);
                continue;
            }
            if (!((double)Math.abs(f - lastValue.floatValue()) > 0.001)) continue;
            return false;
        }
        return true;
    }

    public static Double tryParseDouble(String s) {
        Double result;
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            result = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException ex) {
            result = null;
        }
        return result;
    }

    public static Float tryParseFloat(String s) {
        Float result;
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            result = Float.valueOf(Float.parseFloat(s.trim()));
        }
        catch (NumberFormatException ex) {
            result = null;
        }
        return result;
    }

    public static Integer tryParseInteger(String s) {
        Integer result;
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            result = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException ex) {
            result = null;
        }
        return result;
    }

    public static Double roundValue(Double value, int numDecimalPlaces) {
        if (value == null) {
            return null;
        }
        return BigDecimal.valueOf(value).setScale(numDecimalPlaces, 4).doubleValue();
    }

    public static Float roundValue(Float value, int numDecimalPlaces) {
        if (value == null) {
            return null;
        }
        return Float.valueOf((float)BigDecimal.valueOf(value.floatValue()).setScale(numDecimalPlaces, 4).doubleValue());
    }
}

