/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RectUtils {
    public static Rectangle2D.Float copyRect(Rectangle2D.Float a) {
        return new Rectangle2D.Float(a.x, a.y, a.width, a.height);
    }

    public static Rectangle2D.Float getRectWithBorder(Rectangle2D.Float a, float border) {
        Rectangle2D.Float b = RectUtils.copyRect(a);
        b.x -= border;
        b.y -= border;
        b.width += 2.0f * border;
        b.height += 2.0f * border;
        return b;
    }

    public static Rectangle2D.Float makeSmallerRect(Rectangle2D.Float a, float border) {
        Rectangle2D.Float b = RectUtils.copyRect(a);
        b.x += border;
        b.y += border;
        b.width -= 2.0f * border;
        b.height -= 2.0f * border;
        return b;
    }

    public static Rectangle2D.Float calculateContainingRectanlge(Rectangle2D.Float a, Rectangle2D.Float b) {
        Rectangle2D.Float container = new Rectangle2D.Float();
        container.x = Math.min(a.x, b.x);
        container.y = Math.min(a.y, b.y);
        float maxY = Math.max(a.y + a.height, b.y + b.height);
        float maxX = Math.max(a.x + a.width, b.x + b.width);
        container.height = maxY - container.y;
        container.width = maxX - container.x;
        return container;
    }

    public static Rectangle2D.Float calculateRectShrunkFromLeft(Rectangle2D.Float a, float ammount) {
        Rectangle2D.Float newRect = RectUtils.copyRect(a);
        RectUtils.shrinkRectFromLeft(newRect, ammount);
        return newRect;
    }

    public static void shrinkRectFromLeft(Rectangle2D.Float a, float ammount) {
        a.x += ammount;
        a.width -= ammount;
    }

    public static void shrinkRectFromTop(Rectangle2D.Float a, float ammount) {
        a.y += ammount;
        a.height -= ammount;
    }

    public static void enlargeRectFromTop(Rectangle2D.Float a, float amount) {
        a.y -= amount;
        a.height += amount;
    }

    public static Rectangle rectangleExtendedLeft(Rectangle rectangleToExtend, int ammount) {
        return new Rectangle(rectangleToExtend.x - ammount, rectangleToExtend.y, rectangleToExtend.width + ammount, rectangleToExtend.height);
    }

    public static Rectangle rectangleExtendedUp(Rectangle rectangleToExtend, int ammount) {
        return new Rectangle(rectangleToExtend.x, rectangleToExtend.y - ammount, rectangleToExtend.width, rectangleToExtend.height + ammount);
    }

    public static Point2D.Float moveRectNextToTarget(Rectangle2D.Float target, Rectangle2D.Float rect, float padding) {
        Point2D.Float p = new Point2D.Float(rect.x, rect.y);
        if (target.intersects(rect)) {
            if (rect.getCenterX() <= target.getCenterX()) {
                p.x = target.x - rect.width;
            } else if (rect.getCenterX() > target.getCenterX()) {
                p.x = target.x + target.width;
            }
            if (rect.getCenterY() <= target.getCenterY()) {
                p.y = target.y - rect.height;
            } else if (rect.getCenterY() > target.getCenterY()) {
                p.y = target.y + target.height;
            }
        } else {
            float maxAllowedX = target.x + target.width + padding;
            float minAllowedX = target.x - rect.width - padding;
            p.x = RectUtils.clamp(Float.valueOf(p.x), Float.valueOf(minAllowedX), Float.valueOf(maxAllowedX)).floatValue();
            float maxAllowedY = target.y + target.height + padding;
            float minAllowedY = target.y - rect.height - padding;
            p.y = RectUtils.clamp(Float.valueOf(p.y), Float.valueOf(minAllowedY), Float.valueOf(maxAllowedY)).floatValue();
        }
        return p;
    }

    private static Float clamp(Float val, Float min, Float max) {
        return Float.valueOf(Math.max(min.floatValue(), Math.min(max.floatValue(), val.floatValue())));
    }
}

