/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class TextStroke
implements Stroke {
    private String text;
    private Font font;
    private boolean stretchToFit = false;
    private boolean repeat = false;
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;
    final float strokeWidth;
    final BasicStroke basicStroke;

    public TextStroke(String text, Font font) {
        this(text, font, true, false, 0.0f);
    }

    public TextStroke(String text, Font font, boolean stretchToFit, boolean repeat, float strokeWidth) {
        this.text = text;
        this.font = font;
        this.stretchToFit = stretchToFit;
        this.repeat = repeat;
        this.strokeWidth = strokeWidth > 0.0f ? strokeWidth : 1.0f;
        this.basicStroke = new BasicStroke(strokeWidth, 0, 0);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = this.font.createGlyphVector(frc, this.text);
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        boolean first = false;
        int currentChar = 0;
        int length = glyphVector.getNumGlyphs();
        if (length == 0) {
            return result;
        }
        GeneralPath lineBefore = new GeneralPath();
        GeneralPath lineAfter = new GeneralPath();
        float pathLength = this.measurePathLength(shape);
        if (glyphVector.getLogicalBounds().getWidth() > (double)(pathLength - this.strokeWidth * 2.0f)) {
            while (glyphVector.getLogicalBounds().getWidth() >= (double)(pathLength - this.strokeWidth * 2.0f)) {
                this.text = this.text.substring(0, this.text.length() - 1);
                String s = this.text + "..";
                glyphVector = this.font.createGlyphVector(frc, s);
                length = s.length();
                if (!this.text.isEmpty()) continue;
                break;
            }
        }
        float next = pathLength / 2.0f - (float)(glyphVector.getLogicalBounds().getWidth() / 2.0);
        float factor = this.stretchToFit ? pathLength / (float)glyphVector.getLogicalBounds().getWidth() : 1.0f;
        float nextAdvance = 0.0f;
        float glyphHeight = (float)glyphVector.getLogicalBounds().getHeight();
        while (!it.isDone()) {
            int type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    result.moveTo(moveX, moveY);
                    lineBefore.moveTo(moveX, moveY);
                    first = true;
                    nextAdvance = glyphVector.getGlyphMetrics(currentChar).getAdvance() * 0.5f;
                    next += nextAdvance;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    float thisX = points[0];
                    float thisY = points[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        float angle = (float)Math.atan2(dy, dx);
                        boolean drawnGlyph = false;
                        while (currentChar < length && distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            Shape glyph = glyphVector.getGlyphOutline(currentChar);
                            Point2D p = glyphVector.getGlyphPosition(currentChar);
                            float px = (float)p.getX();
                            float py = (float)p.getY();
                            float advance = nextAdvance;
                            if (first) {
                                float xOffset = (next - nextAdvance - this.strokeWidth) * dx * r;
                                float yOffset = (next - nextAdvance - this.strokeWidth) * dy * r;
                                if (xOffset > 0.0f) {
                                    lineBefore.lineTo(lastX + xOffset, lastY + yOffset);
                                } else {
                                    lineBefore = this.replaceLastPoint(lineBefore, lastX + xOffset, lastY + yOffset);
                                }
                                result.append(this.basicStroke.createStrokedShape(lineBefore), false);
                                first = false;
                            }
                            nextAdvance = currentChar < length - 1 ? glyphVector.getGlyphMetrics(currentChar + 1).getAdvance() * 0.5f : 0.0f;
                            this.t.setToTranslation(x, y);
                            this.t.rotate(angle);
                            this.t.translate(-px - advance, (double)(-py) + (double)glyphHeight * 0.3);
                            result.append(this.t.createTransformedShape(glyph), false);
                            next += (advance + nextAdvance) * factor;
                            ++currentChar;
                            if (this.repeat) {
                                currentChar %= length;
                            }
                            if (currentChar == length) {
                                float moveToX = lastX + (next + this.strokeWidth) * dx * r;
                                lineAfter.moveTo(moveToX, lastY + (next + this.strokeWidth) * dy * r);
                                if (moveToX < thisX) {
                                    lineAfter.lineTo(thisX, thisY);
                                }
                            }
                            drawnGlyph = true;
                        }
                        if (currentChar == length && !drawnGlyph) {
                            lineAfter.lineTo(thisX, thisY);
                        }
                    } else {
                        lineBefore.lineTo(thisX, thisY);
                    }
                    next -= distance;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        result.append(this.basicStroke.createStrokedShape(lineAfter), false);
        return result;
    }

    public float measurePathLength(Shape shape) {
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float total = 0.0f;
        while (!it.isDone()) {
            switch (it.currentSegment(points)) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    float dx = points[0] - lastX;
                    float dy = points[1] - lastY;
                    total += (float)Math.sqrt(dx * dx + dy * dy);
                    lastX = points[0];
                    lastY = points[1];
                }
            }
            it.next();
        }
        return total;
    }

    private GeneralPath replaceLastPoint(GeneralPath p, float newX, float newY) {
        PathIterator it = p.getPathIterator(null);
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        boolean hasMovedTo = false;
        while (!it.isDone()) {
            int pathType = it.currentSegment(coords);
            it.next();
            if (it.isDone()) continue;
            switch (pathType) {
                case 0: {
                    newPath.moveTo(coords[0], coords[1]);
                    hasMovedTo = true;
                    break;
                }
                case 1: {
                    newPath.lineTo(coords[0], coords[1]);
                }
            }
        }
        if (hasMovedTo) {
            newPath.lineTo(newX, newY);
        } else {
            newPath.moveTo(newX, newY);
        }
        return newPath;
    }
}

