/*
 * Decompiled with CFR 0.152.
 */
package util;

import org.apache.commons.lang3.StringUtils;

public class TextTableMaker {
    private final String newline;

    public TextTableMaker() {
        this("\n");
    }

    public TextTableMaker(String newline) {
        this.newline = newline;
    }

    public String buildTable(Object[][] data) {
        StringBuilder sb = new StringBuilder();
        int ncol = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length <= ncol) continue;
            ncol = data[i].length;
        }
        int[] widths = new int[ncol];
        for (int col = 0; col < ncol; ++col) {
            int max = 0;
            for (int i = 0; i < data.length; ++i) {
                int l;
                if (col >= data[i].length || data[i][col] == null || (l = data[i][col].toString().length()) <= max) continue;
                max = l;
            }
            widths[col] = max;
        }
        for (int i = 0; i < data.length; ++i) {
            StringBuilder line = new StringBuilder();
            for (int j = 0; j < data[i].length; ++j) {
                Object o;
                Object format = "%s ";
                if (widths[j] > 0) {
                    format = "%-" + widths[j] + "s ";
                }
                if ((o = data[i][j]) == null) {
                    o = "";
                }
                line.append(String.format((String)format, o));
            }
            sb.append(StringUtils.stripEnd((String)line.toString(), (String)" "));
            sb.append(this.newline);
        }
        return sb.toString();
    }
}

