/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    private Character delimiter;
    private static Character[] POSSIBLE_DELIMS = new Character[]{Character.valueOf(','), Character.valueOf('\t'), Character.valueOf(';')};

    public CSVReader() {
        this.delimiter = null;
    }

    public CSVReader(Character delimiter) {
        this.delimiter = delimiter;
    }

    public List<List<String>> readData(Reader in) throws IOException {
        String line;
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        BufferedReader br = new BufferedReader(in);
        Character delim = this.delimiter;
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) continue;
            if (delim == null) {
                delim = this.guessDelim(line);
            }
            rows.add(this.readLine(line, delim));
        }
        return rows;
    }

    private Character guessDelim(String line) {
        Character delim = POSSIBLE_DELIMS[0];
        int max = 0;
        for (Character d : POSSIBLE_DELIMS) {
            int count = line.length() - line.replace(d.toString(), "").length();
            if (count <= max) continue;
            max = count;
            delim = d;
        }
        return delim;
    }

    private List<String> readLine(String line, Character delim) {
        ArrayList<String> values = new ArrayList<String>();
        boolean quotedValue = false;
        boolean dontTrim = false;
        StringBuilder value = new StringBuilder();
        char[] lineArray = line.toCharArray();
        for (int i = 0; i < lineArray.length; ++i) {
            char c = lineArray[i];
            if (c == delim.charValue() && !quotedValue) {
                this.addValue(values, value);
                value = new StringBuilder();
                continue;
            }
            value.append(c);
            if (c != '\"') continue;
            if (!quotedValue) {
                quotedValue = true;
                continue;
            }
            if (i + 1 < lineArray.length && lineArray[i + 1] == '\"') {
                ++i;
                continue;
            }
            quotedValue = false;
        }
        if (lineArray[lineArray.length - 1] != delim.charValue()) {
            this.addValue(values, value);
        }
        return values;
    }

    private void addValue(List<String> values, StringBuilder value) {
        String v = value.toString().trim();
        v = v.replaceAll("^\"|\"$", "");
        values.add(v);
    }
}

