/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;

public class TableRow {
    private final List<String> values;
    private NumberFormat nf;

    public TableRow(List<String> rowValues) {
        this.values = rowValues;
        this.nf = NumberFormat.getNumberInstance();
    }

    protected void setNumberFormat(NumberFormat nf) {
        this.nf = nf;
    }

    public String get(int col) {
        if (this.values.size() <= col || col < 0) {
            return null;
        }
        return this.values.get(col);
    }

    public Double getDouble(int col) {
        String strValue = this.get(col);
        Double value = null;
        if (strValue != null) {
            try {
                value = this.nf.parse(strValue).doubleValue();
            }
            catch (ParseException ex) {
                value = null;
            }
        }
        return value;
    }

    public Float getFloat(int col) {
        String strValue = this.get(col);
        Float value = null;
        if (strValue != null) {
            try {
                value = Float.valueOf(this.nf.parse(strValue).floatValue());
            }
            catch (ParseException ex) {
                value = null;
            }
        }
        return value;
    }

    public int size() {
        return this.values.size();
    }
}

