/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class CSVExportOptions {
    private char decimalSeparator;
    private char columnDelimiter;
    private int minFractionalDigits;
    private int maxFractionalDigits;

    public CSVExportOptions() {
        this.decimalSeparator = (char)46;
        this.columnDelimiter = (char)44;
        this.minFractionalDigits = 2;
        this.maxFractionalDigits = 6;
    }

    public CSVExportOptions(char columnDelimiter, char decimalSeparator, int minFractionalDigits, int maxFractionalDigits) {
        this.decimalSeparator = decimalSeparator;
        this.columnDelimiter = columnDelimiter;
        this.minFractionalDigits = minFractionalDigits;
        this.maxFractionalDigits = maxFractionalDigits;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public int getMinFractionalDigits() {
        return this.minFractionalDigits;
    }

    public int getMaxFractionalDigits() {
        return this.maxFractionalDigits;
    }

    public CSVExportOptions setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        return this;
    }

    public CSVExportOptions setColumnDelimiter(char columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        return this;
    }

    public CSVExportOptions setMinFractionalDigits(int minFractionalDigits) {
        this.minFractionalDigits = minFractionalDigits;
        return this;
    }

    public CSVExportOptions setMaxFractionalDigits(int maxFractionalDigits) {
        this.maxFractionalDigits = maxFractionalDigits;
        return this;
    }

    public NumberFormat buildNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            dfs.setDecimalSeparator(this.decimalSeparator);
            df.setDecimalFormatSymbols(dfs);
            df.setMinimumFractionDigits(this.minFractionalDigits);
            df.setMaximumFractionDigits(this.maxFractionalDigits);
            df.setGroupingUsed(false);
        }
        return nf;
    }
}

