/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import util.FilePathUtils;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.CSVWriter;
import util.gridwriter.XLSExportOptions;
import util.gridwriter.XLSGridWriter;

public class GridWriter {
    private final CSVWriter csvWriter = new CSVWriter();
    private final XLSGridWriter xlsWriter = new XLSGridWriter();

    public void setCSVOptions(CSVExportOptions options) {
        this.csvWriter.setOptions(options);
    }

    public void setXLSOptions(XLSExportOptions options) {
        this.xlsWriter.setOptions(options);
    }

    public XLSExportOptions getXLSOptions() {
        return this.xlsWriter.getOptions();
    }

    public void write(File outputFile, Object[][] data) throws IOException {
        String fileExt = FilePathUtils.getFileExtension(outputFile.getPath());
        if (fileExt.equals("xls") || fileExt.equals("xlsx")) {
            this.xlsWriter.write(outputFile, data);
        } else {
            try (FileWriter out = new FileWriter(outputFile);){
                this.csvWriter.writeCSVData(out, data);
            }
        }
    }
}

