/*
 * Decompiled with CFR 0.152.
 */
package util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorEditor
extends DefaultCellEditor {
    private Color currentColor = null;

    private ColorEditor(JButton b) {
        super(new JCheckBox());
        this.editorComponent = b;
        b.addActionListener(new ActionListener(this){
            final /* synthetic */ ColorEditor this$0;
            {
                ColorEditor colorEditor = this$0;
                Objects.requireNonNull(colorEditor);
                this.this$0 = colorEditor;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.fireEditingStopped();
            }
        });
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JButton)this.editorComponent).setText(value.toString());
        this.currentColor = (Color)value;
        return this.editorComponent;
    }

    public static void hideTransparencyControls(JColorChooser cc) {
        AbstractColorChooserPanel[] colorPanels = cc.getChooserPanels();
        for (int i = 0; i < colorPanels.length; ++i) {
            AbstractColorChooserPanel cp = colorPanels[i];
            try {
                Field f = cp.getClass().getDeclaredField("panel");
                f.setAccessible(true);
                Object colorPanel = f.get(cp);
                Field f2 = colorPanel.getClass().getDeclaredField("spinners");
                f2.setAccessible(true);
                Object sliders = f2.get(colorPanel);
                Object transparencySlider = Array.get(sliders, 3);
                if (i == colorPanels.length - 1) {
                    transparencySlider = Array.get(sliders, 4);
                }
                Method setVisible = transparencySlider.getClass().getDeclaredMethod("setVisible", Boolean.TYPE);
                setVisible.setAccessible(true);
                setVisible.invoke(transparencySlider, false);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setUpColorEditor(JTable table) {
        ColorEditor.setUpColorEditor(table, false);
    }

    public static void setUpColorEditor(JTable table, boolean showTransparencyControls) {
        final JButton button = new JButton(""){

            @Override
            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(button);
        colorEditor.setClickCountToStart(2);
        table.setDefaultEditor(Color.class, colorEditor);
        final JColorChooser colorChooser = new JColorChooser();
        if (!showTransparencyControls) {
            ColorEditor.hideTransparencyControls(colorChooser);
        }
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorEditor.currentColor = colorChooser.getColor();
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Colour", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorEditor.currentColor);
                colorChooser.setColor(colorEditor.currentColor);
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });
    }
}

