/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Date;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.RelativePosition;
import org.geotools.api.temporal.TemporalPrimitive;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.temporal.object.DefaultTemporalGeometricPrimitive;
import org.geotools.util.Utilities;

public class DefaultPeriod
extends DefaultTemporalGeometricPrimitive
implements Period {
    private Instant begining;
    private Instant ending;

    public DefaultPeriod(Instant begining, Instant ending) {
        if (!begining.relativePosition((TemporalPrimitive)ending).equals((Object)RelativePosition.BEFORE)) {
            throw new IllegalArgumentException("The temporal position of the beginning of the period must be less than (i.e. earlier than) the temporal position of the end of the period");
        }
        this.begining = begining;
        this.ending = ending;
    }

    public Instant getBeginning() {
        return this.begining;
    }

    public void setBegining(Instant begining) {
        this.begining = begining;
    }

    public void setBegining(Date date) {
        this.begining = new DefaultInstant(new DefaultPosition(date));
    }

    public Instant getEnding() {
        return this.ending;
    }

    public void setEnding(Instant ending) {
        this.ending = ending;
    }

    public void setEnding(Date date) {
        this.ending = new DefaultInstant(new DefaultPosition(date));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriod) {
            DefaultPeriod that = (DefaultPeriod)object;
            return Utilities.equals((Object)this.begining, (Object)that.begining) && Utilities.equals((Object)this.ending, (Object)that.ending);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.begining != null ? this.begining.hashCode() : 0);
        hash = 37 * hash + (this.ending != null ? this.ending.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.begining != null) {
            s.append("begin:").append(this.begining);
        }
        if (this.ending != null) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append("end:").append(this.ending);
        }
        return s.insert(0, "Period{").append('}').toString();
    }
}

