
/* Additional script for creating the tables to support WITSML queries */

/* Web services table - index of services available and the URL */
CREATE TABLE WS_SERVERS (
    ID          SMALLINT NOT NULL,
    TYPE        NVARCHAR(30),
    NAME        NVARCHAR(30),
    URL         NVARCHAR(512),
    CREDENTIALS BIT DEFAULT 1,
    PROXY       BIT DEFAULT 0,
    CONSTRAINT WS_SERVERS_PK PRIMARY KEY (ID)
);

/* WITSML table, stores uids against sbugs well_ids for log curves
   curves are retrieved per log suite, so there might be more than one mnemonic per log for multiple curves */
CREATE TABLE WITSML_CURVE (
    CURVE_ID     INT NOT NULL,
    WELL_ID      INT NOT NULL,
    WS_ID        SMALLINT  NOT NULL,
    WELL_UID     NVARCHAR(80),
    WELLBORE_UID NVARCHAR(80),
    LOG_UID      NVARCHAR(80),
    MNEMONIC     NVARCHAR(60), /* Used to select curve from server, can be depth index */
    ABR          NVARCHAR(10), /* Links to logdef.abr. If null, then this entry is the depth index for the log suite */
    UNITS        NVARCHAR(20), /* Units from the curve information, used to convert into metres */
    CONSTRAINT WITSML_CURVE_PK PRIMARY KEY (CURVE_ID),
    CONSTRAINT WITSML_CURVE_FK1 FOREIGN KEY (WELL_ID) REFERENCES WELLS (WELL_ID),
    CONSTRAINT WITSML_CURVE_FK2 FOREIGN KEY (ABR) REFERENCES LOGDEF (ABR),
    CONSTRAINT WITSML_CURVE_FK3 FOREIGN KEY (WS_ID) REFERENCES WS_SERVERS (ID)
);

/* Grants, if necessary
GRANT SELECT,INSERT,UPDATE,DELETE ON WS_SERVERS TO SBUGS_USER;
GRANT SELECT,INSERT,UPDATE,DELETE ON WITSML_CURVE TO SBUGS_USER;
 */
